# brew cask

> Package manager for macOS applications distributed as binaries.

- Search for formulas and casks:

`brew search {{text}}`

- Install a cask:

`brew cask install {{cask_name}}`

- List all installed casks:

`brew cask list`

- List installed casks that have newer versions available:

`brew cask outdated`

- Upgrade an installed cask to its latest version:

`brew cask upgrade {{cask_name}}`

- Uninstall a cask:

`brew cask uninstall {{cask_name}}`

- Uninstall a cask and remove related settings and files:

`brew cask zap {{cask_name}}`

- Display information about a given cask:

`brew cask info {{cask_name}}`
