# k6

> A modern load testing tool, using Go and JavaScript.

- Run load test locally:

`k6 run {{script.js}}`

- Run load test locally with a given number of virtual users and duration:

`k6 run --vus {{10}} --duration {{30s}} {{script.js}}`

- Run load test locally with a given environment variable:

`k6 run -e {{HOSTNAME=example.com}} {{script.js}}`

- Run load test locally using InfluxDB to store results:

`k6 run --out influxdb={{http://localhost:8086/k6db}} {{script.js}}`

- Login to cloud service using secret token:

`k6 login cloud --token {{secret}}`

- Run load test on cloud infrastructure:

`k6 cloud {{script.js}}`
