# diff

> Compare files and directories.

- Compare files:

`diff {{file1}} {{file2}}`

- Compare files, ignoring white spaces:

`diff -w {{file1}} {{file2}}`

- Compare files, showing the differences side by side:

`diff -y {{file1}} {{file2}}`

- Compare files, showing the differences in unified format (as used by `git diff`):

`diff -u {{file1}} {{file2}}`

- Compare directories recursively:

`diff -r {{directory1}} {{directory2}}`

- Compare directories, only showing the names of files that differ:

`diff -rq {{directory1}} {{directory2}}`
