# astyle

> Identificatore di codice sorgente, formattatore e beautifier per i linguaggi C, C++, C# e Java.
> Quando eseguito, una copia del file originale è creata con l'estensione ".orig" aggiunta come suffisso.

- Applica lo stile di default di 4 spazi per livello di indentazione e nessun cambiamento alla formattazione:

`astyle {{file_sorgente}}`

- Applica lo stile java con parentesi graffe aperte sulla stessa riga (attached braces):

`astyle --style=java {{percorso/al/file}}`

- Applica lo stile allman per parantesi graffe su linee separate (broken braces):

`astyle --style=allman {{percorso/al/file}}`

- Applica un'indentazione personalizzata utilizzando spazi. Scegli tra 2 e 20 spazi:

`astyle --indent=spaces={{numero_spazi}} {{percorso/al/file}}`

- Applica un'indentazione personalizzata utilizzando tab. Scegli tra 2 e 20 tab:

`astyle --indent=tab={{numero_tab}} {{percorso/al/file}}`
