# Project governance

The tldr-pages project strives to have an **open**, **welcoming**,
and [**non-hierarchical**](https://en.wikipedia.org/wiki/Flat_organization)
governance structure.

To that end, this document describes the principles
that guide the self-management of the project.
By having them written down explicitly, and open to scrutiny,
the entire community can read, apply, improve and adapt them as needed,
with no central authority.

Community members are asked to abide by the following principles:

1. **All contributions are welcome**,
   [no matter how small](https://github.com/kentcdodds/all-contributors).
   The tldr-pages project is a
   [do-ocracy](https://communitywiki.org/wiki/DoOcracy),
   so don't hesitate to get involved
   — we're happy to welcome you into the community!
   Please take a look at [CONTRIBUTING.md](CONTRIBUTING.md) to get started.

2. **All interactions must be respectful and cordial**.
   Avoid making assumptions about the others' intentions,
   and make your own intentions clear.
   When in doubt, provide additional context, or ask for clarification.
   Remember, it's very hard to convey meaning on a purely written medium,
   especially between people from different cultures, technical backgrounds,
   English proficiency levels, etc.

3. **All communications are public**.
   There are no permanent private channels
   where maintainers discuss "internal" matters.
   Occasional private chat or email messages may be exchanged,
   e.g. when setting up services that require passwords,
   but otherwise all communications that impact the project
   will either happen in issue and PR discussions,
   or in the [Gitter chat room](https://gitter.im/tldr-pages/tldr)
   (which is open to all, and publicly logged).

4. **All decisions are made by community consensus**.
   This does not mean there has to be unanimity,
   nor that decisions result automatically from vote counts.
   What it means is that
   all interested members of the community are welcome to voice their thoughts,
    and incompatible positions will ideally be resolved
   with participants either agreeing with the final decision, or voluntarily
   [consenting](https://en.wikipedia.org/wiki/Sociocracy#Consent_vs._consensus)
   to accept it as "good enough for now, safe enough to try".

5. **Community roles should reflect actual activity**.
   Community roles in the tldr-project are set up
   to dynamically reflect organizational work performed by community members,
   rather than assigned as authority positions by top-down decision-making.
   The different roles that contributors can take in the community,
   and the principles that guide the transitions among them,
   are described in the [COMMUNITY-ROLES.md](COMMUNITY-ROLES.md) document.
   A [Maintainer's guide](contributing-guides/maintainers-guide.md) is also available
   to both help maintainers follow a consistent workflow,
   and to make this workflow transparent to the whole community.
