/**
 * Note for Contributors:
 * This file (en.jsx) serve as a template for other languages.
 * To make other contributors' life easier, please REMEMBER:
 *   1. to add your new string here; and
 *   2. to remove old strings that are no longer needed; and
 *   3. to sort the strings by the key.
 *   4. To rename the `en` const name and export default name to match your locale.
 * Thanks!
 */
const en = {
  "account.block": "Block @{name}",
  "account.disclaimer": "This user is from another instance. This number may be larger.",
  "account.edit_profile": "Edit profile",
  "account.follow": "Follow",
  "account.followers": "Followers",
  "account.follows": "Follows",
  "account.follows_you": "Follows you",
  "account.mention": "Mention @{name}",
  "account.mute": "Mute @{name}",
  "account.posts": "Posts",
  "account.report": "Report @{name}",
  "account.requested": "Awaiting approval",
  "account.unblock": "Unblock @{name}",
  "account.unfollow": "Unfollow",
  "account.unmute": "Unmute @{name}",
  "boost_modal.combo": "You can press {combo} to skip this next time",
  "column.blocks": "Blocked users",
  "column.community": "Local timeline",
  "column.favourites": "Favourites",
  "column.follow_requests": "Follow requests",
  "column.home": "Home",
  "column.mutes": "Muted users",
  "column.notifications": "Notifications",
  "column.public": "Federated timeline",
  "column_back_button.label": "Back",
  "column_subheading.navigation": "Navigation",
  "column_subheading.settings": "Settings",
  "compose_form.lock_disclaimer": "Your account is not {locked}. Anyone can follow you to view your follower-only posts.",
  "compose_form.lock_disclaimer.lock": "locked",
  "compose_form.placeholder": "What is on your mind?",
  "compose_form.privacy_disclaimer": "Your post will be delivered to mentioned users on {domains}. Do you trust {domainsCount, plural, one {that server} other {those servers}}? Post privacy only works on Mastodon instances. If {domains} {domainsCount, plural, one {is not a Mastodon instance} other {are not Mastodon instances}}, there will be no indication that your post is not a public post, and it may be boosted or otherwise made visible to unintended recipients.",
  "compose_form.publish": "Toot",
  "compose_form.sensitive": "Mark media as sensitive",
  "compose_form.spoiler": "Hide text behind warning",
  "compose_form.spoiler_placeholder": "Content warning",
  "confirmation_modal.cancel": "Cancel",
  "confirmations.block.confirm": "Block",
  "confirmations.block.message": "Are you sure you want to block {name}?",
  "confirmations.delete.confirm": "Delete",
  "confirmations.delete.message": "Are you sure you want to delete this status?",
  "confirmations.mute.confirm": "Mute",
  "confirmations.mute.message": "Are you sure you want to mute {name}?",
  "emoji_button.activity": "Activity",
  "emoji_button.flags": "Flags",
  "emoji_button.food": "Food & Drink",
  "emoji_button.label": "Insert emoji",
  "emoji_button.nature": "Nature",
  "emoji_button.objects": "Objects",
  "emoji_button.people": "People",
  "emoji_button.search": "Search...",
  "emoji_button.symbols": "Symbols",
  "emoji_button.travel": "Travel & Places",
  "empty_column.community": "The local timeline is empty. Write something publicly to get the ball rolling!",
  "empty_column.hashtag": "There is nothing in this hashtag yet.",
  "empty_column.home.public_timeline": "the public timeline",
  "empty_column.home": "You aren't following anyone yet. Visit {public} or use search to get started and meet other users.",
  "empty_column.notifications": "You don't have any notifications yet. Interact with others to start the conversation.",
  "empty_column.public": "There is nothing here! Write something publicly, or manually follow users from other instances to fill it up",
  "follow_request.authorize": "Authorize",
  "follow_request.reject": "Reject",
  "getting_started.apps": "Various apps are available",
  "getting_started.heading": "Getting started",
  "getting_started.open_source_notice": "Mastodon is open source software. You can contribute or report issues on GitHub at {github}. {apps}.",
  "home.column_settings.advanced": "Advanced",
  "home.column_settings.basic": "Basic",
  "home.column_settings.filter_regex": "Filter out by regular expressions",
  "home.column_settings.show_reblogs": "Show boosts",
  "home.column_settings.show_replies": "Show replies",
  "home.settings": "Column settings",
  "lightbox.close": "Close",
  "loading_indicator.label": "Loading...",
  "media_gallery.toggle_visible": "Toggle visibility",
  "missing_indicator.label": "Not found",
  "navigation_bar.blocks": "Blocked users",
  "navigation_bar.community_timeline": "Local timeline",
  "navigation_bar.edit_profile": "Edit profile",
  "navigation_bar.favourites": "Favourites",
  "navigation_bar.follow_requests": "Follow requests",
  "navigation_bar.info": "Extended information",
  "navigation_bar.logout": "Logout",
  "navigation_bar.mutes": "Muted users",
  "navigation_bar.preferences": "Preferences",
  "navigation_bar.public_timeline": "Federated timeline",
  "notification.favourite": "{name} favourited your status",
  "notification.follow": "{name} followed you",
  "notification.mention": "{name} mentioned you",
  "notification.reblog": "{name} boosted your status",
  "notifications.clear": "Clear notifications",
  "notifications.clear_confirmation": "Are you sure you want to permanently clear all your notifications?",
  "notifications.column_settings.alert": "Desktop notifications",
  "notifications.column_settings.favourite": "Favourites:",
  "notifications.column_settings.follow": "New followers:",
  "notifications.column_settings.mention": "Mentions:",
  "notifications.column_settings.reblog": "Boosts:",
  "notifications.column_settings.show": "Show in column",
  "notifications.column_settings.sound": "Play sound",
  "notifications.settings": "Column settings",
  "onboarding.done": "Done",
  "onboarding.next": "Next",
  "onboarding.page_five.public_timelines": "The local timeline shows public posts from everyone on {domain}. The federated timeline shows public posts from everyone who people on {domain} follow. These are the Public Timelines, a great way to discover new people.",
  "onboarding.page_four.home": "The home timeline shows posts from people you follow.",
  "onboarding.page_four.notifications": "The notifications column shows when someone interacts with you.",
  "onboarding.page_one.federation": "Mastodon is a network of independent servers joining up to make one larger social network. We call these servers instances.",
  "onboarding.page_one.handle": "You are on {domain}, so your full handle is {handle}",
  "onboarding.page_one.welcome": "Welcome to Mastodon!",
  "onboarding.page_six.admin": "Your instance's admin is {admin}.",
  "onboarding.page_six.almost_done": "Almost done...",
  "onboarding.page_six.appetoot": "Bon Appetoot!",
  "onboarding.page_six.apps_available": "There are {apps} available for iOS, Android and other platforms.",
  "onboarding.page_six.github": "Mastodon is free open-source software. You can report bugs, request features, or contribute to the code on {github}.",
  "onboarding.page_six.guidelines": "community guidelines",
  "onboarding.page_six.read_guidelines": "Please read {domain}'s {guidelines}!",
  "onboarding.page_six.various_app": "mobile apps",
  "onboarding.page_three.profile": "Edit your profile to change your avatar, bio, and display name. There, you will also find other preferences.",
  "onboarding.page_three.search": "Use the search bar to find people and look at hashtags, such as {illustration} and {introductions}. To look for a person who is not on this instance, use their full handle.",
  "onboarding.page_two.compose": "Write posts from the compose column. You can upload images, change privacy settings, and add content warnings with the icons below.",
  "onboarding.skip": "Skip",
  "privacy.change": "Adjust status privacy",
  "privacy.direct.long": "Post to mentioned users only",
  "privacy.direct.short": "Direct",
  "privacy.private.long": "Post to followers only",
  "privacy.private.short": "Followers-only",
  "privacy.public.long": "Post to public timelines",
  "privacy.public.short": "Public",
  "privacy.unlisted.long": "Do not post to public timelines",
  "privacy.unlisted.short": "Unlisted",
  "reply_indicator.cancel": "Cancel",
  "report.heading": "New report",
  "report.placeholder": "Additional comments",
  "report.submit": "Submit",
  "report.target": "Reporting",
  "search.placeholder": "Search",
  "search.status_by": "Status by {name}",
  "search_results.total": "{count, number} {count, plural, one {result} other {results}}",
  "status.cannot_reblog": "This post cannot be boosted",
  "status.delete": "Delete",
  "status.favourite": "Favourite",
  "status.load_more": "Load more",
  "status.media_hidden": "Media hidden",
  "status.mention": "Mention @{name}",
  "status.open": "Expand this status",
  "status.reblog": "Boost",
  "status.reblogged_by": "{name} boosted",
  "status.reply": "Reply",
  "status.replyAll": "Reply to thread",
  "status.report": "Report @{name}",
  "status.sensitive_toggle": "Click to view",
  "status.sensitive_warning": "Sensitive content",
  "status.show_less": "Show less",
  "status.show_more": "Show more",
  "tabs_bar.compose": "Compose",
  "tabs_bar.federated_timeline": "Federated",
  "tabs_bar.home": "Home",
  "tabs_bar.local_timeline": "Local",
  "tabs_bar.notifications": "Notifications",
  "upload_area.title": "Drag & drop to upload",
  "upload_button.label": "Add media",
  "upload_form.undo": "Undo",
  "upload_progress.label": "Uploading...",
  "video_player.expand": "Expand video",
  "video_player.toggle_sound": "Toggle sound",
  "video_player.toggle_visible": "Toggle visibility",
  "video_player.video_error": "Video could not be played",
};

export default en;
