import zh from 'react-intl/locale-data/zh';

const localeData = zh.reduce(function (acc, localeData) {
  if (localeData.locale === "zh-Hans-CN") {
    // rename the locale "zh-Hans-CN" as "zh-CN"
    // (match the code usually used in Accepted-Language header)
    acc.push(Object.assign({},
      localeData,
      {
        "locale": "zh-CN",
        "parentLocale": "zh-Hans-CN",
      }
    ));
  }
  return acc;
}, []);

export { localeData as localeData };

const zh_cn = {
  "account.block": "屏蔽 @{name}",
  "account.disclaimer": "由于这个账户处于另一个服务站，实际数字会比这个更多。",
  "account.edit_profile": "修改个人资料",
  "account.follow": "关注",
  "account.followers": "关注者",
  "account.follows_you": "关注你",
  "account.follows": "正关注",
  "account.mention": "提及 @{name}",
  "account.mute": "将 @{name} 静音",
  "account.posts": "嘟文",
  "account.report": "举报 @{name}",
  "account.requested": "等候审批",
  "account.unblock": "解除对 @{name} 的屏蔽",
  "account.unfollow": "取消关注",
  "account.unmute": "取消 @{name} 的静音",
  "boost_modal.combo": "如你想在下次路过时显示，请按{combo}，",
  "column_back_button.label": "返回",
  "column.blocks": "屏蔽用户",
  "column.community": "本站时间轴",
  // intentional departure from existing "推文" translation for posts:
  // "推文" refers to "推特", the official translation for Twitter.
  // Currently using a semi-phonetic translation "嘟", which refers
  // to train horn sounds, for "toot".
  "column.favourites": "赞过的嘟文",
  "column.follow_requests": "关注请求",
  "column.home": "主页",
  "column.notifications": "通知",
  "column.public": "跨站公共时间轴",
  "compose_form.placeholder": "在想啥？",
  "compose_form.privacy_disclaimer": "你的私人嘟文，将被发送至你所提及的 {domains} 用户。你是否信任 {domainsCount, plural, one {这个网站} other {这些网站}}？请留意，嘟文隐私设置只适用于各 Mastodon 服务站，如果 {domains} {domainsCount, plural, one {不是 Mastodon 服务站} other {之中有些不是 Mastodon 服务站}}，对方将无法收到这篇嘟文的隐私设置，然后可能被转嘟给不能预知的用户阅读。",
  "compose_form.private": "标示为“只有关注你的人能看”",
  // Going "toot-toot!" here below.
  "compose_form.publish": "嘟嘟！",
  "compose_form.sensitive": "将媒体文件标示为“敏感内容”",
  "compose_form.spoiler_placeholder": "敏感内容",
  "compose_form.spoiler": "将部份文本藏于警告消息之后",
  "compose_form.unlisted": "请勿在公共时间轴显示",
  "emoji_button.label": "加入表情符号",
  "empty_column.community": "本站时间轴暂时未有内容，快贴文来抢头香啊！",
  "empty_column.hashtag": "这个标签暂时未有内容。",
  "empty_column.home": "你还没有关注任何用户。快看看{public}，向其他用户搭讪吧。",
  "empty_column.home.public_timeline": "公共时间轴",
  "empty_column.home": "你还没有关注任何用户。快看看{public}，向其他用户搭讪吧。",
  "empty_column.notifications": "你没有任何通知纪录，快向其他用户搭讪吧。",
  "empty_column.public": "跨站公共时间轴暂时没有内容！快写一些公共的嘟文，或者关注另一些服务站的用户吧！你和本站、友站的交流，将决定这里出现的内容。",
  "follow_request.authorize": "批准",
  "follow_request.reject": "拒绝",
  "getting_started.about_addressing": "只要你知道一位用户的用户名称和域名，你可以用“@用户名称@域名”的格式在搜索栏寻找该用户。",
  "getting_started.about_shortcuts": "只要该用户是在你现在的服务站开立，你就可以直接输入用户名搜索。在嘟文中提及别的用户也是如此。",
  "getting_started.apps": "手机或桌面应用程序",
  "getting_started.heading": "开始使用",
  "getting_started.open_source_notice": "Mastodon 是一个开放源码的软件。你可以在官方 GitHub ({github}) 贡献或者回报问题。你亦可通过{apps}阅读 Mastodon 上的消息。",
  "home.column_settings.advanced": "高端",
  "home.column_settings.basic": "基本",
  "home.column_settings.filter_regex": "使用正则表达式 (regex) 过滤",
  "home.column_settings.show_reblogs": "显示被转的嘟文",
  "home.column_settings.show_replies": "显示回应嘟文",
  "home.settings": "字段设置",
  "lightbox.close": "关闭",
  "loading_indicator.label": "加载中...",
  "media_gallery.toggle_visible": "打开或关上",
  "missing_indicator.label": "找不到内容",
  "navigation_bar.blocks": "被屏蔽的用户",
  "navigation_bar.community_timeline": "本站时间轴",
  "navigation_bar.edit_profile": "修改个人资料",
  "navigation_bar.favourites": "赞的内容",
  "navigation_bar.follow_requests": "关注请求",
  "navigation_bar.info": "关于本服务站",
  "navigation_bar.logout": "注销",
  // intentional departure from https://github.com/tootsuite/mastodon/blob/f864fee1/config/locales/zh-CN.yml#L126:
  // clashes for settings/preferences
  "navigation_bar.preferences": "首选项",
  "navigation_bar.public_timeline": "跨站公共时间轴",
  "notification.favourite": "{name} 赞你的嘟文",
  "notification.follow": "{name} 开始关注你",
  "notification.mention": "{name} 提及你",
  "notification.reblog": "{name} 转嘟你的嘟文",
  "notifications.clear_confirmation": "你确定要清空通知纪录吗？",
  "notifications.clear": "清空通知纪录",
  "notifications.column_settings.alert": "显示桌面通知",
  "notifications.column_settings.favourite": "赞你的嘟文：",
  "notifications.column_settings.follow": "关注你：",
  "notifications.column_settings.mention": "提及你：",
  "notifications.column_settings.reblog": "转你的嘟文：",
  "notifications.column_settings.show": "在通知栏显示",
  "notifications.column_settings.sound": "播放音效",
  "notifications.settings": "字段设置",
  "privacy.change": "调整隐私设置",
  "privacy.direct.long": "只有提及的用户能看到",
  "privacy.direct.short": "私人消息",
  "privacy.private.long": "只有关注你用户能看到",
  "privacy.private.short": "关注者",
  "privacy.public.long": "在公共时间轴显示",
  "privacy.public.short": "公共",
  "privacy.unlisted.long": "公开，但不在公共时间轴显示",
  "privacy.unlisted.short": "公开",
  "reply_indicator.cancel": "取消",
  "report.heading": "举报",
  "report.placeholder": "额外消息",
  "report.submit": "提交",
  "report.target": "Reporting",
  "search_results.total": "{count, number} 项结果",
  "search.account": "用户",
  "search.hashtag": "标签",
  "search.placeholder": "搜索",
  "search.status_by": "按{name}搜索嘟文",
  "status.delete": "删除",
  "status.favourite": "赞",
  "status.load_more": "加载更多",
  "status.media_hidden": "隐藏媒体内容",
  "status.mention": "提及 @{name}",
  "status.open": "展开嘟文",
  "status.reblog": "转嘟",
  "status.reblogged_by": "{name} 转嘟",
  "status.reply": "回应",
  "status.report": "举报 @{name}",
  "status.sensitive_toggle": "点击显示",
  "status.sensitive_warning": "敏感内容",
  "status.show_less": "减少显示",
  "status.show_more": "显示更多",
  "tabs_bar.compose": "撰写",
  "tabs_bar.federated_timeline": "跨站",
  "tabs_bar.home": "主页",
  "tabs_bar.local_timeline": "本站",
  "tabs_bar.mentions": "提及",
  "tabs_bar.notifications": "通知",
  "tabs_bar.public": "跨站公共时间轴",
  "upload_area.title": "将文件拖放至此上传",
  "upload_button.label": "上传媒体文件",
  "upload_form.undo": "还原",
  "upload_progress.label": "上传中……",
  "video_player.expand": "展开影片",
  "video_player.toggle_sound": "开关音效",
  "video_player.toggle_visible": "打开或关上",
};

export default zh_cn;
