/**
 * Note for Contributors:
 * This file (en.jsx) serve as a template for other languages.
 * To make other contributors' life easier, please REMEMBER:
 *   1. to add your new string here; and
 *   2. to remove old strings that are no longer needed; and
 *   3. to sort the strings by the key.
 *   4. To rename the `en` const name and export default name to match your locale.
 * Thanks!
 */
const en = {
  "account.block": "Block @{name}",
  "account.disclaimer": "This user is from another instance. This number may be larger.",
  "account.edit_profile": "Edit profile",
  "account.follow": "Follow",
  "account.followers": "Followers",
  "account.follows_you": "Follows you",
  "account.follows": "Follows",
  "account.mention": "Mention @{name}",
  "account.mute": "Mute @{name}",
  "account.posts": "Posts",
  "account.report": "Report @{name}",
  "account.requested": "Awaiting approval",
  "account.unblock": "Unblock @{name}",
  "account.unfollow": "Unfollow",
  "account.unmute": "Unmute @{name}",
  "boost_modal.combo": "You can press {combo} to skip this next time",
  "column_back_button.label": "Back",
  "column.blocks": "Blocked users",
  "column.community": "Local timeline",
  "column.favourites": "Favourites",
  "column.follow_requests": "Follow requests",
  "column.home": "Home",
  "column.mutes": "Muted users",
  "column.notifications": "Notifications",
  "column.public": "Federated timeline",
  "compose_form.placeholder": "What is on your mind?",
  "compose_form.privacy_disclaimer": "Your private status will be delivered to mentioned users on {domains}. Do you trust {domainsCount, plural, one {that server} other {those servers}}? Post privacy only works on Mastodon instances. If {domains} {domainsCount, plural, one {is not a Mastodon instance} other {are not Mastodon instances}}, there will be no indication that your post is private, and it may be boosted or otherwise made visible to unintended recipients.",
  "compose_form.publish": "Toot",
  "compose_form.sensitive": "Mark media as sensitive",
  "compose_form.spoiler_placeholder": "Content warning",
  "compose_form.spoiler": "Hide text behind warning",
  "emoji_button.label": "Insert emoji",
  "empty_column.community": "The local timeline is empty. Write something publicly to get the ball rolling!",
  "empty_column.hashtag": "There is nothing in this hashtag yet.",
  "empty_column.home.public_timeline": "the public timeline",
  "empty_column.home": "You aren't following anyone yet. Visit {public} or use search to get started and meet other users.",
  "empty_column.notifications": "You don't have any notifications yet. Interact with others to start the conversation.",
  "empty_column.public": "There is nothing here! Write something publicly, or manually follow users from other instances to fill it up",
  "follow_request.authorize": "Authorize",
  "follow_request.reject": "Reject",
  "getting_started.apps": "Various apps are available",
  "getting_started.heading": "Getting started",
  "getting_started.open_source_notice": "Mastodon is open source software. You can contribute or report issues on GitHub at {github}. {apps}.",
  "home.column_settings.advanced": "Advanced",
  "home.column_settings.basic": "Basic",
  "home.column_settings.filter_regex": "Filter out by regular expressions",
  "home.column_settings.show_reblogs": "Show boosts",
  "home.column_settings.show_replies": "Show replies",
  "home.settings": "Column settings",
  "lightbox.close": "Close",
  "loading_indicator.label": "Loading...",
  "media_gallery.toggle_visible": "Toggle visibility",
  "missing_indicator.label": "Not found",
  "navigation_bar.blocks": "Blocked users",
  "navigation_bar.community_timeline": "Local timeline",
  "navigation_bar.edit_profile": "Edit profile",
  "navigation_bar.favourites": "Favourites",
  "navigation_bar.follow_requests": "Follow requests",
  "navigation_bar.info": "Extended information",
  "navigation_bar.logout": "Logout",
  "navigation_bar.mutes": "Muted users",
  "navigation_bar.preferences": "Preferences",
  "navigation_bar.public_timeline": "Federated timeline",
  "notification.favourite": "{name} favourited your status",
  "notification.follow": "{name} followed you",
  "notification.mention": "{name} mentioned you",
  "notification.reblog": "{name} boosted your status",
  "notifications.clear_confirmation": "Are you sure you want to clear all your notifications?",
  "notifications.clear": "Clear notifications",
  "notifications.column_settings.alert": "Desktop notifications",
  "notifications.column_settings.favourite": "Favourites:",
  "notifications.column_settings.follow": "New followers:",
  "notifications.column_settings.mention": "Mentions:",
  "notifications.column_settings.reblog": "Boosts:",
  "notifications.column_settings.show": "Show in column",
  "notifications.column_settings.sound": "Play sound",
  "notifications.settings": "Column settings",
  "privacy.change": "Adjust status privacy",
  "privacy.direct.long": "Post to mentioned users only",
  "privacy.direct.short": "Direct",
  "privacy.private.long": "Post to followers only",
  "privacy.private.short": "Private",
  "privacy.public.long": "Post to public timelines",
  "privacy.public.short": "Public",
  "privacy.unlisted.long": "Do not show in public timelines",
  "privacy.unlisted.short": "Unlisted",
  "reply_indicator.cancel": "Cancel",
  "report.heading": "New report",
  "report.placeholder": "Additional comments",
  "report.submit": "Submit",
  "report.target": "Reporting",
  "search_results.total": "{count, number} {count, plural, one {result} other {results}}",
  "search.placeholder": "Search",
  "search.status_by": "Status by {name}",
  "status.delete": "Delete",
  "status.favourite": "Favourite",
  "status.load_more": "Load more",
  "status.media_hidden": "Media hidden",
  "status.mention": "Mention @{name}",
  "status.open": "Expand this status",
  "status.reblog": "Boost",
  "status.reblogged_by": "{name} boosted",
  "status.reply": "Reply",
  "status.replyAll": "Reply to thread",
  "status.report": "Report @{name}",
  "status.sensitive_toggle": "Click to view",
  "status.sensitive_warning": "Sensitive content",
  "status.show_less": "Show less",
  "status.show_more": "Show more",
  "tabs_bar.compose": "Compose",
  "tabs_bar.federated_timeline": "Federated",
  "tabs_bar.home": "Home",
  "tabs_bar.local_timeline": "Local",
  "tabs_bar.notifications": "Notifications",
  "upload_area.title": "Drag & drop to upload",
  "upload_button.label": "Add media",
  "upload_form.undo": "Undo",
  "upload_progress.label": "Uploading...",
  "video_player.toggle_sound": "Toggle sound",
  "video_player.toggle_visible": "Toggle visibility",
  "video_player.expand": "Expand video",
  "video_player.video_error": "Video could not be played",
};

export default en;
