(require :unittest "lib/llib/unittest.l")

(init-unit-test)

(deftest test-queue ;; fifo queue
  (let (q e)
    (setq q (instance queue :init))
    ;; enqueue
    (dotimes (i 5) (send q :enqueue i))
    (format t "queue ~A, length ~A~%" (car q) (send q :length))
    (assert (= (send q :length) 5) "length of ~A is 5" (car q))
    (assert (equal (car q) '(0 1 2 3 4)) "entity of queue ~A" (car q))
    ;; search
    (setq e (send q :search 3))
    (format t "queue ~A, searched item ~A~%" (car q) e)
    (assert (= e 3) "searched item is ~A" e)
    (setq e (send q :search 15))
    (format t "queue ~A, searched item ~A~%" (car q) e)
    (assert (null e) "searched item is ~A" e)
    ;; delete
    (setq e (send q :delete 3))
    (format t "queue ~A, deleteed item ~A~%" (car q) e)
    (assert (equal (car q) '(0 1 2 4))"deleteed item is ~A" e)
    (setq e (send q :delete 15))
    (format t "queue ~A, deleteed item ~A~%" (car q) e)
    (assert (equal (car q) '(0 1 2 4))"deleteed item is ~A" e)
    ;; trim
    (send q :trim 3)
    (format t "queue ~A, length ~A~%" (car q) (send q :length))
    (assert (equal (car q) '(1 2 4)) "entity of queue ~A" (car q))
    (assert (= (send q :length) 3) "length of ~A is 3" (car q))
    (send q :trim 15)
    (format t "queue ~A, length ~A~%" (car q) (send q :length))
    (assert (equal (car q) '(1 2 4)) "entity of queue ~A" (car q))
    (assert (= (send q :length) 3) "length of ~A is 3" (car q))
    ;; dequeue
    (setq e (send q :dequeue))
    (format t "queue ~A, dequeued item ~A~%" (car q) e)
    (assert (= e 1) "dequeued item is ~A" e)
    (setq e (send q :dequeue))
    (format t "queue ~A, dequeued item ~A, empty? ~A~%" (car q) e (send q :empty?))
    (assert (= e 2) "dequeued item is ~A" e)
    (assert (null (send q :empty?)) "queue is empty" (car q))
    (setq e (send q :dequeue))
    (format t "queue ~A, dequeued item ~A~%" (car q) e)
    (assert (= e 4) "dequeued item is ~A" e)
    (format t "queue ~A, length ~A, empty? ~A~%" (car q) (send q :length) (send q :empty?))
    (assert (= (send q :length) 0) "length of ~A must be 5" (car q))
    (assert (send q :empty?) "queue is empty" (car q))
    ))

(run-all-tests)
(exit)
