;; number.l
;; Author: Yuki Furuta <furushchev@jsk.imi.i.u-tokyo.ac.jp>

(require :unittest "lib/llib/unittest.l")

(init-unit-test)

(deftest test-compare-number
  (format *error-output* " compare-number test ~%")
  (assert (eq (= 3 3) t)               "(= 3 3) is true.")
  (assert (eq (= 3 5) nil)              "(= 3 5) is false.")
  (assert (eq (= 3 3 3 3) t)           "(= 3 3 3 3) is true.")
  (assert (eq (= 3 3 5 3) nil)          "(= 3 3 5 3) is false.")
  (assert (eq (= 3 6 5 2) nil)          "(= 3 6 5 2) is false.")
  (assert (eq (= 3 2 3) nil)            "(= 3 2 3) is false.")
  (assert (eq (/= 3 3) nil)             "(/= 3 3) is false.")
  (assert (eq (/= 3 5) t)              "(/= 3 5) is true.")
  (assert (eq (/= 3 3 3 3) nil)         "(/= 3 3 3 3) is false.")
  (assert (eq (/= 3 3 5 3) nil)         "(/= 3 3 5 3) is false.")
  (assert (eq (/= 1 2 3 2) nil)         "(/= 1 2 3 2) is false.")
  (assert (eq (/= 3 6 5 2) t)          "(/= 3 6 5 2) is true.")
  (assert (eq (/= 3 2 3) nil)           "(/= 3 2 3) is false.")
  (assert (eq (< 3 5) t)               "(< 3 5) is true.")
  (assert (eq (< 3 -5) nil)             "(< 3 -5) is false.")
  (assert (eq (< 3 3) nil)              "(< 3 3) is false.")
  (assert (eq (< 0 3 4 6 7) t)         "(< 0 3 4 6 7) is true.")
  (assert (eq (< 0 3 4 4 6) nil)        "(< 0 3 4 4 6) is false.")
  (assert (eq (<= 3 5) t)              "(<= 3 5) is true.")
  (assert (eq (<= 3 -5) nil)            "(<= 3 -5) is false.")
  (assert (eq (<= 3 3) t)              "(<= 3 3) is true.")
  (assert (eq (<= 0 3 4 6 7) t)        "(<= 0 3 4 6 7) is true.")
  (assert (eq (<= 0 3 4 4 6) t)        "(<= 0 3 4 4 6) is true.")
  (assert (eq (>= 4 3) t)              "(>= 4 3) is true.")
  (assert (eq (>= 4 3 2 1 0) t)        "(>= 4 3 2 1 0) is true.")
  (assert (eq (>= 4 3 3 2 0) t)        "(>= 4 3 3 2 0) is true.")
  (assert (eq (>= 4 3 1 2 0) nil)       "(>= 4 3 1 2 0) is false.")
  (assert (eq (> 4 3) t)               "(> 4 3) is true.")
  (assert (eq (> 4 3 2 1 0) t)         "(> 4 3 2 1 0) is true.")
  (assert (eq (> 4 3 3 2 0) nil)        "(> 4 3 3 2 0) is false.")
  (assert (eq (> 4 3 1 2 0) nil)        "(> 4 3 1 2 0) is false.")
  (assert (eq (= 3 3.0) t)             "(= 3 3.0) is true.")
  (assert (eq (= 0.0 -0.0) t)          "(= 0.0 -0.0) is true.")
  (assert (eq (= 5/2 2.5) t)           "(= 5/2 2.5) is true.")
  (assert (eq (> 0.0 -0.0) nil)         "(> 0.0 -0.0) is false.")
  (assert (eq (= 0 -0.0) t)            "(= 0 -0.0) is true.")
  )

(run-all-tests)
(exit) ;; end of number.l
