---
title: "Available Plugins"
weight: 1
---

# Available Plugins

## Core Plugins

The Vendure monorepo contains a number of "core" plugins - that is, commonly-used plugins which are developed and versioned alongside the server core itself.

* **[AdminUiPlugin]({{< relref "/docs/typescript-api/admin-ui-plugin" >}})**: This plugin bundles a default build of the Vendure Admin UI and serves it when the server is started.
* **[AssetServerPlugin]({{< relref "/docs/typescript-api/asset-server-plugin" >}})**: This plugin stores and serves assets from the local file system, and can perform on-the-fly image transformations.
* **[ElasticsearchPlugin]({{< relref "/docs/typescript-api/elasticsearch-plugin" >}})**: This plugin allows your product search to be powered by Elasticsearch - a powerful Open Source search engine.
* **[EmailPlugin]({{< relref "/docs/typescript-api/email-plugin" >}})**: The EmailPlugin creates and sends transactional emails based on Vendure events.

## Third-party plugins

Have you created a Vendure plugin that you'd like to share? Contact us and we can list it here! 

For now, you'll find some community plugins in [these GitHub search results](https://github.com/search?q=vendure+plugin+-user%3Avendure-ecommerce&type=Repositories).
 
