import path from 'path';
import webpack from 'webpack';

// tslint:disable-next-line:no-var-requires
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

const config: webpack.Configuration = {
    mode: 'production',
    entry: {
        main: './assets/scripts/main.ts',
        intro: './assets/scripts/intro/intro.ts',
    },
    output: {
        path: path.resolve(__dirname, 'static'),
        filename: '[name].js',
    },
    resolve: {
        extensions: ['.ts', '.js'],
    },
    module: {
        rules: [
            { test: /\.tsx?$/, loader: 'ts-loader' },
            {
                test: /\.scss$/,
                use: [
                    {
                        loader: MiniCssExtractPlugin.loader,
                    },
                    'css-loader',
                    'sass-loader',
                ],
            },
        ],
    },
    plugins: [
        new MiniCssExtractPlugin({
            // Options similar to the same options in webpackOptions.output
            // both options are optional
            filename: '[name].css',
            chunkFilename: '[id].css',
        }),
    ],
    devtool: 'source-map',
};

export default config;
