/*
 * MIT License
 *
 * Copyright (c) 2022-2025  Arsene Tochemey Gandote
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package log

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestLevelString(t *testing.T) {
	testCases := []struct {
		name     string
		level    Level
		expected string
	}{
		{
			name:     "debug",
			level:    DebugLevel,
			expected: "debug",
		},
		{
			name:     "info",
			level:    InfoLevel,
			expected: "info",
		},
		{
			name:     "warn",
			level:    WarningLevel,
			expected: "warn",
		},
		{
			name:     "error",
			level:    ErrorLevel,
			expected: "error",
		},
		{
			name:     "fatal",
			level:    FatalLevel,
			expected: "fatal",
		},
		{
			name:     "panic",
			level:    PanicLevel,
			expected: "panic",
		},
		{
			name:     "none",
			level:    InvalidLevel,
			expected: "",
		},
	}

	for _, tc := range testCases {
		t.Run(tc.name, func(t *testing.T) {
			actual := tc.level.String()
			assert.Equal(t, tc.expected, actual)
		})
	}
}
