# Tumult Core

Tumult Core is a programming framework for implementing [differentially private](https://en.wikipedia.org/wiki/Differential_privacy) algorithms.

The design of Tumult Core is based on the design proposed in the [OpenDP White Paper](https://projects.iq.harvard.edu/files/opendifferentialprivacy/files/opendp_white_paper_11may2020.pdf), and can automatically verify the privacy properties of algorithms constructed from Tumult Core components. Tumult Core is scalable, includes a wide variety of components, and supports multiple privacy definitions.


## 🚨 Important Update: the Tumult Labs Team is Joining LinkedIn 🚨
The [Tumult Labs team has joined LinkedIn](https://www.linkedin.com/pulse/whats-next-us-tumult-labs-gerome-miklau-zmpye)! 🎉 As part of this transition, we are exploring options for the future of Tumult Core, including finding a new home for the project. 🏡
We greatly appreciate the community’s support and contributions. If your organization is interested in maintaining or adopting Tumult Core, please reach out! 📩
For now, the repository remains available, and we encourage users to continue engaging with the project. We’ll provide updates as soon as we have more to share.
— The Tumult Labs Team 💙

## Installation

See the [installation instructions in the documentation](https://docs.tmlt.dev/core/latest/installation.html#installation-instructions) for information about setting up prerequisites such as Spark and Java.

Once the prerequisites are installed, you can install Tumult Core using [pip](https://pypi.org/project/pip/).

```bash
pip install tmlt.core
```

## Documentation

The full documentation is located at https://docs.tmlt.dev/core/latest.

## Support

If you have any questions/concerns, please [create an issue](https://gitlab.com/tumult-labs/core/-/issues) or reach out to us on [Slack](https://tmltdev.slack.com/join/shared_invite/zt-1bky0mh9v-vOB8azKAVoxmzJDUdWd5Wg#).

## Contributing

We welcome external volunteers! If you are interested in contributing, please
let us know on [Slack][slack]. See [CONTRIBUTING.md](https://github.com/opendp/tumult-core/blob/main/CONTRIBUTING.md) for information. 

## License

Tumult Core's source code is licensed under the Apache License, version 2.0
(Apache-2.0). Tumult Core's documentation is licensed under Creative Commons
Attribution-ShareAlike 4.0 International (CC-BY-SA-4.0).
