# Tumult Core

Tumult Core is a programming framework for implementing [differentially private](https://en.wikipedia.org/wiki/Differential_privacy) algorithms.

The design of Tumult Core is based on the design proposed in the [OpenDP White Paper](https://projects.iq.harvard.edu/files/opendifferentialprivacy/files/opendp_white_paper_11may2020.pdf), and can automatically verify the privacy properties of algorithms constructed from Tumult Core components. Tumult Core is scalable, includes a wide variety of components, and supports multiple privacy definitions.

## Installation

See the [installation instructions in the documentation](https://docs.tmlt.dev/core/latest/installation.html#installation-instructions) for information about setting up prerequisites such as Spark and Java.

Once the prerequisites are installed, you can install Tumult Core using [pip](https://pypi.org/project/pip/).

```bash
pip install tmlt.core
```

## Documentation

The full documentation is located at https://docs.tmlt.dev/core/latest.

## Support

If you have any questions/concerns, please [create an issue](https://gitlab.com/tumult-labs/core/-/issues) or reach out to us on [Slack](https://tmltdev.slack.com/join/shared_invite/zt-1bky0mh9v-vOB8azKAVoxmzJDUdWd5Wg#).

## Contributing

We are not yet accepting external contributions, but please let us know if you are interested in contributing via [Slack](https://tmltdev.slack.com/join/shared_invite/zt-1bky0mh9v-vOB8azKAVoxmzJDUdWd5Wg#).

See [CONTRIBUTING.md](CONTRIBUTING.md) for information about installing our development dependencies and running tests.

## License

Copyright Tumult Labs 2023

The Tumult Platform source code is licensed under the Apache License, version 2.0 (Apache-2.0).
The Tumult Platform documentation is licensed under
Creative Commons Attribution-ShareAlike 4.0 International (CC-BY-SA-4.0).
