// ThreeWebGL.js r44 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(b){b!==void 0&&this.setHex(b);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(b){this.r=b.r;this.g=b.g;this.b=b.b;return this},setRGB:function(b,c,d){this.r=b;this.g=c;this.b=d;return this},setHSV:function(b,c,d){var e,j,h;if(d==0)this.r=this.g=this.b=0;else switch(e=Math.floor(b*6),j=b*6-e,b=d*(1-c),h=d*(1-c*j),c=d*(1-c*(1-j)),e){case 1:this.r=h;this.g=d;this.b=b;break;case 2:this.r=b;this.g=d;this.b=c;break;case 3:this.r=b;this.g=h;this.b=d;break;case 4:this.r=c;this.g=b;this.b=d;break;case 5:this.r=
d;this.g=b;this.b=h;break;case 6:case 0:this.r=d,this.g=c,this.b=b}return this},setHex:function(b){b=Math.floor(b);this.r=(b>>16&255)/255;this.g=(b>>8&255)/255;this.b=(b&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(b,c){this.x=b||0;this.y=c||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(b,c){this.x=b;this.y=c;return this},copy:function(b){this.x=b.x;this.y=b.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;return this},
divideScalar:function(b){b?(this.x/=b,this.y/=b):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){var c=this.x-b.x,b=this.y-b.y;return c*c+b*b},setLength:function(b){return this.normalize().multiplyScalar(b)},
equals:function(b){return b.x==this.x&&b.y==this.y}};THREE.Vector3=function(b,c,d){this.x=b||0;this.y=c||0;this.z=d||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(b,c,d){this.x=b;this.y=c;this.z=d;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;return this},addScalar:function(b){this.x+=b;this.y+=b;this.z+=b;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=
b.z-c.z;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;return this},multiply:function(b,c){this.x=b.x*c.x;this.y=b.y*c.y;this.z=b.z*c.z;return this},multiplySelf:function(b){this.x*=b.x;this.y*=b.y;this.z*=b.z;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;return this},divideSelf:function(b){this.x/=b.x;this.y/=b.y;this.z/=b.z;return this},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},
dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},cross:function(b,c){this.x=b.y*c.z-b.z*c.y;this.y=b.z*c.x-b.x*c.z;this.z=b.x*c.y-b.y*c.x;return this},crossSelf:function(b){return this.set(this.y*
b.z-this.z*b.y,this.z*b.x-this.x*b.z,this.x*b.y-this.y*b.x)},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){return(new THREE.Vector3).sub(this,b).lengthSq()},setPositionFromMatrix:function(b){this.x=b.n14;this.y=b.n24;this.z=b.n34},setRotationFromMatrix:function(b){var c=Math.cos(this.y);this.y=Math.asin(b.n13);Math.abs(c)>1.0E-5?(this.x=Math.atan2(-b.n23/c,b.n33/c),this.z=Math.atan2(-b.n12/c,b.n11/c)):(this.x=0,this.z=Math.atan2(b.n21,b.n22))},isZero:function(){return this.lengthSq()<
1.0E-4}};THREE.Vector4=function(b,c,d,e){this.x=b||0;this.y=c||0;this.z=d||0;this.w=e||1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(b,c,d,e){this.x=b;this.y=c;this.z=d;this.w=e;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w||1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;this.w=b.w+c.w;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;this.w+=b.w;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=b.z-c.z;this.w=
b.w-c.w;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;this.w-=b.w;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;this.w*=b;return this},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b,this.w/=b):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z+this.w*b.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},lerpSelf:function(b,c){this.x+=(b.x-this.x)*c;this.y+=(b.y-this.y)*c;this.z+=(b.z-this.z)*c;this.w+=(b.w-this.w)*c;return this}};THREE.Ray=function(b,c){this.origin=b||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(b){return this.intersectObjects(b.objects)},intersectObjects:function(b){var c,d,e=[];c=0;for(d=b.length;c<d;c++)e=e.concat(this.intersectObject(b[c]));e.sort(function(b,c){return b.distance-c.distance});return e},intersectObject:function(b){function c(b,c,d){var e;e=d.clone().subSelf(b).dot(c);if(e<=0)return null;b=b.clone().addSelf(c.clone().multiplyScalar(e));return d.distanceTo(b)}function d(b,c,d,e){var e=e.clone().subSelf(c),
d=d.clone().subSelf(c),j=b.clone().subSelf(c),b=e.dot(e),c=e.dot(d),e=e.dot(j),h=d.dot(d),d=d.dot(j),j=1/(b*h-c*c),h=(h*e-c*d)*j,b=(b*d-c*e)*j;return h>0&&b>0&&h+b<1}if(b instanceof THREE.Particle){var e=c(this.origin,this.direction,b.matrixWorld.getPosition());if(e==null||e>b.scale.x)return[];return[{distance:e,point:b.position,face:null,object:b}]}else if(b instanceof THREE.Mesh){e=c(this.origin,this.direction,b.matrixWorld.getPosition());if(e==null||e>b.geometry.boundingSphere.radius*Math.max(b.scale.x,
Math.max(b.scale.y,b.scale.z)))return[];var j,h,k,m,q,p,n,s,r,v,B=b.geometry,y=B.vertices,E=[],e=0;for(j=B.faces.length;e<j;e++)if(h=B.faces[e],r=this.origin.clone(),v=this.direction.clone(),p=b.matrixWorld,k=p.multiplyVector3(h.centroid.clone()).subSelf(r),s=k.dot(v),!(s<=0)&&(k=p.multiplyVector3(y[h.a].position.clone()),m=p.multiplyVector3(y[h.b].position.clone()),q=p.multiplyVector3(y[h.c].position.clone()),p=h instanceof THREE.Face4?p.multiplyVector3(y[h.d].position.clone()):null,n=b.matrixRotationWorld.multiplyVector3(h.normal.clone()),
s=v.dot(n),b.doubleSided||(b.flipSided?s>0:s<0)))if(s=n.dot((new THREE.Vector3).sub(k,r))/s,r=r.addSelf(v.multiplyScalar(s)),h instanceof THREE.Face3)d(r,k,m,q)&&(h={distance:this.origin.distanceTo(r),point:r,face:h,object:b},E.push(h));else if(h instanceof THREE.Face4&&(d(r,k,m,p)||d(r,m,q,p)))h={distance:this.origin.distanceTo(r),point:r,face:h,object:b},E.push(h);E.sort(function(b,c){return b.distance-c.distance});return E}else return[]}};
THREE.Rectangle=function(){function b(){h=e-c;k=j-d}var c,d,e,j,h,k,m=!0;this.getX=function(){return c};this.getY=function(){return d};this.getWidth=function(){return h};this.getHeight=function(){return k};this.getLeft=function(){return c};this.getTop=function(){return d};this.getRight=function(){return e};this.getBottom=function(){return j};this.set=function(h,k,n,s){m=!1;c=h;d=k;e=n;j=s;b()};this.addPoint=function(h,k){m?(m=!1,c=h,d=k,e=h,j=k):(c=c<h?c:h,d=d<k?d:k,e=e>h?e:h,j=j>k?j:k);b()};this.add3Points=
function(h,k,n,s,r,v){m?(m=!1,c=h<n?h<r?h:r:n<r?n:r,d=k<s?k<v?k:v:s<v?s:v,e=h>n?h>r?h:r:n>r?n:r,j=k>s?k>v?k:v:s>v?s:v):(c=h<n?h<r?h<c?h:c:r<c?r:c:n<r?n<c?n:c:r<c?r:c,d=k<s?k<v?k<d?k:d:v<d?v:d:s<v?s<d?s:d:v<d?v:d,e=h>n?h>r?h>e?h:e:r>e?r:e:n>r?n>e?n:e:r>e?r:e,j=k>s?k>v?k>j?k:j:v>j?v:j:s>v?s>j?s:j:v>j?v:j);b()};this.addRectangle=function(h){m?(m=!1,c=h.getLeft(),d=h.getTop(),e=h.getRight(),j=h.getBottom()):(c=c<h.getLeft()?c:h.getLeft(),d=d<h.getTop()?d:h.getTop(),e=e>h.getRight()?e:h.getRight(),j=j>
h.getBottom()?j:h.getBottom());b()};this.inflate=function(h){c-=h;d-=h;e+=h;j+=h;b()};this.minSelf=function(h){c=c>h.getLeft()?c:h.getLeft();d=d>h.getTop()?d:h.getTop();e=e<h.getRight()?e:h.getRight();j=j<h.getBottom()?j:h.getBottom();b()};this.instersects=function(b){return Math.min(e,b.getRight())-Math.max(c,b.getLeft())>=0&&Math.min(j,b.getBottom())-Math.max(d,b.getTop())>=0};this.empty=function(){m=!0;j=e=d=c=0;b()};this.isEmpty=function(){return m}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var b,c=this.m;b=c[1];c[1]=c[3];c[3]=b;b=c[2];c[2]=c[6];c[6]=b;b=c[5];c[5]=c[7];c[7]=b;return this},transposeIntoArray:function(b){var c=this.m;b[0]=c[0];b[1]=c[3];b[2]=c[6];b[3]=c[1];b[4]=c[4];b[5]=c[7];b[6]=c[2];b[7]=c[5];b[8]=c[8];return this}};THREE.Matrix4=function(b,c,d,e,j,h,k,m,q,p,n,s,r,v,B,y){this.set(b||1,c||0,d||0,e||0,j||0,h||1,k||0,m||0,q||0,p||0,n||1,s||0,r||0,v||0,B||0,y||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(b,c,d,e,j,h,k,m,q,p,n,s,r,v,B,y){this.n11=b;this.n12=c;this.n13=d;this.n14=e;this.n21=j;this.n22=h;this.n23=k;this.n24=m;this.n31=q;this.n32=p;this.n33=n;this.n34=s;this.n41=r;this.n42=v;this.n43=B;this.n44=y;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(b){this.set(b.n11,b.n12,b.n13,b.n14,b.n21,b.n22,b.n23,b.n24,b.n31,b.n32,b.n33,b.n34,b.n41,b.n42,b.n43,b.n44);return this},lookAt:function(b,
c,d){var e=THREE.Matrix4.__v1,j=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;h.sub(b,c).normalize();if(h.length()===0)h.z=1;e.cross(d,h).normalize();e.length()===0&&(h.x+=1.0E-4,e.cross(d,h).normalize());j.cross(h,e).normalize();this.n11=e.x;this.n12=j.x;this.n13=h.x;this.n21=e.y;this.n22=j.y;this.n23=h.y;this.n31=e.z;this.n32=j.z;this.n33=h.z;return this},multiplyVector3:function(b){var c=b.x,d=b.y,e=b.z,j=1/(this.n41*c+this.n42*d+this.n43*e+this.n44);b.x=(this.n11*c+this.n12*d+this.n13*e+this.n14)*j;
b.y=(this.n21*c+this.n22*d+this.n23*e+this.n24)*j;b.z=(this.n31*c+this.n32*d+this.n33*e+this.n34)*j;return b},multiplyVector4:function(b){var c=b.x,d=b.y,e=b.z,j=b.w;b.x=this.n11*c+this.n12*d+this.n13*e+this.n14*j;b.y=this.n21*c+this.n22*d+this.n23*e+this.n24*j;b.z=this.n31*c+this.n32*d+this.n33*e+this.n34*j;b.w=this.n41*c+this.n42*d+this.n43*e+this.n44*j;return b},rotateAxis:function(b){var c=b.x,d=b.y,e=b.z;b.x=c*this.n11+d*this.n12+e*this.n13;b.y=c*this.n21+d*this.n22+e*this.n23;b.z=c*this.n31+
d*this.n32+e*this.n33;b.normalize();return b},crossVector:function(b){var c=new THREE.Vector4;c.x=this.n11*b.x+this.n12*b.y+this.n13*b.z+this.n14*b.w;c.y=this.n21*b.x+this.n22*b.y+this.n23*b.z+this.n24*b.w;c.z=this.n31*b.x+this.n32*b.y+this.n33*b.z+this.n34*b.w;c.w=b.w?this.n41*b.x+this.n42*b.y+this.n43*b.z+this.n44*b.w:1;return c},multiply:function(b,c){var d=b.n11,e=b.n12,j=b.n13,h=b.n14,k=b.n21,m=b.n22,q=b.n23,p=b.n24,n=b.n31,s=b.n32,r=b.n33,v=b.n34,B=b.n41,y=b.n42,E=b.n43,L=b.n44,xa=c.n11,ya=
c.n12,ra=c.n13,na=c.n14,R=c.n21,N=c.n22,u=c.n23,U=c.n24,S=c.n31,Z=c.n32,T=c.n33,V=c.n34,I=c.n41,f=c.n42,ua=c.n43,Fa=c.n44;this.n11=d*xa+e*R+j*S+h*I;this.n12=d*ya+e*N+j*Z+h*f;this.n13=d*ra+e*u+j*T+h*ua;this.n14=d*na+e*U+j*V+h*Fa;this.n21=k*xa+m*R+q*S+p*I;this.n22=k*ya+m*N+q*Z+p*f;this.n23=k*ra+m*u+q*T+p*ua;this.n24=k*na+m*U+q*V+p*Fa;this.n31=n*xa+s*R+r*S+v*I;this.n32=n*ya+s*N+r*Z+v*f;this.n33=n*ra+s*u+r*T+v*ua;this.n34=n*na+s*U+r*V+v*Fa;this.n41=B*xa+y*R+E*S+L*I;this.n42=B*ya+y*N+E*Z+L*f;this.n43=
B*ra+y*u+E*T+L*ua;this.n44=B*na+y*U+E*V+L*Fa;return this},multiplyToArray:function(b,c,d){this.multiply(b,c);d[0]=this.n11;d[1]=this.n21;d[2]=this.n31;d[3]=this.n41;d[4]=this.n12;d[5]=this.n22;d[6]=this.n32;d[7]=this.n42;d[8]=this.n13;d[9]=this.n23;d[10]=this.n33;d[11]=this.n43;d[12]=this.n14;d[13]=this.n24;d[14]=this.n34;d[15]=this.n44;return this},multiplySelf:function(b){this.multiply(this,b);return this},multiplyScalar:function(b){this.n11*=b;this.n12*=b;this.n13*=b;this.n14*=b;this.n21*=b;this.n22*=
b;this.n23*=b;this.n24*=b;this.n31*=b;this.n32*=b;this.n33*=b;this.n34*=b;this.n41*=b;this.n42*=b;this.n43*=b;this.n44*=b;return this},determinant:function(){var b=this.n11,c=this.n12,d=this.n13,e=this.n14,j=this.n21,h=this.n22,k=this.n23,m=this.n24,q=this.n31,p=this.n32,n=this.n33,s=this.n34,r=this.n41,v=this.n42,B=this.n43,y=this.n44;return e*k*p*r-d*m*p*r-e*h*n*r+c*m*n*r+d*h*s*r-c*k*s*r-e*k*q*v+d*m*q*v+e*j*n*v-b*m*n*v-d*j*s*v+b*k*s*v+e*h*q*B-c*m*q*B-e*j*p*B+b*m*p*B+c*j*s*B-b*h*s*B-d*h*q*y+c*k*
q*y+d*j*p*y-b*k*p*y-c*j*n*y+b*h*n*y},transpose:function(){var b;b=this.n21;this.n21=this.n12;this.n12=b;b=this.n31;this.n31=this.n13;this.n13=b;b=this.n32;this.n32=this.n23;this.n23=b;b=this.n41;this.n41=this.n14;this.n14=b;b=this.n42;this.n42=this.n24;this.n24=b;b=this.n43;this.n43=this.n34;this.n43=b;return this},clone:function(){var b=new THREE.Matrix4;b.n11=this.n11;b.n12=this.n12;b.n13=this.n13;b.n14=this.n14;b.n21=this.n21;b.n22=this.n22;b.n23=this.n23;b.n24=this.n24;b.n31=this.n31;b.n32=this.n32;
b.n33=this.n33;b.n34=this.n34;b.n41=this.n41;b.n42=this.n42;b.n43=this.n43;b.n44=this.n44;return b},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(b){b[0]=
this.n11;b[1]=this.n21;b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return b},flattenToArrayOffset:function(b,c){b[c]=this.n11;b[c+1]=this.n21;b[c+2]=this.n31;b[c+3]=this.n41;b[c+4]=this.n12;b[c+5]=this.n22;b[c+6]=this.n32;b[c+7]=this.n42;b[c+8]=this.n13;b[c+9]=this.n23;b[c+10]=this.n33;b[c+11]=this.n43;b[c+12]=this.n14;b[c+13]=this.n24;b[c+14]=
this.n34;b[c+15]=this.n44;return b},setTranslation:function(b,c,d){this.set(1,0,0,b,0,1,0,c,0,0,1,d,0,0,0,1);return this},setScale:function(b,c,d){this.set(b,0,0,0,0,c,0,0,0,0,d,0,0,0,0,1);return this},setRotationX:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(1,0,0,0,0,c,-b,0,0,b,c,0,0,0,0,1);return this},setRotationY:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,0,b,0,0,1,0,0,-b,0,c,0,0,0,0,1);return this},setRotationZ:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,-b,0,
0,b,c,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(b,c){var d=Math.cos(c),e=Math.sin(c),j=1-d,h=b.x,k=b.y,m=b.z,q=j*h,p=j*k;this.set(q*h+d,q*k-e*m,q*m+e*k,0,q*k+e*m,p*k+d,p*m-e*h,0,q*m-e*k,p*m+e*h,j*m*m+d,0,0,0,0,1);return this},setPosition:function(b){this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(b,c){var d=b.x,e=b.y,j=b.z,h=Math.cos(d),d=Math.sin(d),k=Math.cos(e),e=Math.sin(e),m=Math.cos(j),j=Math.sin(j);switch(c){case "YXZ":var q=
k*m,p=k*j,n=e*m,s=e*j;this.n11=q+s*d;this.n12=n*d-p;this.n13=h*e;this.n21=h*j;this.n22=h*m;this.n23=-d;this.n31=p*d-n;this.n32=s+q*d;this.n33=h*k;break;case "ZXY":q=k*m;p=k*j;n=e*m;s=e*j;this.n11=q-s*d;this.n12=-h*j;this.n13=n+p*d;this.n21=p+n*d;this.n22=h*m;this.n23=s-q*d;this.n31=-h*e;this.n32=d;this.n33=h*k;break;case "ZYX":q=h*m;p=h*j;n=d*m;s=d*j;this.n11=k*m;this.n12=n*e-p;this.n13=q*e+s;this.n21=k*j;this.n22=s*e+q;this.n23=p*e-n;this.n31=-e;this.n32=d*k;this.n33=h*k;break;case "YZX":q=h*k;p=
h*e;n=d*k;s=d*e;this.n11=k*m;this.n12=s-q*j;this.n13=n*j+p;this.n21=j;this.n22=h*m;this.n23=-d*m;this.n31=-e*m;this.n32=p*j+n;this.n33=q-s*j;break;case "XZY":q=h*k;p=h*e;n=d*k;s=d*e;this.n11=k*m;this.n12=-j;this.n13=e*m;this.n21=q*j+s;this.n22=h*m;this.n23=p*j-n;this.n31=n*j-p;this.n32=d*m;this.n33=s*j+q;break;default:q=h*m,p=h*j,n=d*m,s=d*j,this.n11=k*m,this.n12=-k*j,this.n13=e,this.n21=p+n*e,this.n22=q-s*e,this.n23=-d*k,this.n31=s-q*e,this.n32=n+p*e,this.n33=h*k}return this},setRotationFromQuaternion:function(b){var c=
b.x,d=b.y,e=b.z,j=b.w,h=c+c,k=d+d,m=e+e,b=c*h,q=c*k;c*=m;var p=d*k;d*=m;e*=m;h*=j;k*=j;j*=m;this.n11=1-(p+e);this.n12=q-j;this.n13=c+k;this.n21=q+j;this.n22=1-(b+e);this.n23=d-h;this.n31=c-k;this.n32=d+h;this.n33=1-(b+p);return this},scale:function(b){var c=b.x,d=b.y,b=b.z;this.n11*=c;this.n12*=d;this.n13*=b;this.n21*=c;this.n22*=d;this.n23*=b;this.n31*=c;this.n32*=d;this.n33*=b;this.n41*=c;this.n42*=d;this.n43*=b;return this},compose:function(b,c,d){var e=THREE.Matrix4.__m1,j=THREE.Matrix4.__m2;
e.identity();e.setRotationFromQuaternion(c);j.setScale(d.x,d.y,d.z);this.multiply(e,j);this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},decompose:function(b,c,d){var e=THREE.Matrix4.__v1,j=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;e.set(this.n11,this.n21,this.n31);j.set(this.n12,this.n22,this.n32);h.set(this.n13,this.n23,this.n33);b=b instanceof THREE.Vector3?b:new THREE.Vector3;c=c instanceof THREE.Quaternion?c:new THREE.Quaternion;d=d instanceof THREE.Vector3?d:new THREE.Vector3;d.x=e.length();
d.y=j.length();d.z=h.length();b.x=this.n14;b.y=this.n24;b.z=this.n34;e=THREE.Matrix4.__m1;e.copy(this);e.n11/=d.x;e.n21/=d.x;e.n31/=d.x;e.n12/=d.y;e.n22/=d.y;e.n32/=d.y;e.n13/=d.z;e.n23/=d.z;e.n33/=d.z;c.setFromRotationMatrix(e);return[b,c,d]},extractPosition:function(b){this.n14=b.n14;this.n24=b.n24;this.n34=b.n34},extractRotation:function(b,c){var d=1/c.x,e=1/c.y,j=1/c.z;this.n11=b.n11*d;this.n21=b.n21*d;this.n31=b.n31*d;this.n12=b.n12*e;this.n22=b.n22*e;this.n32=b.n32*e;this.n13=b.n13*j;this.n23=
b.n23*j;this.n33=b.n33*j}};
THREE.Matrix4.makeInvert=function(b,c){var d=b.n11,e=b.n12,j=b.n13,h=b.n14,k=b.n21,m=b.n22,q=b.n23,p=b.n24,n=b.n31,s=b.n32,r=b.n33,v=b.n34,B=b.n41,y=b.n42,E=b.n43,L=b.n44;c===void 0&&(c=new THREE.Matrix4);c.n11=q*v*y-p*r*y+p*s*E-m*v*E-q*s*L+m*r*L;c.n12=h*r*y-j*v*y-h*s*E+e*v*E+j*s*L-e*r*L;c.n13=j*p*y-h*q*y+h*m*E-e*p*E-j*m*L+e*q*L;c.n14=h*q*s-j*p*s-h*m*r+e*p*r+j*m*v-e*q*v;c.n21=p*r*B-q*v*B-p*n*E+k*v*E+q*n*L-k*r*L;c.n22=j*v*B-h*r*B+h*n*E-d*v*E-j*n*L+d*r*L;c.n23=h*q*B-j*p*B-h*k*E+d*p*E+j*k*L-d*q*L;c.n24=
j*p*n-h*q*n+h*k*r-d*p*r-j*k*v+d*q*v;c.n31=m*v*B-p*s*B+p*n*y-k*v*y-m*n*L+k*s*L;c.n32=h*s*B-e*v*B-h*n*y+d*v*y+e*n*L-d*s*L;c.n33=j*p*B-h*m*B+h*k*y-d*p*y-e*k*L+d*m*L;c.n34=h*m*n-e*p*n-h*k*s+d*p*s+e*k*v-d*m*v;c.n41=q*s*B-m*r*B-q*n*y+k*r*y+m*n*E-k*s*E;c.n42=e*r*B-j*s*B+j*n*y-d*r*y-e*n*E+d*s*E;c.n43=j*m*B-e*q*B-j*k*y+d*q*y+e*k*E-d*m*E;c.n44=e*q*n-j*m*n+j*k*s-d*q*s-e*k*r+d*m*r;c.multiplyScalar(1/b.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(b){var c=b.m33,d=c.m,e=b.n33*b.n22-b.n32*b.n23,j=-b.n33*b.n21+b.n31*b.n23,h=b.n32*b.n21-b.n31*b.n22,k=-b.n33*b.n12+b.n32*b.n13,m=b.n33*b.n11-b.n31*b.n13,q=-b.n32*b.n11+b.n31*b.n12,p=b.n23*b.n12-b.n22*b.n13,n=-b.n23*b.n11+b.n21*b.n13,s=b.n22*b.n11-b.n21*b.n12,b=b.n11*e+b.n21*k+b.n31*p;b==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");b=1/b;d[0]=b*e;d[1]=b*j;d[2]=b*h;d[3]=b*k;d[4]=b*m;d[5]=b*q;d[6]=b*p;d[7]=b*n;d[8]=b*s;return c};
THREE.Matrix4.makeFrustum=function(b,c,d,e,j,h){var k;k=new THREE.Matrix4;k.n11=2*j/(c-b);k.n12=0;k.n13=(c+b)/(c-b);k.n14=0;k.n21=0;k.n22=2*j/(e-d);k.n23=(e+d)/(e-d);k.n24=0;k.n31=0;k.n32=0;k.n33=-(h+j)/(h-j);k.n34=-2*h*j/(h-j);k.n41=0;k.n42=0;k.n43=-1;k.n44=0;return k};THREE.Matrix4.makePerspective=function(b,c,d,e){var j,b=d*Math.tan(b*Math.PI/360);j=-b;return THREE.Matrix4.makeFrustum(j*c,b*c,j,b,d,e)};
THREE.Matrix4.makeOrtho=function(b,c,d,e,j,h){var k,m,q,p;k=new THREE.Matrix4;m=c-b;q=d-e;p=h-j;k.n11=2/m;k.n12=0;k.n13=0;k.n14=-((c+b)/m);k.n21=0;k.n22=2/q;k.n23=0;k.n24=-((d+e)/q);k.n31=0;k.n32=0;k.n33=-2/p;k.n34=-((h+j)/p);k.n41=0;k.n42=0;k.n43=0;k.n44=1;return k};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(b,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(b))},translateX:function(b){this.translate(b,this._vector.set(1,0,0))},translateY:function(b){this.translate(b,this._vector.set(0,1,0))},translateZ:function(b){this.translate(b,this._vector.set(0,0,1))},lookAt:function(b){this.matrix.lookAt(b,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(b){if(this.children.indexOf(b)===
-1){b.parent!==void 0&&b.parent.removeChild(b);b.parent=this;this.children.push(b);for(var c=this;c.parent!==void 0;)c=c.parent;c!==void 0&&c instanceof THREE.Scene&&c.addChildRecurse(b)}},removeChild:function(b){var c=this.children.indexOf(b);if(c!==-1)b.parent=void 0,this.children.splice(c,1)},getChildByName:function(b,c){var d,e,j;d=0;for(e=this.children.length;d<e;d++){j=this.children[d];if(j.name===b)return j;if(c&&(j=j.getChildByName(b,c),j!==void 0))return j}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(b,c,d){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||c)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,c=!0;for(var b=0,e=this.children.length;b<e;b++)this.children[b].update(this.matrixWorld,c,d)}};THREE.Object3DCount=0;
THREE.Projector=function(){function b(){var b=q[m]=q[m]||new THREE.RenderableVertex;m++;return b}function c(b,c){return c.z-b.z}function d(b,c){var f=0,d=1,e=b.z+b.w,j=c.z+c.w,h=-b.z+b.w,k=-c.z+c.w;return e>=0&&j>=0&&h>=0&&k>=0?!0:e<0&&j<0||h<0&&k<0?!1:(e<0?f=Math.max(f,e/(e-j)):j<0&&(d=Math.min(d,e/(e-j))),h<0?f=Math.max(f,h/(h-k)):k<0&&(d=Math.min(d,h/(h-k))),d<f?!1:(b.lerpSelf(c,f),c.lerpSelf(b,1-d),!0))}var e,j,h=[],k,m,q=[],p,n,s=[],r,v=[],B,y,E=[],L,xa,ya=[],ra=[],na=[],R=new THREE.Vector4,
N=new THREE.Vector4,u=new THREE.Matrix4,U=new THREE.Matrix4,S=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],Z=new THREE.Vector4,T=new THREE.Vector4;this.projectVector=function(b,c){u.multiply(c.projectionMatrix,c.matrixWorldInverse);u.multiplyVector3(b);return b};this.unprojectVector=function(b,c){u.multiply(c.matrixWorld,THREE.Matrix4.makeInvert(c.projectionMatrix));u.multiplyVector3(b);return b};this.projectObjects=function(b,d,f){var k,
m;j=ra.length=0;k=b.objects;b=0;for(d=k.length;b<d;b++){m=k[b];var p;if(!(p=!m.visible))if(p=m instanceof THREE.Mesh)if(p=m.frustumCulled){a:{p=void 0;for(var q=m.matrixWorld,n=-m.geometry.boundingSphere.radius*Math.max(m.scale.x,Math.max(m.scale.y,m.scale.z)),v=0;v<6;v++)if(p=S[v].x*q.n14+S[v].y*q.n24+S[v].z*q.n34+S[v].w,p<=n){p=!1;break a}p=!0}p=!p}if(!p)p=h[j]=h[j]||new THREE.RenderableObject,j++,e=p,R.copy(m.position),u.multiplyVector3(R),e.object=m,e.z=R.z,ra.push(e)}f&&ra.sort(c);return ra};
this.projectScene=function(e,j,f){var h=j.near,ra=j.far,R,va,W,$,C,X,P,la,ga,M,za,Da,Ea,ia,sa,Aa,Ca;xa=y=r=n=na.length=0;j.matrixAutoUpdate&&j.update(void 0,!0);e.update(void 0,!1,j);u.multiply(j.projectionMatrix,j.matrixWorldInverse);S[0].set(u.n41-u.n11,u.n42-u.n12,u.n43-u.n13,u.n44-u.n14);S[1].set(u.n41+u.n11,u.n42+u.n12,u.n43+u.n13,u.n44+u.n14);S[2].set(u.n41+u.n21,u.n42+u.n22,u.n43+u.n23,u.n44+u.n24);S[3].set(u.n41-u.n21,u.n42-u.n22,u.n43-u.n23,u.n44-u.n24);S[4].set(u.n41-u.n31,u.n42-u.n32,u.n43-
u.n33,u.n44-u.n34);S[5].set(u.n41+u.n31,u.n42+u.n32,u.n43+u.n33,u.n44+u.n34);for(R=0;R<6;R++)ga=S[R],ga.divideScalar(Math.sqrt(ga.x*ga.x+ga.y*ga.y+ga.z*ga.z));ga=this.projectObjects(e,j,!0);e=0;for(R=ga.length;e<R;e++)if(M=ga[e].object,M.visible)if(za=M.matrixWorld,Da=M.matrixRotationWorld,Ea=M.materials,ia=M.overdraw,m=0,M instanceof THREE.Mesh){sa=M.geometry;$=sa.vertices;Aa=sa.faces;sa=sa.faceVertexUvs;va=0;for(W=$.length;va<W;va++)k=b(),k.positionWorld.copy($[va].position),za.multiplyVector3(k.positionWorld),
k.positionScreen.copy(k.positionWorld),u.multiplyVector4(k.positionScreen),k.positionScreen.x/=k.positionScreen.w,k.positionScreen.y/=k.positionScreen.w,k.visible=k.positionScreen.z>h&&k.positionScreen.z<ra;$=0;for(va=Aa.length;$<va;$++){W=Aa[$];if(W instanceof THREE.Face3)if(C=q[W.a],X=q[W.b],P=q[W.c],C.visible&&X.visible&&P.visible&&(M.doubleSided||M.flipSided!=(P.positionScreen.x-C.positionScreen.x)*(X.positionScreen.y-C.positionScreen.y)-(P.positionScreen.y-C.positionScreen.y)*(X.positionScreen.x-
C.positionScreen.x)<0))la=s[n]=s[n]||new THREE.RenderableFace3,n++,p=la,p.v1.copy(C),p.v2.copy(X),p.v3.copy(P);else continue;else if(W instanceof THREE.Face4)if(C=q[W.a],X=q[W.b],P=q[W.c],la=q[W.d],C.visible&&X.visible&&P.visible&&la.visible&&(M.doubleSided||M.flipSided!=((la.positionScreen.x-C.positionScreen.x)*(X.positionScreen.y-C.positionScreen.y)-(la.positionScreen.y-C.positionScreen.y)*(X.positionScreen.x-C.positionScreen.x)<0||(X.positionScreen.x-P.positionScreen.x)*(la.positionScreen.y-P.positionScreen.y)-
(X.positionScreen.y-P.positionScreen.y)*(la.positionScreen.x-P.positionScreen.x)<0)))Ca=v[r]=v[r]||new THREE.RenderableFace4,r++,p=Ca,p.v1.copy(C),p.v2.copy(X),p.v3.copy(P),p.v4.copy(la);else continue;p.normalWorld.copy(W.normal);Da.multiplyVector3(p.normalWorld);p.centroidWorld.copy(W.centroid);za.multiplyVector3(p.centroidWorld);p.centroidScreen.copy(p.centroidWorld);u.multiplyVector3(p.centroidScreen);P=W.vertexNormals;C=0;for(X=P.length;C<X;C++)la=p.vertexNormalsWorld[C],la.copy(P[C]),Da.multiplyVector3(la);
C=0;for(X=sa.length;C<X;C++)if(Ca=sa[C][$]){P=0;for(la=Ca.length;P<la;P++)p.uvs[C][P]=Ca[P]}p.meshMaterials=Ea;p.faceMaterials=W.materials;p.overdraw=ia;p.z=p.centroidScreen.z;na.push(p)}}else if(M instanceof THREE.Line){U.multiply(u,za);$=M.geometry.vertices;C=b();C.positionScreen.copy($[0].position);U.multiplyVector4(C.positionScreen);va=1;for(W=$.length;va<W;va++)if(C=b(),C.positionScreen.copy($[va].position),U.multiplyVector4(C.positionScreen),X=q[m-2],Z.copy(C.positionScreen),T.copy(X.positionScreen),
d(Z,T))Z.multiplyScalar(1/Z.w),T.multiplyScalar(1/T.w),za=E[y]=E[y]||new THREE.RenderableLine,y++,B=za,B.v1.positionScreen.copy(Z),B.v2.positionScreen.copy(T),B.z=Math.max(Z.z,T.z),B.materials=M.materials,na.push(B)}else if(M instanceof THREE.Particle&&(N.set(M.matrixWorld.n14,M.matrixWorld.n24,M.matrixWorld.n34,1),u.multiplyVector4(N),N.z/=N.w,N.z>0&&N.z<1))za=ya[xa]=ya[xa]||new THREE.RenderableParticle,xa++,L=za,L.x=N.x/N.w,L.y=N.y/N.w,L.z=N.z,L.rotation=M.rotation.z,L.scale.x=M.scale.x*Math.abs(L.x-
(N.x+j.projectionMatrix.n11)/(N.w+j.projectionMatrix.n14)),L.scale.y=M.scale.y*Math.abs(L.y-(N.y+j.projectionMatrix.n22)/(N.w+j.projectionMatrix.n24)),L.materials=M.materials,na.push(L);f&&na.sort(c);return na}};THREE.Quaternion=function(b,c,d,e){this.set(b||0,c||0,d||0,e!==void 0?e:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(b,c,d,e){this.x=b;this.y=c;this.z=d;this.w=e;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w;return this},setFromEuler:function(b){var c=0.5*Math.PI/360,d=b.x*c,e=b.y*c,j=b.z*c,b=Math.cos(e),e=Math.sin(e),c=Math.cos(-j),j=Math.sin(-j),h=Math.cos(d),d=Math.sin(d),k=b*c,m=e*j;this.w=k*h-m*d;this.x=k*d+m*h;this.y=e*c*h+b*j*d;this.z=b*j*h-e*c*d;return this},setFromAxisAngle:function(b,c){var d=c/2,e=Math.sin(d);
this.x=b.x*e;this.y=b.y*e;this.z=b.z*e;this.w=Math.cos(d);return this},setFromRotationMatrix:function(b){var c=Math.pow(b.determinant(),1/3);this.w=Math.sqrt(Math.max(0,c+b.n11+b.n22+b.n33))/2;this.x=Math.sqrt(Math.max(0,c+b.n11-b.n22-b.n33))/2;this.y=Math.sqrt(Math.max(0,c-b.n11+b.n22-b.n33))/2;this.z=Math.sqrt(Math.max(0,c-b.n11-b.n22+b.n33))/2;this.x=b.n32-b.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=b.n13-b.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=b.n21-b.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var b=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);b==0?this.w=this.z=this.y=this.x=0:(b=1/b,this.x*=b,this.y*=b,this.z*=b,this.w*=b);return this},multiplySelf:function(b){var c=
this.x,d=this.y,e=this.z,j=this.w,h=b.x,k=b.y,m=b.z,b=b.w;this.x=c*b+j*h+d*m-e*k;this.y=d*b+j*k+e*h-c*m;this.z=e*b+j*m+c*k-d*h;this.w=j*b-c*h-d*k-e*m;return this},multiply:function(b,c){this.x=b.x*c.w+b.y*c.z-b.z*c.y+b.w*c.x;this.y=-b.x*c.z+b.y*c.w+b.z*c.x+b.w*c.y;this.z=b.x*c.y-b.y*c.x+b.z*c.w+b.w*c.z;this.w=-b.x*c.x-b.y*c.y-b.z*c.z+b.w*c.w;return this},multiplyVector3:function(b,c){c||(c=b);var d=b.x,e=b.y,j=b.z,h=this.x,k=this.y,m=this.z,q=this.w,p=q*d+k*j-m*e,n=q*e+m*d-h*j,s=q*j+h*e-k*d,d=-h*
d-k*e-m*j;c.x=p*q+d*-h+n*-m-s*-k;c.y=n*q+d*-k+s*-h-p*-m;c.z=s*q+d*-m+p*-k-n*-h;return c}};THREE.Quaternion.slerp=function(b,c,d,e){var j=b.w*c.w+b.x*c.x+b.y*c.y+b.z*c.z;if(Math.abs(j)>=1)return d.w=b.w,d.x=b.x,d.y=b.y,d.z=b.z,d;var h=Math.acos(j),k=Math.sqrt(1-j*j);if(Math.abs(k)<0.001)return d.w=0.5*(b.w+c.w),d.x=0.5*(b.x+c.x),d.y=0.5*(b.y+c.y),d.z=0.5*(b.z+c.z),d;j=Math.sin((1-e)*h)/k;e=Math.sin(e*h)/k;d.w=b.w*j+c.w*e;d.x=b.x*j+c.x*e;d.y=b.y*j+c.y*e;d.z=b.z*j+c.z*e;return d};
THREE.Vertex=function(b){this.position=b||new THREE.Vector3};THREE.Face3=function(b,c,d,e,j,h){this.a=b;this.b=c;this.c=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=j instanceof THREE.Color?j:new THREE.Color;this.vertexColors=j instanceof Array?j:[];this.vertexTangents=[];this.materials=h instanceof Array?h:[h];this.centroid=new THREE.Vector3};
THREE.Face4=function(b,c,d,e,j,h,k){this.a=b;this.b=c;this.c=d;this.d=e;this.normal=j instanceof THREE.Vector3?j:new THREE.Vector3;this.vertexNormals=j instanceof Array?j:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=k instanceof Array?k:[k];this.centroid=new THREE.Vector3};THREE.UV=function(b,c){this.u=b||0;this.v=c||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(b,c){this.u=b;this.v=c;return this},copy:function(b){this.u=b.u;this.v=b.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,computeCentroids:function(){var b,c,d;b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d.centroid.set(0,0,0),d instanceof THREE.Face3?(d.centroid.addSelf(this.vertices[d.a].position),d.centroid.addSelf(this.vertices[d.b].position),d.centroid.addSelf(this.vertices[d.c].position),d.centroid.divideScalar(3)):d instanceof THREE.Face4&&(d.centroid.addSelf(this.vertices[d.a].position),d.centroid.addSelf(this.vertices[d.b].position),d.centroid.addSelf(this.vertices[d.c].position),
d.centroid.addSelf(this.vertices[d.d].position),d.centroid.divideScalar(4))},computeFaceNormals:function(b){var c,d,e,j,h,k,m=new THREE.Vector3,q=new THREE.Vector3;e=0;for(j=this.faces.length;e<j;e++){h=this.faces[e];if(b&&h.vertexNormals.length){m.set(0,0,0);c=0;for(d=h.vertexNormals.length;c<d;c++)m.addSelf(h.vertexNormals[c]);m.divideScalar(3)}else c=this.vertices[h.a],d=this.vertices[h.b],k=this.vertices[h.c],m.sub(k.position,d.position),q.sub(c.position,d.position),m.crossSelf(q);m.isZero()||
m.normalize();h.normal.copy(m)}},computeVertexNormals:function(){var b,c,d,e;if(this.__tmpVertices==void 0){e=this.__tmpVertices=Array(this.vertices.length);b=0;for(c=this.vertices.length;b<c;b++)e[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)if(d=this.faces[b],d instanceof THREE.Face3)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(d instanceof THREE.Face4)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{e=
this.__tmpVertices;b=0;for(c=this.vertices.length;b<c;b++)e[b].set(0,0,0)}b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d instanceof THREE.Face3?(e[d.a].addSelf(d.normal),e[d.b].addSelf(d.normal),e[d.c].addSelf(d.normal)):d instanceof THREE.Face4&&(e[d.a].addSelf(d.normal),e[d.b].addSelf(d.normal),e[d.c].addSelf(d.normal),e[d.d].addSelf(d.normal));b=0;for(c=this.vertices.length;b<c;b++)e[b].normalize();b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d instanceof THREE.Face3?(d.vertexNormals[0].copy(e[d.a]),
d.vertexNormals[1].copy(e[d.b]),d.vertexNormals[2].copy(e[d.c])):d instanceof THREE.Face4&&(d.vertexNormals[0].copy(e[d.a]),d.vertexNormals[1].copy(e[d.b]),d.vertexNormals[2].copy(e[d.c]),d.vertexNormals[3].copy(e[d.d]))},computeTangents:function(){function b(b,f,c,d,e,j,h){m=b.vertices[f].position;q=b.vertices[c].position;p=b.vertices[d].position;n=k[e];s=k[j];r=k[h];v=q.x-m.x;B=p.x-m.x;y=q.y-m.y;E=p.y-m.y;L=q.z-m.z;xa=p.z-m.z;ya=s.u-n.u;ra=r.u-n.u;na=s.v-n.v;R=r.v-n.v;N=1/(ya*R-ra*na);Z.set((R*
v-na*B)*N,(R*y-na*E)*N,(R*L-na*xa)*N);T.set((ya*B-ra*v)*N,(ya*E-ra*y)*N,(ya*xa-ra*L)*N);U[f].addSelf(Z);U[c].addSelf(Z);U[d].addSelf(Z);S[f].addSelf(T);S[c].addSelf(T);S[d].addSelf(T)}var c,d,e,j,h,k,m,q,p,n,s,r,v,B,y,E,L,xa,ya,ra,na,R,N,u,U=[],S=[],Z=new THREE.Vector3,T=new THREE.Vector3,V=new THREE.Vector3,I=new THREE.Vector3,f=new THREE.Vector3;c=0;for(d=this.vertices.length;c<d;c++)U[c]=new THREE.Vector3,S[c]=new THREE.Vector3;c=0;for(d=this.faces.length;c<d;c++)h=this.faces[c],k=this.faceVertexUvs[0][c],
h instanceof THREE.Face3?b(this,h.a,h.b,h.c,0,1,2):h instanceof THREE.Face4&&(b(this,h.a,h.b,h.c,0,1,2),b(this,h.a,h.b,h.d,0,1,3));var ua=["a","b","c","d"];c=0;for(d=this.faces.length;c<d;c++){h=this.faces[c];for(e=0;e<h.vertexNormals.length;e++)f.copy(h.vertexNormals[e]),j=h[ua[e]],u=U[j],V.copy(u),V.subSelf(f.multiplyScalar(f.dot(u))).normalize(),I.cross(h.vertexNormals[e],u),j=I.dot(S[j]),j=j<0?-1:1,h.vertexTangents[e]=new THREE.Vector4(V.x,V.y,V.z,j)}this.hasTangents=!0},computeBoundingBox:function(){var b;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,d=this.vertices.length;c<d;c++){b=this.vertices[c];if(b.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=b.position.x;else if(b.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=b.position.x;if(b.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=b.position.y;
else if(b.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=b.position.y;if(b.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=b.position.z;else if(b.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=b.position.z}}},computeBoundingSphere:function(){for(var b=0,c=0,d=this.vertices.length;c<d;c++)b=Math.max(b,this.vertices[c].position.length());this.boundingSphere={radius:b}},computeEdgeFaces:function(){function b(b,c){return Math.min(b,c)+"_"+Math.max(b,c)}function c(b,c,d){b[c]===
void 0?(b[c]={set:{},array:[]},b[c].set[d]=1,b[c].array.push(d)):b[c].set[d]===void 0&&(b[c].set[d]=1,b[c].array.push(d))}var d,e,j,h,k,m={};d=0;for(e=this.faces.length;d<e;d++)k=this.faces[d],k instanceof THREE.Face3?(j=b(k.a,k.b),c(m,j,d),j=b(k.b,k.c),c(m,j,d),j=b(k.a,k.c),c(m,j,d)):k instanceof THREE.Face4&&(j=b(k.b,k.d),c(m,j,d),j=b(k.a,k.b),c(m,j,d),j=b(k.a,k.d),c(m,j,d),j=b(k.b,k.c),c(m,j,d),j=b(k.c,k.d),c(m,j,d));d=0;for(e=this.edges.length;d<e;d++){k=this.edges[d];j=k.vertexIndices[0];h=k.vertexIndices[1];
k.faceIndices=m[b(j,h)].array;for(j=0;j<k.faceIndices.length;j++)h=k.faceIndices[j],k.faces.push(this.faces[h])}}};THREE.GeometryCount=0;
THREE.Spline=function(b){function c(b,c,d,e,j,h,k){b=(d-b)*0.5;e=(e-c)*0.5;return(2*(c-d)+b+e)*k+(-3*(c-d)-2*b-e)*h+b*j+c}this.points=b;var d=[],e={x:0,y:0,z:0},j,h,k,m,q,p,n,s,r;this.initFromArray=function(b){this.points=[];for(var c=0;c<b.length;c++)this.points[c]={x:b[c][0],y:b[c][1],z:b[c][2]}};this.getPoint=function(b){j=(this.points.length-1)*b;h=Math.floor(j);k=j-h;d[0]=h==0?h:h-1;d[1]=h;d[2]=h>this.points.length-2?h:h+1;d[3]=h>this.points.length-3?h:h+2;p=this.points[d[0]];n=this.points[d[1]];
s=this.points[d[2]];r=this.points[d[3]];m=k*k;q=k*m;e.x=c(p.x,n.x,s.x,r.x,k,m,q);e.y=c(p.y,n.y,s.y,r.y,k,m,q);e.z=c(p.z,n.z,s.z,r.z,k,m,q);return e};this.getControlPointsArray=function(){var b,c,d=this.points.length,e=[];for(b=0;b<d;b++)c=this.points[b],e[b]=[c.x,c.y,c.z];return e};this.getLength=function(b){var c,d,e=c=c=0,j=new THREE.Vector3,h=new THREE.Vector3,k=[],m=0;k[0]=0;b||(b=100);d=this.points.length*b;j.copy(this.points[0]);for(b=1;b<d;b++)c=b/d,position=this.getPoint(c),h.copy(position),
m+=h.distanceTo(j),j.copy(position),c*=this.points.length-1,c=Math.floor(c),c!=e&&(k[c]=m,e=c);k[k.length]=m;return{chunks:k,total:m}};this.reparametrizeByArcLength=function(b){var c,d,e,j,h,k,m=[],p=new THREE.Vector3,q=this.getLength();m.push(p.copy(this.points[0]).clone());for(c=1;c<this.points.length;c++){d=q.chunks[c]-q.chunks[c-1];k=Math.ceil(b*d/q.total);j=(c-1)/(this.points.length-1);h=c/(this.points.length-1);for(d=1;d<k-1;d++)e=j+d*(1/k)*(h-j),position=this.getPoint(e),m.push(p.copy(position).clone());
m.push(p.copy(this.points[c]).clone())}this.points=m}};THREE.Edge=function(b,c,d,e){this.vertices=[b,c];this.vertexIndices=[d,e];this.faces=[];this.faceIndices=[]};THREE.Camera=function(b,c,d,e,j){THREE.Object3D.call(this);this.fov=b||50;this.aspect=c||1;this.near=d||0.1;this.far=e||2E3;this.target=j||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;
THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(b,c){this.matrix.rotateAxis(c);c.multiplyScalar(b);this.position.addSelf(c);this.target.position.addSelf(c)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var b=this.fullWidth/this.fullHeight,c=Math.tan(this.fov*Math.PI/360)*this.near,d=-c,e=b*d,b=Math.abs(b*c-e),d=Math.abs(c-d);this.projectionMatrix=THREE.Matrix4.makeFrustum(e+this.x*b/this.fullWidth,e+(this.x+this.width)*b/this.fullWidth,c-(this.y+this.height)*d/this.fullHeight,c-this.y*d/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(b,c,d,e,j,h){this.fullWidth=b;this.fullHeight=c;this.x=d;this.y=e;this.width=j;this.height=h;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(b,c,d){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),c=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,c=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,d)};THREE.OrthoCamera=function(b,c,d,e,j,h,k){THREE.Camera.call(this,45,1,j,h,k);this.left=b;this.right=c;this.top=d;this.bottom=e;this.updateProjectionMatrix()};THREE.OrthoCamera.prototype=new THREE.Camera;THREE.OrthoCamera.prototype.constructor=THREE.OrthoCamera;
THREE.OrthoCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.Light=function(b){THREE.Object3D.call(this);this.color=new THREE.Color(b)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(b){THREE.Light.call(this,b)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(b,c,d,e){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1;this.distance=d||0;this.castShadow=e!==void 0?e:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(b,c,d){THREE.Light.call(this,b);this.position=new THREE.Vector3;this.intensity=c||1;this.distance=d||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.SpotLight=function(b,c,d,e){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=c||1;this.distance=d||0;this.castShadow=e!==void 0?e:!1};THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(b){this.id=THREE.MaterialCount++;b=b||{};this.opacity=b.opacity!==void 0?b.opacity:1;this.transparent=b.transparent!==void 0?b.transparent:!1;this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.depthTest=b.depthTest!==void 0?b.depthTest:!0;this.polygonOffset=b.polygonOffset!==void 0?b.polygonOffset:!1;this.polygonOffsetFactor=b.polygonOffsetFactor!==void 0?b.polygonOffsetFactor:0;this.polygonOffsetUnits=b.polygonOffsetUnits!==void 0?b.polygonOffsetUnits:
0;this.alphaTest=b.alphaTest!==void 0?b.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.linewidth=b.linewidth!==void 0?b.linewidth:1;this.linecap=b.linecap!==void 0?b.linecap:"round";this.linejoin=b.linejoin!==void 0?b.linejoin:"round";this.vertexColors=b.vertexColors?b.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.ambient=b.ambient!==void 0?new THREE.Color(b.ambient):new THREE.Color(328965);this.specular=b.specular!==void 0?new THREE.Color(b.specular):new THREE.Color(1118481);this.shininess=b.shininess!==void 0?b.shininess:30;this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;
this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==
void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading?b.shading:THREE.FlatShading;this.wireframe=b.wireframe?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth?b.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.fragmentShader=b.fragmentShader!==void 0?b.fragmentShader:"void main() {}";this.vertexShader=b.vertexShader!==void 0?b.vertexShader:"void main() {}";this.uniforms=b.uniforms!==void 0?b.uniforms:{};this.attributes=b.attributes;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.fog=
b.fog!==void 0?b.fog:!1;this.lights=b.lights!==void 0?b.lights:!1;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshShaderMaterial.prototype=new THREE.Material;THREE.MeshShaderMaterial.prototype.constructor=THREE.MeshShaderMaterial;
THREE.ParticleBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.size=b.size!==void 0?b.size:1;this.sizeAttenuation=b.sizeAttenuation!==void 0?b.sizeAttenuation:!0;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Texture=function(b,c,d,e,j,h){this.id=THREE.TextureCount++;this.image=b;this.mapping=c!==void 0?c:new THREE.UVMapping;this.wrapS=d!==void 0?d:THREE.ClampToEdgeWrapping;this.wrapT=e!==void 0?e:THREE.ClampToEdgeWrapping;this.magFilter=j!==void 0?j:THREE.LinearFilter;this.minFilter=h!==void 0?h:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var b=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);b.offset.copy(this.offset);b.repeat.copy(this.repeat);return b}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;
THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.sortParticles=!1};
THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(b,c,d){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.type=d!=void 0?d:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c&&c.length?c:[c];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=b.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var d=0;d<this.geometry.morphTargets.length;d++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[d].name]=
d}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(b){if(this.morphTargetDictionary[b]!==void 0)return this.morphTargetDictionary[b];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+b+" does not exist. Returning 0.");return 0};
THREE.Bone=function(b){THREE.Object3D.call(this);this.skin=b;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(b,c,d){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.skinMatrix.multiply(b,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var e,j=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(e=0;e<j;e++)b=this.children[e],b instanceof THREE.Bone?b.update(this.skinMatrix,c,d):b.update(this.matrixWorld,!0,d)}else for(e=0;e<j;e++)this.children[e].update(this.skinMatrix,
c,d)};THREE.Bone.prototype.addChild=function(b){if(this.children.indexOf(b)===-1&&(b.parent!==void 0&&b.parent.removeChild(b),b.parent=this,this.children.push(b),!(b instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};
THREE.SkinnedMesh=function(b,c){THREE.Mesh.call(this,b,c);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var d,e,j,h,k,m;if(this.geometry.bones!==void 0){for(d=0;d<this.geometry.bones.length;d++)j=this.geometry.bones[d],h=j.pos,k=j.rotq,m=j.scl,e=this.addBone(),e.name=j.name,e.position.set(h[0],h[1],h[2]),e.quaternion.set(k[0],k[1],k[2],k[3]),e.useQuaternion=!0,m!==void 0?e.scale.set(m[0],m[1],m[2]):e.scale.set(1,1,1);for(d=0;d<this.bones.length;d++)j=this.geometry.bones[d],
e=this.bones[d],j.parent===-1?this.addChild(e):this.bones[j.parent].addChild(e);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(b,c,d){if(this.visible){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var e,j=this.children.length;for(e=0;e<j;e++)b=this.children[e],b instanceof THREE.Bone?b.update(this.identityMatrix,!1,d):b.update(this.matrixWorld,c,d);d=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(c=0;c<d;c++)ba[c].skinMatrix.flattenToArrayOffset(bm,
c*16)}};THREE.SkinnedMesh.prototype.addBone=function(b){b===void 0&&(b=new THREE.Bone(this));this.bones.push(b);return b};
THREE.SkinnedMesh.prototype.pose=function(){this.update(void 0,!0);for(var b,c=[],d=0;d<this.bones.length;d++)b=this.bones[d],c.push(THREE.Matrix4.makeInvert(b.skinMatrix)),b.skinMatrix.flattenToArrayOffset(this.boneMatrices,d*16);if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var e;for(b=0;b<this.geometry.skinIndices.length;b++){var d=this.geometry.vertices[b].position,j=this.geometry.skinIndices[b].x,h=this.geometry.skinIndices[b].y;e=new THREE.Vector3(d.x,
d.y,d.z);this.geometry.skinVerticesA.push(c[j].multiplyVector3(e));e=new THREE.Vector3(d.x,d.y,d.z);this.geometry.skinVerticesB.push(c[h].multiplyVector3(e));this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y!==1&&(d=(1-(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y))*0.5,this.geometry.skinWeights[b].x+=d,this.geometry.skinWeights[b].y+=d)}}};THREE.Ribbon=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c]};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(b,c){c===void 0&&(c=0);for(var c=Math.abs(c),d=0;d<this.LODs.length;d++)if(c<this.LODs[d].visibleAtDistance)break;this.LODs.splice(d,0,{visibleAtDistance:c,object3D:b});this.addChild(b)};
THREE.LOD.prototype.update=function(b,c,d){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;if(this.LODs.length>1){b=d.matrixWorldInverse;b=-(b.n31*this.position.x+b.n32*this.position.y+b.n33*this.position.z+b.n34);this.LODs[0].object3D.visible=!0;for(var e=1;e<this.LODs.length;e++)if(b>=this.LODs[e].visibleAtDistance)this.LODs[e-1].object3D.visible=!1,
this.LODs[e].object3D.visible=!0;else break;for(;e<this.LODs.length;e++)this.LODs[e].object3D.visible=!1}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,d)};
THREE.Sprite=function(b){THREE.Object3D.call(this);if(b.material!==void 0)this.material=b.material,this.map=void 0,this.blending=material.blending;else if(b.map!==void 0)this.map=b.map instanceof THREE.Texture?b.map:THREE.ImageUtils.loadTexture(b.map),this.material=void 0,this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.useScreenCoordinates=b.useScreenCoordinates!==void 0?b.useScreenCoordinates:!0;this.mergeWith3D=b.mergeWith3D!==void 0?b.mergeWith3D:!this.useScreenCoordinates;
this.affectedByDistance=b.affectedByDistance!==void 0?b.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=b.scaleByViewport!==void 0?b.scaleByViewport:!this.affectedByDistance;this.alignment=b.alignment instanceof THREE.Vector2?b.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.supr=THREE.Object3D.prototype;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);
THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(b){this.supr.addChild.call(this,b);this.addChildRecurse(b)};
THREE.Scene.prototype.addChildRecurse=function(b){if(b instanceof THREE.Light)this.lights.indexOf(b)===-1&&this.lights.push(b);else if(!(b instanceof THREE.Camera||b instanceof THREE.Bone)&&this.objects.indexOf(b)===-1)this.objects.push(b),this.__objectsAdded.push(b);for(var c=0;c<b.children.length;c++)this.addChildRecurse(b.children[c])};THREE.Scene.prototype.removeChild=function(b){this.supr.removeChild.call(this,b);this.removeChildRecurse(b)};
THREE.Scene.prototype.removeChildRecurse=function(b){if(b instanceof THREE.Light){var c=this.lights.indexOf(b);c!==-1&&this.lights.splice(c,1)}else b instanceof THREE.Camera||(c=this.objects.indexOf(b),c!==-1&&(this.objects.splice(c,1),this.__objectsRemoved.push(b)));for(c=0;c<b.children.length;c++)this.removeChildRecurse(b.children[c])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;
THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(b,c,d){this.color=new THREE.Color(b);this.near=c||1;this.far=d||1E3};THREE.FogExp2=function(b,c){this.color=new THREE.Color(b);this.density=c!==void 0?c:2.5E-4};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",
envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",
envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",
map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",
lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef PHONG\nvPointLight[ i ] = vec4( lVector, lDistance );\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 pointSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight * pointDistance;\npointSpecular += mSpecular * pointSpecularWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 dirSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform float shadowDarkness;\nuniform float shadowBias;\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",
shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_SOFT\nconst float xPixelOffset = 1.0 / SHADOWMAP_WIDTH;\nconst float yPixelOffset = 1.0 / SHADOWMAP_HEIGHT;\n#endif\nvec4 shadowColor = vec4( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nif ( shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0 ) {\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nfor ( float y = -1.25; y <= 1.25; y += 1.25 )\nfor ( float x = -1.25; x <= 1.25; x += 1.25 ) {\nvec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadow += 1.0;\n}\nshadow /= 9.0;\nshadowColor = shadowColor * vec4( vec3( ( 1.0 - shadowDarkness * shadow ) ), 1.0 );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadowColor = shadowColor * vec4( vec3( shadowDarkness ), 1.0 );\n#endif\n}\n}\ngl_FragColor = gl_FragColor * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif"};
THREE.UniformsUtils={merge:function(b){var c,d,e,j={};for(c=0;c<b.length;c++)for(d in e=this.clone(b[c]),e)j[d]=e[d];return j},clone:function(b){var c,d,e,j={};for(c in b)for(d in j[c]={},b[c])e=b[c][d],j[c][d]=e instanceof THREE.Color||e instanceof THREE.Vector2||e instanceof THREE.Vector3||e instanceof THREE.Vector4||e instanceof THREE.Matrix4||e instanceof THREE.Texture?e.clone():e instanceof Array?e.slice():e;return j}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",
value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:3,texture:[]},shadowMatrix:{type:"m4v",value:[]},shadowBias:{type:"f",value:0.0039},shadowDarkness:{type:"f",value:0.2}}};
THREE.ShaderLib={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * vVisibility;\ngl_FragColor = color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * visibility;\ngl_FragColor = color;\n}\n}"},
sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity;\ngl_FragColor = color;\n}"},shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main() {\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform \tfloat \tdarkness;\nvoid main() {\ngl_FragColor = vec4( 0, 0, 0, darkness );\n}"},
shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm ) ), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0 );\n}"},depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},
normal:{uniforms:{opacity:{type:"f",value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"gl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,
"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},
specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,
THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},depthRGBA:{uniforms:{},fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}",vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,
"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")}};
THREE.WebGLRenderer=function(b){function c(b,c,d){var e,j,h,k=b.vertices,m=k.length,G=b.colors,H=G.length,D=b.__vertexArray,p=b.__colorArray,q=b.__sortArray,n=b.__dirtyVertices,s=b.__dirtyColors,r=b.__webglCustomAttributes,v,u;if(r)for(v in r)r[v].offset=0;if(d.sortParticles){sa.multiplySelf(d.matrixWorld);for(e=0;e<m;e++)j=k[e].position,Ka.copy(j),sa.multiplyVector3(Ka),q[e]=[Ka.z,e];q.sort(function(b,c){return c[0]-b[0]});for(e=0;e<m;e++)j=k[q[e][1]].position,h=e*3,D[h]=j.x,D[h+1]=j.y,D[h+2]=j.z;
for(e=0;e<H;e++)h=e*3,color=G[q[e][1]],p[h]=color.r,p[h+1]=color.g,p[h+2]=color.b;if(r)for(v in r){e=r[v];G=e.value.length;for(h=0;h<G;h++){index=q[h][1];H=e.offset;if(e.size===1){if(e.boundTo===void 0||e.boundTo==="vertices")e.array[H]=e.value[index]}else{if(e.boundTo===void 0||e.boundTo==="vertices")u=e.value[index];e.size===2?(e.array[H]=u.x,e.array[H+1]=u.y):e.size===3?e.type==="c"?(e.array[H]=u.r,e.array[H+1]=u.g,e.array[H+2]=u.b):(e.array[H]=u.x,e.array[H+1]=u.y,e.array[H+2]=u.z):(e.array[H]=
u.x,e.array[H+1]=u.y,e.array[H+2]=u.z,e.array[H+3]=u.w)}e.offset+=e.size}}}else{if(n)for(e=0;e<m;e++)j=k[e].position,h=e*3,D[h]=j.x,D[h+1]=j.y,D[h+2]=j.z;if(s)for(e=0;e<H;e++)color=G[e],h=e*3,p[h]=color.r,p[h+1]=color.g,p[h+2]=color.b;if(r)for(v in r)if(e=r[v],e.__original.needsUpdate){G=e.value.length;for(h=0;h<G;h++){H=e.offset;if(e.size===1){if(e.boundTo===void 0||e.boundTo==="vertices")e.array[H]=e.value[h]}else{if(e.boundTo===void 0||e.boundTo==="vertices")u=e.value[h];e.size===2?(e.array[H]=
u.x,e.array[H+1]=u.y):e.size===3?e.type==="c"?(e.array[H]=u.r,e.array[H+1]=u.g,e.array[H+2]=u.b):(e.array[H]=u.x,e.array[H+1]=u.y,e.array[H+2]=u.z):(e.array[H]=u.x,e.array[H+1]=u.y,e.array[H+2]=u.z,e.array[H+3]=u.w)}e.offset+=e.size}}}if(n||d.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,b.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,D,c);if(s||d.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,b.__webglColorBuffer),f.bufferData(f.ARRAY_BUFFER,p,c);if(r)for(v in r)if(e=r[v],e.__original.needsUpdate||d.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,
e.buffer),f.bufferData(f.ARRAY_BUFFER,e.array,c)}function d(b,c,d,e,j){e.program||I.initMaterial(e,c,d,j);if(e.morphTargets&&!j.__webglMorphTargetInfluences){j.__webglMorphTargetInfluences=new Float32Array(I.maxMorphTargets);for(var h=0,k=I.maxMorphTargets;h<k;h++)j.__webglMorphTargetInfluences[h]=0}var h=e.program,k=h.uniforms,m=e.uniforms;h!=Fa&&(f.useProgram(h),Fa=h);f.uniformMatrix4fv(k.projectionMatrix,!1,Aa);if(d&&(e instanceof THREE.MeshBasicMaterial||e instanceof THREE.MeshLambertMaterial||
e instanceof THREE.MeshPhongMaterial||e instanceof THREE.LineBasicMaterial||e instanceof THREE.ParticleBasicMaterial||e.fog))if(m.fogColor.value=d.color,d instanceof THREE.Fog)m.fogNear.value=d.near,m.fogFar.value=d.far;else if(d instanceof THREE.FogExp2)m.fogDensity.value=d.density;if(e instanceof THREE.MeshPhongMaterial||e instanceof THREE.MeshLambertMaterial||e.lights){var G,p,D,q=0,n=0,s=0,r,v,w,B=Ta,F=B.directional.colors,K=B.directional.positions,y=B.point.colors,A=B.point.positions,L=B.point.distances,
E=0,C=0,d=p=w=0;for(G=c.length;d<G;d++)if(p=c[d],D=p.color,r=p.position,v=p.intensity,w=p.distance,p instanceof THREE.AmbientLight)q+=D.r,n+=D.g,s+=D.b;else if(p instanceof THREE.DirectionalLight)w=E*3,F[w]=D.r*v,F[w+1]=D.g*v,F[w+2]=D.b*v,K[w]=r.x,K[w+1]=r.y,K[w+2]=r.z,E+=1;else if(p instanceof THREE.SpotLight)w=E*3,F[w]=D.r*v,F[w+1]=D.g*v,F[w+2]=D.b*v,D=1/r.length(),K[w]=r.x*D,K[w+1]=r.y*D,K[w+2]=r.z*D,E+=1;else if(p instanceof THREE.PointLight)p=C*3,y[p]=D.r*v,y[p+1]=D.g*v,y[p+2]=D.b*v,A[p]=r.x,
A[p+1]=r.y,A[p+2]=r.z,L[C]=w,C+=1;for(d=E*3;d<F.length;d++)F[d]=0;for(d=C*3;d<y.length;d++)y[d]=0;B.point.length=C;B.directional.length=E;B.ambient[0]=q;B.ambient[1]=n;B.ambient[2]=s;c=Ta;m.enableLighting.value=c.directional.length+c.point.length;m.ambientLightColor.value=c.ambient;m.directionalLightColor.value=c.directional.colors;m.directionalLightDirection.value=c.directional.positions;m.pointLightColor.value=c.point.colors;m.pointLightPosition.value=c.point.positions;m.pointLightDistance.value=
c.point.distances}if(e instanceof THREE.MeshBasicMaterial||e instanceof THREE.MeshLambertMaterial||e instanceof THREE.MeshPhongMaterial)m.diffuse.value=e.color,m.opacity.value=e.opacity,(m.map.texture=e.map)&&m.offsetRepeat.value.set(e.map.offset.x,e.map.offset.y,e.map.repeat.x,e.map.repeat.y),m.lightMap.texture=e.lightMap,m.envMap.texture=e.envMap,m.reflectivity.value=e.reflectivity,m.refractionRatio.value=e.refractionRatio,m.combine.value=e.combine,m.useRefract.value=e.envMap&&e.envMap.mapping instanceof
THREE.CubeRefractionMapping;if(e instanceof THREE.LineBasicMaterial)m.diffuse.value=e.color,m.opacity.value=e.opacity;else if(e instanceof THREE.ParticleBasicMaterial)m.psColor.value=e.color,m.opacity.value=e.opacity,m.size.value=e.size,m.scale.value=Ga.height/2,m.map.texture=e.map;else if(e instanceof THREE.MeshPhongMaterial)m.ambient.value=e.ambient,m.specular.value=e.specular,m.shininess.value=e.shininess;else if(e instanceof THREE.MeshDepthMaterial)m.mNear.value=b.near,m.mFar.value=b.far,m.opacity.value=
e.opacity;else if(e instanceof THREE.MeshNormalMaterial)m.opacity.value=e.opacity;if(j.receiveShadow&&!e._shadowPass&&m.shadowMatrix){for(c=0;c<La.length;c++)m.shadowMatrix.value[c]=La[c],m.shadowMap.texture[c]=I.shadowMap[c];m.shadowDarkness.value=I.shadowMapDarkness;m.shadowBias.value=I.shadowMapBias}for(var O in m)if(G=h.uniforms[O])if(d=m[O],q=d.type,c=d.value,q=="i")f.uniform1i(G,c);else if(q=="f")f.uniform1f(G,c);else if(q=="v2")f.uniform2f(G,c.x,c.y);else if(q=="v3")f.uniform3f(G,c.x,c.y,c.z);
else if(q=="v4")f.uniform4f(G,c.x,c.y,c.z,c.w);else if(q=="c")f.uniform3f(G,c.r,c.g,c.b);else if(q=="fv1")f.uniform1fv(G,c);else if(q=="fv")f.uniform3fv(G,c);else if(q=="v3v"){if(!d._array)d._array=new Float32Array(3*c.length);q=0;for(n=c.length;q<n;q++)s=q*3,d._array[s]=c[q].x,d._array[s+1]=c[q].y,d._array[s+2]=c[q].z;f.uniform3fv(G,d._array)}else if(q=="m4"){if(!d._array)d._array=new Float32Array(16);c.flattenToArray(d._array);f.uniformMatrix4fv(G,!1,d._array)}else if(q=="m4v"){if(!d._array)d._array=
new Float32Array(16*c.length);q=0;for(n=c.length;q<n;q++)c[q].flattenToArrayOffset(d._array,q*16);f.uniformMatrix4fv(G,!1,d._array)}else if(q=="t"){if(f.uniform1i(G,c),G=d.texture)if(G.image instanceof Array&&G.image.length==6){if(d=G,d.image.length==6)if(d.needsUpdate){if(!d.image.__webglTextureCube)d.image.__webglTextureCube=f.createTexture();f.activeTexture(f.TEXTURE0+c);f.bindTexture(f.TEXTURE_CUBE_MAP,d.image.__webglTextureCube);for(c=0;c<6;c++)f.texImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+c,0,
f.RGBA,f.RGBA,f.UNSIGNED_BYTE,d.image[c]);N(f.TEXTURE_CUBE_MAP,d,d.image[0]);d.needsUpdate=!1}else f.activeTexture(f.TEXTURE0+c),f.bindTexture(f.TEXTURE_CUBE_MAP,d.image.__webglTextureCube)}else G instanceof THREE.WebGLRenderTargetCube?(d=G,f.activeTexture(f.TEXTURE0+c),f.bindTexture(f.TEXTURE_CUBE_MAP,d.__webglTexture)):u(G,c)}else if(q=="tv"){if(!d._array){d._array=[];q=0;for(n=d.texture.length;q<n;q++)d._array[q]=c+q}f.uniform1iv(G,d._array);q=0;for(n=d.texture.length;q<n;q++)(G=d.texture[q])&&
u(G,d._array[q])}f.uniformMatrix4fv(k.modelViewMatrix,!1,j._modelViewMatrixArray);k.normalMatrix&&f.uniformMatrix3fv(k.normalMatrix,!1,j._normalMatrixArray);(e instanceof THREE.MeshShaderMaterial||e instanceof THREE.MeshPhongMaterial||e.envMap)&&k.cameraPosition!==null&&f.uniform3f(k.cameraPosition,b.position.x,b.position.y,b.position.z);(e instanceof THREE.MeshShaderMaterial||e.envMap||e.skinning||j.receiveShadow)&&k.objectMatrix!==null&&f.uniformMatrix4fv(k.objectMatrix,!1,j._objectMatrixArray);
(e instanceof THREE.MeshPhongMaterial||e instanceof THREE.MeshLambertMaterial||e instanceof THREE.MeshShaderMaterial||e.skinning)&&k.viewMatrix!==null&&f.uniformMatrix4fv(k.viewMatrix,!1,Ca);e.skinning&&(f.uniformMatrix4fv(k.cameraInverseMatrix,!1,Ca),f.uniformMatrix4fv(k.boneGlobalMatrices,!1,j.boneMatrices));return h}function e(b,c,e,j,h,k){if(j.opacity!=0){var m,b=d(b,c,e,j,k).attributes;if(!j.morphTargets&&b.position>=0)f.bindBuffer(f.ARRAY_BUFFER,h.__webglVertexBuffer),f.vertexAttribPointer(b.position,
3,f.FLOAT,!1,0,0);else if(k.morphTargetBase){c=j.program.attributes;k.morphTargetBase!==-1?(f.bindBuffer(f.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[k.morphTargetBase]),f.vertexAttribPointer(c.position,3,f.FLOAT,!1,0,0)):c.position>=0&&(f.bindBuffer(f.ARRAY_BUFFER,h.__webglVertexBuffer),f.vertexAttribPointer(c.position,3,f.FLOAT,!1,0,0));if(k.morphTargetForcedOrder.length)for(var e=0,p=k.morphTargetForcedOrder,G=k.morphTargetInfluences;e<j.numSupportedMorphTargets&&e<p.length;)f.bindBuffer(f.ARRAY_BUFFER,
h.__webglMorphTargetsBuffers[p[e]]),f.vertexAttribPointer(c["morphTarget"+e],3,f.FLOAT,!1,0,0),k.__webglMorphTargetInfluences[e]=G[p[e]],e++;else{var p=[],q=-1,D=0,G=k.morphTargetInfluences,n,r=G.length,e=0;for(k.morphTargetBase!==-1&&(p[k.morphTargetBase]=!0);e<j.numSupportedMorphTargets;){for(n=0;n<r;n++)!p[n]&&G[n]>q&&(D=n,q=G[D]);f.bindBuffer(f.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[D]);f.vertexAttribPointer(c["morphTarget"+e],3,f.FLOAT,!1,0,0);k.__webglMorphTargetInfluences[e]=q;p[D]=1;q=
-1;e++}}j.program.uniforms.morphTargetInfluences!==null&&f.uniform1fv(j.program.uniforms.morphTargetInfluences,k.__webglMorphTargetInfluences)}if(h.__webglCustomAttributes)for(m in h.__webglCustomAttributes)b[m]>=0&&(c=h.__webglCustomAttributes[m],f.bindBuffer(f.ARRAY_BUFFER,c.buffer),f.vertexAttribPointer(b[m],c.size,f.FLOAT,!1,0,0));b.color>=0&&(f.bindBuffer(f.ARRAY_BUFFER,h.__webglColorBuffer),f.vertexAttribPointer(b.color,3,f.FLOAT,!1,0,0));b.normal>=0&&(f.bindBuffer(f.ARRAY_BUFFER,h.__webglNormalBuffer),
f.vertexAttribPointer(b.normal,3,f.FLOAT,!1,0,0));b.tangent>=0&&(f.bindBuffer(f.ARRAY_BUFFER,h.__webglTangentBuffer),f.vertexAttribPointer(b.tangent,4,f.FLOAT,!1,0,0));b.uv>=0&&(h.__webglUVBuffer?(f.bindBuffer(f.ARRAY_BUFFER,h.__webglUVBuffer),f.vertexAttribPointer(b.uv,2,f.FLOAT,!1,0,0),f.enableVertexAttribArray(b.uv)):f.disableVertexAttribArray(b.uv));b.uv2>=0&&(h.__webglUV2Buffer?(f.bindBuffer(f.ARRAY_BUFFER,h.__webglUV2Buffer),f.vertexAttribPointer(b.uv2,2,f.FLOAT,!1,0,0),f.enableVertexAttribArray(b.uv2)):
f.disableVertexAttribArray(b.uv2));j.skinning&&b.skinVertexA>=0&&b.skinVertexB>=0&&b.skinIndex>=0&&b.skinWeight>=0&&(f.bindBuffer(f.ARRAY_BUFFER,h.__webglSkinVertexABuffer),f.vertexAttribPointer(b.skinVertexA,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,h.__webglSkinVertexBBuffer),f.vertexAttribPointer(b.skinVertexB,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,h.__webglSkinIndicesBuffer),f.vertexAttribPointer(b.skinIndex,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,h.__webglSkinWeightsBuffer),
f.vertexAttribPointer(b.skinWeight,4,f.FLOAT,!1,0,0));k instanceof THREE.Mesh?(j.wireframe?(f.lineWidth(j.wireframeLinewidth),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,h.__webglLineBuffer),f.drawElements(f.LINES,h.__webglLineCount,f.UNSIGNED_SHORT,0)):(f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,h.__webglFaceBuffer),f.drawElements(f.TRIANGLES,h.__webglFaceCount,f.UNSIGNED_SHORT,0)),I.data.vertices+=h.__webglFaceCount,I.data.faces+=h.__webglFaceCount/3,I.data.drawCalls++):k instanceof THREE.Line?(k=k.type==THREE.LineStrip?
f.LINE_STRIP:f.LINES,f.lineWidth(j.linewidth),f.drawArrays(k,0,h.__webglLineCount),I.data.drawCalls++):k instanceof THREE.ParticleSystem?(f.drawArrays(f.POINTS,0,h.__webglParticleCount),I.data.drawCalls++):k instanceof THREE.Ribbon&&(f.drawArrays(f.TRIANGLE_STRIP,0,h.__webglVertexCount),I.data.drawCalls++)}}function j(b,c,d){if(!b.__webglVertexBuffer)b.__webglVertexBuffer=f.createBuffer();if(!b.__webglNormalBuffer)b.__webglNormalBuffer=f.createBuffer();b.hasPos&&(f.bindBuffer(f.ARRAY_BUFFER,b.__webglVertexBuffer),
f.bufferData(f.ARRAY_BUFFER,b.positionArray,f.DYNAMIC_DRAW),f.enableVertexAttribArray(c.attributes.position),f.vertexAttribPointer(c.attributes.position,3,f.FLOAT,!1,0,0));if(b.hasNormal){f.bindBuffer(f.ARRAY_BUFFER,b.__webglNormalBuffer);if(d==THREE.FlatShading){var e,h,j,k,m,G,p,q,n,r,s=b.count*3;for(r=0;r<s;r+=9)d=b.normalArray,e=d[r],h=d[r+1],j=d[r+2],k=d[r+3],G=d[r+4],q=d[r+5],m=d[r+6],p=d[r+7],n=d[r+8],e=(e+k+m)/3,h=(h+G+p)/3,j=(j+q+n)/3,d[r]=e,d[r+1]=h,d[r+2]=j,d[r+3]=e,d[r+4]=h,d[r+5]=j,d[r+
6]=e,d[r+7]=h,d[r+8]=j}f.bufferData(f.ARRAY_BUFFER,b.normalArray,f.DYNAMIC_DRAW);f.enableVertexAttribArray(c.attributes.normal);f.vertexAttribPointer(c.attributes.normal,3,f.FLOAT,!1,0,0)}f.drawArrays(f.TRIANGLES,0,b.count);b.count=0}function h(b){if(W!=b.doubleSided)b.doubleSided?f.disable(f.CULL_FACE):f.enable(f.CULL_FACE),W=b.doubleSided;if($!=b.flipSided)b.flipSided?f.frontFace(f.CW):f.frontFace(f.CCW),$=b.flipSided}function k(b){X!=b&&(b?f.enable(f.DEPTH_TEST):f.disable(f.DEPTH_TEST),X=b)}function m(b,
c,d){P!=b&&(b?f.enable(f.POLYGON_OFFSET_FILL):f.disable(f.POLYGON_OFFSET_FILL),P=b);if(b&&(la!=c||ga!=d))f.polygonOffset(c,d),la=c,ga=d}function q(b){ia[0].set(b.n41-b.n11,b.n42-b.n12,b.n43-b.n13,b.n44-b.n14);ia[1].set(b.n41+b.n11,b.n42+b.n12,b.n43+b.n13,b.n44+b.n14);ia[2].set(b.n41+b.n21,b.n42+b.n22,b.n43+b.n23,b.n44+b.n24);ia[3].set(b.n41-b.n21,b.n42-b.n22,b.n43-b.n23,b.n44-b.n24);ia[4].set(b.n41-b.n31,b.n42-b.n32,b.n43-b.n33,b.n44-b.n34);ia[5].set(b.n41+b.n31,b.n42+b.n32,b.n43+b.n33,b.n44+b.n34);
for(var c,b=0;b<6;b++)c=ia[b],c.divideScalar(Math.sqrt(c.x*c.x+c.y*c.y+c.z*c.z))}function p(b){for(var c=b.matrixWorld,f=-b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)),d=0;d<6;d++)if(b=ia[d].x*c.n14+ia[d].y*c.n24+ia[d].z*c.n34+ia[d].w,b<=f)return!1;return!0}function n(b,c){b.list[b.count]=c;b.count+=1}function s(b){var c,d,f=b.object,e=b.opaque,h=b.transparent;h.count=0;b=e.count=0;for(c=f.materials.length;b<c;b++)d=f.materials[b],d.transparent?n(h,d):n(e,d)}function r(b){var c,
d,f,e,h=b.object,j=b.buffer,k=b.opaque,m=b.transparent;m.count=0;b=k.count=0;for(f=h.materials.length;b<f;b++)if(c=h.materials[b],c instanceof THREE.MeshFaceMaterial){c=0;for(d=j.materials.length;c<d;c++)(e=j.materials[c])&&(e.transparent?n(m,e):n(k,e))}else(e=c)&&(e.transparent?n(m,e):n(k,e))}function v(b,c){return c.z-b.z}function B(b,c){var m,Sa,J,r=0,n,s,G,H,D=b.lights;oa||(oa=new THREE.Camera(I.shadowCameraFov,c.aspect,I.shadowCameraNear,I.shadowCameraFar));m=0;for(Sa=D.length;m<Sa;m++)if(J=
D[m],J instanceof THREE.SpotLight&&J.castShadow){I.shadowMap[r]||(I.shadowMap[r]=new THREE.WebGLRenderTarget(I.shadowMapWidth,I.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat}));La[r]||(La[r]=new THREE.Matrix4);n=I.shadowMap[r];s=La[r];oa.position.copy(J.position);oa.target.position.copy(J.target.position);oa.update(void 0,!0);b.update(void 0,!1,oa);s.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);s.multiplySelf(oa.projectionMatrix);s.multiplySelf(oa.matrixWorldInverse);
oa.matrixWorldInverse.flattenToArray(Ca);oa.projectionMatrix.flattenToArray(Aa);sa.multiply(oa.projectionMatrix,oa.matrixWorldInverse);q(sa);I.initWebGLObjects(b);U(n);f.clearColor(1,1,1,1);I.clear();f.clearColor(wa.r,wa.g,wa.b,Ia);s=b.__webglObjects.length;J=b.__webglObjectsImmediate.length;for(n=0;n<s;n++)G=b.__webglObjects[n],H=G.object,H.visible&&H.castShadow?!(H instanceof THREE.Mesh)||!H.frustumCulled||p(H)?(H.matrixWorld.flattenToArray(H._objectMatrixArray),E(H,oa,!1),G.render=!0):G.render=
!1:G.render=!1;k(!0);R(THREE.NormalBlending);for(n=0;n<s;n++)if(G=b.__webglObjects[n],G.render)H=G.object,buffer=G.buffer,h(H),G=H.customDepthMaterial?H.customDepthMaterial:H.geometry.morphTargets.length?Ua:Qa,e(oa,D,null,G,buffer,H);for(n=0;n<J;n++)G=b.__webglObjectsImmediate[n],H=G.object,H.visible&&H.castShadow&&(H.matrixAutoUpdate&&H.matrixWorld.flattenToArray(H._objectMatrixArray),E(H,oa,!1),h(H),program=d(oa,D,null,Qa,H),H.render(function(b){j(b,program,Qa.shading)}));r++}}function y(b,c){var d,
e,h;d=w.attributes;var j=w.uniforms,k=Ea/Da,m,p=[],q=Da*0.5,n=Ea*0.5,r=!0;f.useProgram(w.program);Fa=w.program;X=C=-1;Va||(f.enableVertexAttribArray(w.attributes.position),f.enableVertexAttribArray(w.attributes.uv),Va=!0);f.disable(f.CULL_FACE);f.enable(f.BLEND);f.depthMask(!0);f.bindBuffer(f.ARRAY_BUFFER,w.vertexBuffer);f.vertexAttribPointer(d.position,2,f.FLOAT,!1,16,0);f.vertexAttribPointer(d.uv,2,f.FLOAT,!1,16,8);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,w.elementBuffer);f.uniformMatrix4fv(j.projectionMatrix,
!1,Aa);f.activeTexture(f.TEXTURE0);f.uniform1i(j.map,0);d=0;for(e=b.__webglSprites.length;d<e;d++)h=b.__webglSprites[d],h.useScreenCoordinates?h.z=-h.position.z:(h._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,h.matrixWorld,h._modelViewMatrixArray),h.z=-h._modelViewMatrix.n34);b.__webglSprites.sort(v);d=0;for(e=b.__webglSprites.length;d<e;d++)h=b.__webglSprites[d],h.material===void 0&&h.map&&h.map.image&&h.map.image.width&&(h.useScreenCoordinates?(f.uniform1i(j.useScreenCoordinates,1),f.uniform3f(j.screenPosition,
(h.position.x-q)/q,(n-h.position.y)/n,Math.max(0,Math.min(1,h.position.z)))):(f.uniform1i(j.useScreenCoordinates,0),f.uniform1i(j.affectedByDistance,h.affectedByDistance?1:0),f.uniformMatrix4fv(j.modelViewMatrix,!1,h._modelViewMatrixArray)),m=h.map.image.width/(h.scaleByViewport?Ea:1),p[0]=m*k*h.scale.x,p[1]=m*h.scale.y,f.uniform2f(j.uvScale,h.uvScale.x,h.uvScale.y),f.uniform2f(j.uvOffset,h.uvOffset.x,h.uvOffset.y),f.uniform2f(j.alignment,h.alignment.x,h.alignment.y),f.uniform1f(j.opacity,h.opacity),
f.uniform1f(j.rotation,h.rotation),f.uniform2fv(j.scale,p),h.mergeWith3D&&!r?(f.enable(f.DEPTH_TEST),r=!0):!h.mergeWith3D&&r&&(f.disable(f.DEPTH_TEST),r=!1),R(h.blending),u(h.map,0),f.drawElements(f.TRIANGLES,6,f.UNSIGNED_SHORT,0));f.enable(f.CULL_FACE);f.enable(f.DEPTH_TEST);f.depthMask(va)}function E(b,c,d){b._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,b.matrixWorld,b._modelViewMatrixArray);d&&THREE.Matrix4.makeInvert3x3(b._modelViewMatrix).transposeIntoArray(b._normalMatrixArray)}function L(b){var c,
d,f,e;e=b.__materials;b=0;for(d=e.length;b<d;b++)if(f=e[b],f.attributes)for(c in f.attributes)if(f.attributes[c].needsUpdate)return!0;return!1}function xa(b){var c,d,f,e;e=b.__materials;b=0;for(d=e.length;b<d;b++)if(f=e[b],f.attributes)for(c in f.attributes)f.attributes[c].needsUpdate=!1}function ya(b,c){var d;for(d=b.length-1;d>=0;d--)b[d].object==c&&b.splice(d,1)}function ra(b){function c(b){var e=[];d=0;for(f=b.length;d<f;d++)b[d]==void 0?e.push("undefined"):e.push(b[d].id);return e.join("_")}
var d,f,e,h,j,k,m,p,q={},n=b.morphTargets!==void 0?b.morphTargets.length:0;b.geometryGroups={};e=0;for(h=b.faces.length;e<h;e++)j=b.faces[e],k=j.materials,m=c(k),q[m]==void 0&&(q[m]={hash:m,counter:0}),p=q[m].hash+"_"+q[m].counter,b.geometryGroups[p]==void 0&&(b.geometryGroups[p]={faces:[],materials:k,vertices:0,numMorphTargets:n}),j=j instanceof THREE.Face3?3:4,b.geometryGroups[p].vertices+j>65535&&(q[m].counter+=1,p=q[m].hash+"_"+q[m].counter,b.geometryGroups[p]==void 0&&(b.geometryGroups[p]={faces:[],
materials:k,vertices:0,numMorphTargets:n})),b.geometryGroups[p].faces.push(e),b.geometryGroups[p].vertices+=j;b.geometryGroupsList=[];for(var r in b.geometryGroups)b.geometryGroupsList.push(b.geometryGroups[r])}function na(b,c,d){b.push({buffer:c,object:d,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function R(b){if(b!=C){switch(b){case THREE.AdditiveBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.SRC_ALPHA,f.ONE);break;case THREE.SubtractiveBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ZERO,
f.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ZERO,f.SRC_COLOR);break;default:f.blendEquationSeparate(f.FUNC_ADD,f.FUNC_ADD),f.blendFuncSeparate(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA,f.ONE,f.ONE_MINUS_SRC_ALPHA)}C=b}}function N(b,c,d){(d.width&d.width-1)==0&&(d.height&d.height-1)==0?(f.texParameteri(b,f.TEXTURE_WRAP_S,V(c.wrapS)),f.texParameteri(b,f.TEXTURE_WRAP_T,V(c.wrapT)),f.texParameteri(b,f.TEXTURE_MAG_FILTER,V(c.magFilter)),f.texParameteri(b,
f.TEXTURE_MIN_FILTER,V(c.minFilter)),f.generateMipmap(b)):(f.texParameteri(b,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(b,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE),f.texParameteri(b,f.TEXTURE_MAG_FILTER,T(c.magFilter)),f.texParameteri(b,f.TEXTURE_MIN_FILTER,T(c.minFilter)))}function u(b,c){if(b.needsUpdate){if(!b.__webglInit)b.__webglInit=!0,b.__webglTexture=f.createTexture();f.activeTexture(f.TEXTURE0+c);f.bindTexture(f.TEXTURE_2D,b.__webglTexture);b instanceof THREE.DataTexture?f.texImage2D(f.TEXTURE_2D,
0,V(b.format),b.image.width,b.image.height,0,V(b.format),f.UNSIGNED_BYTE,b.image.data):f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,b.image);N(f.TEXTURE_2D,b,b.image);b.needsUpdate=!1}else f.activeTexture(f.TEXTURE0+c),f.bindTexture(f.TEXTURE_2D,b.__webglTexture)}function U(b){var c=b instanceof THREE.WebGLRenderTargetCube;if(b&&!b.__webglFramebuffer){if(b.depthBuffer===void 0)b.depthBuffer=!0;if(b.stencilBuffer===void 0)b.stencilBuffer=!0;b.__webglRenderbuffer=f.createRenderbuffer();
b.__webglTexture=f.createTexture();if(c){f.bindTexture(f.TEXTURE_CUBE_MAP,b.__webglTexture);N(f.TEXTURE_CUBE_MAP,b,b);b.__webglFramebuffer=[];for(var d=0;d<6;d++)b.__webglFramebuffer[d]=f.createFramebuffer(),f.texImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+d,0,V(b.format),b.width,b.height,0,V(b.format),V(b.type),null)}else b.__webglFramebuffer=f.createFramebuffer(),f.bindTexture(f.TEXTURE_2D,b.__webglTexture),N(f.TEXTURE_2D,b,b),f.texImage2D(f.TEXTURE_2D,0,V(b.format),b.width,b.height,0,V(b.format),V(b.type),
null);f.bindRenderbuffer(f.RENDERBUFFER,b.__webglRenderbuffer);if(c)for(d=0;d<6;++d)f.bindFramebuffer(f.FRAMEBUFFER,b.__webglFramebuffer[d]),f.framebufferTexture2D(f.FRAMEBUFFER,f.COLOR_ATTACHMENT0,f.TEXTURE_CUBE_MAP_POSITIVE_X+d,b.__webglTexture,0);else f.bindFramebuffer(f.FRAMEBUFFER,b.__webglFramebuffer),f.framebufferTexture2D(f.FRAMEBUFFER,f.COLOR_ATTACHMENT0,f.TEXTURE_2D,b.__webglTexture,0);b.depthBuffer&&!b.stencilBuffer?(f.renderbufferStorage(f.RENDERBUFFER,f.DEPTH_COMPONENT16,b.width,b.height),
f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_ATTACHMENT,f.RENDERBUFFER,b.__webglRenderbuffer)):b.depthBuffer&&b.stencilBuffer?(f.renderbufferStorage(f.RENDERBUFFER,f.DEPTH_STENCIL,b.width,b.height),f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_STENCIL_ATTACHMENT,f.RENDERBUFFER,b.__webglRenderbuffer)):f.renderbufferStorage(f.RENDERBUFFER,f.RGBA4,b.width,b.height);c?f.bindTexture(f.TEXTURE_CUBE_MAP,null):f.bindTexture(f.TEXTURE_2D,null);f.bindRenderbuffer(f.RENDERBUFFER,null);f.bindFramebuffer(f.FRAMEBUFFER,
null)}var e,h;b?(c=c?b.__webglFramebuffer[b.activeCubeFace]:b.__webglFramebuffer,d=b.width,b=b.height,h=e=0):(c=null,d=Da,b=Ea,e=M,h=za);c!=Ra&&(f.bindFramebuffer(f.FRAMEBUFFER,c),f.viewport(e,h,d,b),Ra=c)}function S(b){b instanceof THREE.WebGLRenderTargetCube?(f.bindTexture(f.TEXTURE_CUBE_MAP,b.__webglTexture),f.generateMipmap(f.TEXTURE_CUBE_MAP),f.bindTexture(f.TEXTURE_CUBE_MAP,null)):(f.bindTexture(f.TEXTURE_2D,b.__webglTexture),f.generateMipmap(f.TEXTURE_2D),f.bindTexture(f.TEXTURE_2D,null))}
function Z(b,c){var d;b=="fragment"?d=f.createShader(f.FRAGMENT_SHADER):b=="vertex"&&(d=f.createShader(f.VERTEX_SHADER));f.shaderSource(d,c);f.compileShader(d);if(!f.getShaderParameter(d,f.COMPILE_STATUS))return console.error(f.getShaderInfoLog(d)),console.error(c),null;return d}function T(b){switch(b){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return f.NEAREST;default:return f.LINEAR}}function V(b){switch(b){case THREE.RepeatWrapping:return f.REPEAT;
case THREE.ClampToEdgeWrapping:return f.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return f.MIRRORED_REPEAT;case THREE.NearestFilter:return f.NEAREST;case THREE.NearestMipMapNearestFilter:return f.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return f.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return f.LINEAR;case THREE.LinearMipMapNearestFilter:return f.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return f.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return f.BYTE;
case THREE.UnsignedByteType:return f.UNSIGNED_BYTE;case THREE.ShortType:return f.SHORT;case THREE.UnsignedShortType:return f.UNSIGNED_SHORT;case THREE.IntType:return f.INT;case THREE.UnsignedShortType:return f.UNSIGNED_INT;case THREE.FloatType:return f.FLOAT;case THREE.AlphaFormat:return f.ALPHA;case THREE.RGBFormat:return f.RGB;case THREE.RGBAFormat:return f.RGBA;case THREE.LuminanceFormat:return f.LUMINANCE;case THREE.LuminanceAlphaFormat:return f.LUMINANCE_ALPHA}return 0}var I=this,f,ua=[],Fa=
null,Ra=null,va=!0,W=null,$=null,C=null,X=null,P=null,la=null,ga=null,M=0,za=0,Da=0,Ea=0,ia=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],sa=new THREE.Matrix4,Aa=new Float32Array(16),Ca=new Float32Array(16),Ka=new THREE.Vector4,Ta={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}},b=b||{},Ga=b.canvas!==void 0?b.canvas:document.createElement("canvas"),Ya=b.stencil!==void 0?
b.stencil:!0,Za=b.preserveDrawingBuffer!==void 0?b.preserveDrawingBuffer:!1,$a=b.antialias!==void 0?b.antialias:!1,wa=b.clearColor!==void 0?new THREE.Color(b.clearColor):new THREE.Color(0),Ia=b.clearAlpha!==void 0?b.clearAlpha:0;_maxLights=b.maxLights!==void 0?b.maxLights:4;this.data={vertices:0,faces:0,drawCalls:0};this.maxMorphTargets=8;this.domElement=Ga;this.sortObjects=this.autoClear=!0;this.shadowMapBias=0.0039;this.shadowMapDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCameraNear=
1;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowMap=[];this.shadowMapEnabled=!1;this.shadowMapSoft=!0;var oa,La=[],b=THREE.ShaderLib.depthRGBA,Wa=THREE.UniformsUtils.clone(b.uniforms),Qa=new THREE.MeshShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,uniforms:Wa}),Ua=new THREE.MeshShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,uniforms:Wa,morphTargets:!0});Qa._shadowPass=!0;Ua._shadowPass=!0;try{if(!(f=Ga.getContext("experimental-webgl",
{antialias:$a,stencil:Ya,preserveDrawingBuffer:Za})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+f.getParameter(f.VERSION)+" | "+f.getParameter(f.VENDOR)+" | "+f.getParameter(f.RENDERER)+" | "+f.getParameter(f.SHADING_LANGUAGE_VERSION))}catch(ab){console.error(ab)}f.clearColor(0,0,0,1);f.clearDepth(1);f.clearStencil(0);f.enable(f.DEPTH_TEST);f.depthFunc(f.LEQUAL);f.frontFace(f.CCW);f.cullFace(f.BACK);f.enable(f.CULL_FACE);f.enable(f.BLEND);f.blendEquation(f.FUNC_ADD);
f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.clearColor(wa.r,wa.g,wa.b,Ia);this.context=f;var Xa=f.getParameter(f.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0,w={};w.vertices=new Float32Array(16);w.faces=new Uint16Array(6);i=0;w.vertices[i++]=-1;w.vertices[i++]=-1;w.vertices[i++]=0;w.vertices[i++]=1;w.vertices[i++]=1;w.vertices[i++]=-1;w.vertices[i++]=1;w.vertices[i++]=1;w.vertices[i++]=1;w.vertices[i++]=1;w.vertices[i++]=1;w.vertices[i++]=0;w.vertices[i++]=-1;w.vertices[i++]=1;w.vertices[i++]=0;i=w.vertices[i++]=
0;w.faces[i++]=0;w.faces[i++]=1;w.faces[i++]=2;w.faces[i++]=0;w.faces[i++]=2;w.faces[i++]=3;w.vertexBuffer=f.createBuffer();w.elementBuffer=f.createBuffer();f.bindBuffer(f.ARRAY_BUFFER,w.vertexBuffer);f.bufferData(f.ARRAY_BUFFER,w.vertices,f.STATIC_DRAW);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,w.elementBuffer);f.bufferData(f.ELEMENT_ARRAY_BUFFER,w.faces,f.STATIC_DRAW);w.program=f.createProgram();f.attachShader(w.program,Z("fragment",THREE.ShaderLib.sprite.fragmentShader));f.attachShader(w.program,Z("vertex",
THREE.ShaderLib.sprite.vertexShader));f.linkProgram(w.program);w.attributes={};w.uniforms={};w.attributes.position=f.getAttribLocation(w.program,"position");w.attributes.uv=f.getAttribLocation(w.program,"uv");w.uniforms.uvOffset=f.getUniformLocation(w.program,"uvOffset");w.uniforms.uvScale=f.getUniformLocation(w.program,"uvScale");w.uniforms.rotation=f.getUniformLocation(w.program,"rotation");w.uniforms.scale=f.getUniformLocation(w.program,"scale");w.uniforms.alignment=f.getUniformLocation(w.program,
"alignment");w.uniforms.map=f.getUniformLocation(w.program,"map");w.uniforms.opacity=f.getUniformLocation(w.program,"opacity");w.uniforms.useScreenCoordinates=f.getUniformLocation(w.program,"useScreenCoordinates");w.uniforms.affectedByDistance=f.getUniformLocation(w.program,"affectedByDistance");w.uniforms.screenPosition=f.getUniformLocation(w.program,"screenPosition");w.uniforms.modelViewMatrix=f.getUniformLocation(w.program,"modelViewMatrix");w.uniforms.projectionMatrix=f.getUniformLocation(w.program,
"projectionMatrix");var Va=!1;this.setSize=function(b,c){Ga.width=b;Ga.height=c;this.setViewport(0,0,Ga.width,Ga.height)};this.setViewport=function(b,c,d,e){M=b;za=c;Da=d;Ea=e;f.viewport(M,za,Da,Ea)};this.setScissor=function(b,c,d,e){f.scissor(b,c,d,e)};this.enableScissorTest=function(b){b?f.enable(f.SCISSOR_TEST):f.disable(f.SCISSOR_TEST)};this.enableDepthBufferWrite=function(b){va=b;f.depthMask(b)};this.setClearColorHex=function(b,c){wa.setHex(b);Ia=c;f.clearColor(wa.r,wa.g,wa.b,Ia)};this.setClearColor=
function(b,c){wa.copy(b);Ia=c;f.clearColor(wa.r,wa.g,wa.b,Ia)};this.clear=function(){f.clear(f.COLOR_BUFFER_BIT|f.DEPTH_BUFFER_BIT|f.STENCIL_BUFFER_BIT)};this.getContext=function(){return f};this.deallocateObject=function(b){if(b.__webglInit)if(b.__webglInit=!1,delete b._modelViewMatrix,delete b._normalMatrixArray,delete b._modelViewMatrixArray,delete b._objectMatrixArray,b instanceof THREE.Mesh)for(g in b.geometry.geometryGroups){var c=b.geometry.geometryGroups[g];f.deleteBuffer(c.__webglVertexBuffer);
f.deleteBuffer(c.__webglNormalBuffer);f.deleteBuffer(c.__webglTangentBuffer);f.deleteBuffer(c.__webglColorBuffer);f.deleteBuffer(c.__webglUVBuffer);f.deleteBuffer(c.__webglUV2Buffer);f.deleteBuffer(c.__webglSkinVertexABuffer);f.deleteBuffer(c.__webglSkinVertexBBuffer);f.deleteBuffer(c.__webglSkinIndicesBuffer);f.deleteBuffer(c.__webglSkinWeightsBuffer);f.deleteBuffer(c.__webglFaceBuffer);f.deleteBuffer(c.__webglLineBuffer);if(c.numMorphTargets)for(var d=0,e=c.numMorphTargets;d<e;d++)f.deleteBuffer(c.__webglMorphTargetsBuffers[d])}else if(b instanceof
THREE.Ribbon)b=b.geometry,f.deleteBuffer(b.__webglVertexBuffer),f.deleteBuffer(b.__webglColorBuffer);else if(b instanceof THREE.Line)b=b.geometry,f.deleteBuffer(b.__webglVertexBuffer),f.deleteBuffer(b.__webglColorBuffer);else if(b instanceof THREE.ParticleSystem)b=b.geometry,f.deleteBuffer(b.__webglVertexBuffer),f.deleteBuffer(b.__webglColorBuffer)};this.deallocateTexture=function(b){if(b.__webglInit)b.__webglInit=!1,f.deleteTexture(b.__webglTexture)};this.initMaterial=function(b,c,d,e){var h,j,k;
b instanceof THREE.MeshDepthMaterial?k="depth":b instanceof THREE.MeshNormalMaterial?k="normal":b instanceof THREE.MeshBasicMaterial?k="basic":b instanceof THREE.MeshLambertMaterial?k="lambert":b instanceof THREE.MeshPhongMaterial?k="phong":b instanceof THREE.LineBasicMaterial?k="basic":b instanceof THREE.ParticleBasicMaterial&&(k="particle_basic");if(k){var m=THREE.ShaderLib[k];b.uniforms=THREE.UniformsUtils.clone(m.uniforms);b.vertexShader=m.vertexShader;b.fragmentShader=m.fragmentShader}var p,
q,n;p=n=m=0;for(q=c.length;p<q;p++)j=c[p],j instanceof THREE.SpotLight&&n++,j instanceof THREE.DirectionalLight&&n++,j instanceof THREE.PointLight&&m++;m+n<=_maxLights?p=n:(p=Math.ceil(_maxLights*n/(m+n)),m=_maxLights-p);j={directional:p,point:m};m=n=0;for(p=c.length;m<p;m++)q=c[m],q instanceof THREE.SpotLight&&q.castShadow&&n++;var r=50;if(e!==void 0&&e instanceof THREE.SkinnedMesh)r=e.bones.length;var s;a:{p=b.fragmentShader;q=b.vertexShader;var m=b.uniforms,c=b.attributes,d={map:!!b.map,envMap:!!b.envMap,
lightMap:!!b.lightMap,vertexColors:b.vertexColors,fog:d,sizeAttenuation:b.sizeAttenuation,skinning:b.skinning,morphTargets:b.morphTargets,maxMorphTargets:this.maxMorphTargets,maxDirLights:j.directional,maxPointLights:j.point,maxBones:r,shadowMapEnabled:this.shadowMapEnabled&&e.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapWidth:this.shadowMapWidth,shadowMapHeight:this.shadowMapHeight,maxShadows:n,alphaTest:b.alphaTest},u,e=[];k?e.push(k):(e.push(p),e.push(q));for(u in d)e.push(u),e.push(d[u]);
k=e.join();u=0;for(e=ua.length;u<e;u++)if(ua[u].code==k){s=ua[u].program;break a}u=f.createProgram();e=[Xa?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_SHADOWS "+d.maxShadows,"#define MAX_BONES "+d.maxBones,d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.skinning?"#define USE_SKINNING":"",d.morphTargets?"#define USE_MORPHTARGETS":
"",d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapSoft?"#define SHADOWMAP_SOFT":"",d.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
j=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_SHADOWS "+d.maxShadows,d.alphaTest?"#define ALPHATEST "+d.alphaTest:"",d.fog?"#define USE_FOG":"",d.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapSoft?"#define SHADOWMAP_SOFT":
"",d.shadowMapSoft?"#define SHADOWMAP_WIDTH "+d.shadowMapWidth.toFixed(1):"",d.shadowMapSoft?"#define SHADOWMAP_HEIGHT "+d.shadowMapHeight.toFixed(1):"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");f.attachShader(u,Z("fragment",j+p));f.attachShader(u,Z("vertex",e+q));f.linkProgram(u);f.getProgramParameter(u,f.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+f.getProgramParameter(u,f.VALIDATE_STATUS)+", gl error ["+f.getError()+"]");u.uniforms=
{};u.attributes={};var v,e=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(v in m)e.push(v);v=e;e=0;for(m=v.length;e<m;e++)p=v[e],u.uniforms[p]=f.getUniformLocation(u,p);e=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(v=0;v<d.maxMorphTargets;v++)e.push("morphTarget"+v);for(s in c)e.push(s);s=e;v=0;for(c=s.length;v<c;v++)d=
s[v],u.attributes[d]=f.getAttribLocation(u,d);ua.push({program:u,code:k});s=u}b.program=s;s=b.program.attributes;s.position>=0&&f.enableVertexAttribArray(s.position);s.color>=0&&f.enableVertexAttribArray(s.color);s.normal>=0&&f.enableVertexAttribArray(s.normal);s.tangent>=0&&f.enableVertexAttribArray(s.tangent);b.skinning&&s.skinVertexA>=0&&s.skinVertexB>=0&&s.skinIndex>=0&&s.skinWeight>=0&&(f.enableVertexAttribArray(s.skinVertexA),f.enableVertexAttribArray(s.skinVertexB),f.enableVertexAttribArray(s.skinIndex),
f.enableVertexAttribArray(s.skinWeight));if(b.attributes)for(h in b.attributes)s[h]!==void 0&&s[h]>=0&&f.enableVertexAttribArray(s[h]);if(b.morphTargets)for(h=b.numSupportedMorphTargets=0;h<this.maxMorphTargets;h++)v="morphTarget"+h,s[v]>=0&&(f.enableVertexAttribArray(s[v]),b.numSupportedMorphTargets++)};this.clearTarget=function(b,c,d,e){U(b);b=0;c&&(b|=f.COLOR_BUFFER_BIT);d&&(b|=f.DEPTH_BUFFER_BIT);e&&(b|=f.STENCIL_BUFFER_BIT);f.clear(b)};this.render=function(b,c,f,n){var J,u,w,ha,G,H,D,L,C=b.lights,
Pa=b.fog;this.shadowMapEnabled&&B(b,c);I.data.vertices=0;I.data.faces=0;I.data.drawCalls=0;c.matrixAutoUpdate&&c.update(void 0,!0);b.update(void 0,!1,c);c.matrixWorldInverse.flattenToArray(Ca);c.projectionMatrix.flattenToArray(Aa);sa.multiply(c.projectionMatrix,c.matrixWorldInverse);q(sa);this.initWebGLObjects(b);U(f);(this.autoClear||n)&&this.clear();G=b.__webglObjects.length;for(n=0;n<G;n++)if(J=b.__webglObjects[n],D=J.object,D.visible)if(!(D instanceof THREE.Mesh)||!D.frustumCulled||p(D)){if(D.matrixWorld.flattenToArray(D._objectMatrixArray),
E(D,c,!0),r(J),J.render=!0,this.sortObjects)J.object.renderDepth?J.z=J.object.renderDepth:(Ka.copy(D.position),sa.multiplyVector3(Ka),J.z=Ka.z)}else J.render=!1;else J.render=!1;this.sortObjects&&b.__webglObjects.sort(v);H=b.__webglObjectsImmediate.length;for(n=0;n<H;n++)J=b.__webglObjectsImmediate[n],D=J.object,D.visible&&(D.matrixAutoUpdate&&D.matrixWorld.flattenToArray(D._objectMatrixArray),E(D,c,!0),s(J));if(b.overrideMaterial){k(b.overrideMaterial.depthTest);R(b.overrideMaterial.blending);for(n=
0;n<G;n++)if(J=b.__webglObjects[n],J.render)D=J.object,L=J.buffer,h(D),e(c,C,Pa,b.overrideMaterial,L,D);for(n=0;n<H;n++)J=b.__webglObjectsImmediate[n],D=J.object,D.visible&&(h(D),u=d(c,C,Pa,b.overrideMaterial,D),D.render(function(c){j(c,u,b.overrideMaterial.shading)}))}else{R(THREE.NormalBlending);for(n=G-1;n>=0;n--)if(J=b.__webglObjects[n],J.render){D=J.object;L=J.buffer;w=J.opaque;h(D);for(J=0;J<w.count;J++)ha=w.list[J],k(ha.depthTest),m(ha.polygonOffset,ha.polygonOffsetFactor,ha.polygonOffsetUnits),
e(c,C,Pa,ha,L,D)}for(n=0;n<H;n++)if(J=b.__webglObjectsImmediate[n],D=J.object,D.visible){w=J.opaque;h(D);for(J=0;J<w.count;J++)ha=w.list[J],k(ha.depthTest),m(ha.polygonOffset,ha.polygonOffsetFactor,ha.polygonOffsetUnits),u=d(c,C,Pa,ha,D),D.render(function(b){j(b,u,ha.shading)})}for(n=0;n<G;n++)if(J=b.__webglObjects[n],J.render){D=J.object;L=J.buffer;w=J.transparent;h(D);for(J=0;J<w.count;J++)ha=w.list[J],R(ha.blending),k(ha.depthTest),m(ha.polygonOffset,ha.polygonOffsetFactor,ha.polygonOffsetUnits),
e(c,C,Pa,ha,L,D)}for(n=0;n<H;n++)if(J=b.__webglObjectsImmediate[n],D=J.object,D.visible){w=J.transparent;h(D);for(J=0;J<w.count;J++)ha=w.list[J],R(ha.blending),k(ha.depthTest),m(ha.polygonOffset,ha.polygonOffsetFactor,ha.polygonOffsetUnits),u=d(c,C,Pa,ha,D),D.render(function(b){j(b,u,ha.shading)})}}b.__webglSprites.length&&y(b,c);f&&f.minFilter!==THREE.NearestFilter&&f.minFilter!==THREE.LinearFilter&&S(f)};this.initWebGLObjects=function(b){if(!b.__webglObjects)b.__webglObjects=[],b.__webglObjectsImmediate=
[],b.__webglSprites=[];for(;b.__objectsAdded.length;){var d=b.__objectsAdded[0],e=b,h=void 0,j=void 0,k=void 0;if(!d.__webglInit)if(d.__webglInit=!0,d._modelViewMatrix=new THREE.Matrix4,d._normalMatrixArray=new Float32Array(9),d._modelViewMatrixArray=new Float32Array(16),d._objectMatrixArray=new Float32Array(16),d.matrixWorld.flattenToArray(d._objectMatrixArray),d instanceof THREE.Mesh)for(h in j=d.geometry,j.geometryGroups==void 0&&ra(j),j.geometryGroups){k=j.geometryGroups[h];if(!k.__webglVertexBuffer){var m=
k;m.__webglVertexBuffer=f.createBuffer();m.__webglNormalBuffer=f.createBuffer();m.__webglTangentBuffer=f.createBuffer();m.__webglColorBuffer=f.createBuffer();m.__webglUVBuffer=f.createBuffer();m.__webglUV2Buffer=f.createBuffer();m.__webglSkinVertexABuffer=f.createBuffer();m.__webglSkinVertexBBuffer=f.createBuffer();m.__webglSkinIndicesBuffer=f.createBuffer();m.__webglSkinWeightsBuffer=f.createBuffer();m.__webglFaceBuffer=f.createBuffer();m.__webglLineBuffer=f.createBuffer();if(m.numMorphTargets){var p=
void 0,n=void 0;m.__webglMorphTargetsBuffers=[];p=0;for(n=m.numMorphTargets;p<n;p++)m.__webglMorphTargetsBuffers.push(f.createBuffer())}for(var m=k,p=d,q=void 0,r=void 0,s=void 0,u=s=void 0,v=void 0,w=void 0,B=w=n=0,y=s=r=void 0,C=y=r=q=void 0,s=void 0,u=p.geometry,v=u.faces,y=m.faces,q=0,r=y.length;q<r;q++)s=y[q],s=v[s],s instanceof THREE.Face3?(n+=3,w+=1,B+=3):s instanceof THREE.Face4&&(n+=4,w+=2,B+=4);for(var q=m,r=p,F=y=v=void 0,K=void 0,F=void 0,s=[],v=0,y=r.materials.length;v<y;v++)if(F=r.materials[v],
F instanceof THREE.MeshFaceMaterial){F=0;for(l=q.materials.length;F<l;F++)(K=q.materials[F])&&s.push(K)}else(K=F)&&s.push(K);q=s;m.__materials=q;a:{v=r=void 0;y=q.length;for(r=0;r<y;r++)if(v=q[r],v.map||v.lightMap||v instanceof THREE.MeshShaderMaterial){r=!0;break a}r=!1}a:{y=v=void 0;s=q.length;for(v=0;v<s;v++)if(y=q[v],!(y instanceof THREE.MeshBasicMaterial&&!y.envMap||y instanceof THREE.MeshDepthMaterial)){y=y&&y.shading!=void 0&&y.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;
break a}y=!1}a:{s=v=void 0;F=q.length;for(v=0;v<F;v++)if(s=q[v],s.vertexColors){s=s.vertexColors;break a}s=!1}m.__vertexArray=new Float32Array(n*3);if(y)m.__normalArray=new Float32Array(n*3);if(u.hasTangents)m.__tangentArray=new Float32Array(n*4);if(s)m.__colorArray=new Float32Array(n*3);if(r){if(u.faceUvs.length>0||u.faceVertexUvs.length>0)m.__uvArray=new Float32Array(n*2);if(u.faceUvs.length>1||u.faceVertexUvs.length>1)m.__uv2Array=new Float32Array(n*2)}if(p.geometry.skinWeights.length&&p.geometry.skinIndices.length)m.__skinVertexAArray=
new Float32Array(n*4),m.__skinVertexBArray=new Float32Array(n*4),m.__skinIndexArray=new Float32Array(n*4),m.__skinWeightArray=new Float32Array(n*4);m.__faceArray=new Uint16Array(w*3+(p.geometry.edgeFaces?p.geometry.edgeFaces.length*6:0));m.__lineArray=new Uint16Array(B*2);if(m.numMorphTargets){m.__morphTargetsArrays=[];u=0;for(v=m.numMorphTargets;u<v;u++)m.__morphTargetsArrays.push(new Float32Array(n*3))}m.__needsSmoothNormals=y==THREE.SmoothShading;m.__uvType=r;m.__vertexColorType=s;m.__normalType=
y;m.__webglFaceCount=w*3+(p.geometry.edgeFaces?p.geometry.edgeFaces.length*6:0);m.__webglLineCount=B*2;u=0;for(v=q.length;u<v;u++)if(r=q[u],r.attributes){if(m.__webglCustomAttributes===void 0)m.__webglCustomAttributes={};for(a in r.attributes){s=r.attributes[a];y={};for(C in s)y[C]=s[C];if(!y.__webglInitialized||y.createUniqueBuffers)y.__webglInitialized=!0,w=1,y.type==="v2"?w=2:y.type==="v3"?w=3:y.type==="v4"?w=4:y.type==="c"&&(w=3),y.size=w,y.array=new Float32Array(n*w),y.buffer=f.createBuffer(),
y.buffer.belongsToAttribute=a,s.needsUpdate=!0,y.__original=s;m.__webglCustomAttributes[a]=y}}m.__inittedArrays=!0;j.__dirtyVertices=!0;j.__dirtyMorphTargets=!0;j.__dirtyElements=!0;j.__dirtyUvs=!0;j.__dirtyNormals=!0;j.__dirtyTangents=!0;j.__dirtyColors=!0}na(e.__webglObjects,k,d)}else if(d instanceof THREE.Ribbon){j=d.geometry;if(!j.__webglVertexBuffer)h=j,h.__webglVertexBuffer=f.createBuffer(),h.__webglColorBuffer=f.createBuffer(),h=j,k=h.vertices.length,h.__vertexArray=new Float32Array(k*3),h.__colorArray=
new Float32Array(k*3),h.__webglVertexCount=k,j.__dirtyVertices=!0,j.__dirtyColors=!0;na(e.__webglObjects,j,d)}else if(d instanceof THREE.Line){j=d.geometry;if(!j.__webglVertexBuffer)h=j,h.__webglVertexBuffer=f.createBuffer(),h.__webglColorBuffer=f.createBuffer(),h=j,k=h.vertices.length,h.__vertexArray=new Float32Array(k*3),h.__colorArray=new Float32Array(k*3),h.__webglLineCount=k,j.__dirtyVertices=!0,j.__dirtyColors=!0;na(e.__webglObjects,j,d)}else if(d instanceof THREE.ParticleSystem){j=d.geometry;
if(!j.__webglVertexBuffer){h=j;h.__webglVertexBuffer=f.createBuffer();h.__webglColorBuffer=f.createBuffer();h=j;k=d;m=h.vertices.length;h.__vertexArray=new Float32Array(m*3);h.__colorArray=new Float32Array(m*3);h.__sortArray=[];h.__webglParticleCount=m;h.__materials=k.materials;C=n=p=void 0;p=0;for(n=k.materials.length;p<n;p++)if(C=k.materials[p],C.attributes){if(h.__webglCustomAttributes===void 0)h.__webglCustomAttributes={};for(a in C.attributes){originalAttribute=C.attributes[a];attribute={};for(property in originalAttribute)attribute[property]=
originalAttribute[property];if(!attribute.__webglInitialized||attribute.createUniqueBuffers)attribute.__webglInitialized=!0,size=1,attribute.type==="v2"?size=2:attribute.type==="v3"?size=3:attribute.type==="v4"?size=4:attribute.type==="c"&&(size=3),attribute.size=size,attribute.array=new Float32Array(m*size),attribute.buffer=f.createBuffer(),attribute.buffer.belongsToAttribute=a,originalAttribute.needsUpdate=!0,attribute.__original=originalAttribute;h.__webglCustomAttributes[a]=attribute}}j.__dirtyVertices=
!0;j.__dirtyColors=!0}na(e.__webglObjects,j,d)}else THREE.MarchingCubes!==void 0&&d instanceof THREE.MarchingCubes?e.__webglObjectsImmediate.push({object:d,opaque:{list:[],count:0},transparent:{list:[],count:0}}):d instanceof THREE.Sprite&&e.__webglSprites.push(d);b.__objectsAdded.splice(0,1)}for(;b.__objectsRemoved.length;){e=b.__objectsRemoved[0];d=b;if(e instanceof THREE.Mesh||e instanceof THREE.ParticleSystem||e instanceof THREE.Ribbon||e instanceof THREE.Line)ya(d.__webglObjects,e);else if(e instanceof
THREE.Sprite){d=d.__webglSprites;j=void 0;for(j=d.length-1;j>=0;j--)d[j]==e&&d.splice(j,1)}else e instanceof THREE.MarchingCubes&&ya(d.__webglObjectsImmediate,e);b.__objectsRemoved.splice(0,1)}d=0;for(e=b.__webglObjects.length;d<e;d++)if(h=b.__webglObjects[d].object,n=k=j=void 0,h instanceof THREE.Mesh){j=h.geometry;m=0;for(p=j.geometryGroupsList.length;m<p;m++)if(k=j.geometryGroupsList[m],n=L(k),j.__dirtyVertices||j.__dirtyMorphTargets||j.__dirtyElements||j.__dirtyUvs||j.__dirtyNormals||j.__dirtyColors||
j.__dirtyTangents||n)if(n=k,C=f.DYNAMIC_DRAW,w=!j.dynamic,n.__inittedArrays){var E=u=B=void 0,A=void 0,N=E=void 0,I=void 0,R=void 0,O=void 0,Q=K=F=s=y=v=r=q=void 0,M=void 0,t=A=O=A=R=I=void 0,o=void 0,z=o=t=I=void 0,S=void 0,V=z=o=t=E=E=N=O=A=z=o=t=S=z=o=t=S=z=o=t=void 0,ja=0,P=0,X=0,Z=0,W=0,T=0,Y=0,U=0,ka=0,x=0,ma=0,z=t=0,z=void 0,pa=n.__vertexArray,la=n.__uvArray,oa=n.__uv2Array,$=n.__normalArray,aa=n.__tangentArray,qa=n.__colorArray,ca=n.__skinVertexAArray,da=n.__skinVertexBArray,ea=n.__skinIndexArray,
fa=n.__skinWeightArray,sa=n.__morphTargetsArrays,ga=n.__webglCustomAttributes,o=void 0,ia=n.__faceArray,Ba=n.__lineArray,wa=n.__needsSmoothNormals,r=n.__vertexColorType,q=n.__uvType,v=n.__normalType,ta=h.geometry,va=ta.__dirtyVertices,za=ta.__dirtyElements,ua=ta.__dirtyUvs,Ca=ta.__dirtyNormals,Da=ta.__dirtyTangents,Ea=ta.__dirtyColors,Fa=ta.__dirtyMorphTargets,Aa=ta.vertices,Ga=n.faces,Ka=ta.faces,Ia=ta.faceVertexUvs[0],La=ta.faceVertexUvs[1],Ma=ta.skinVerticesA,Na=ta.skinVerticesB,Oa=ta.skinIndices,
Ja=ta.skinWeights,Ha=ta.morphTargets;if(ga)for(V in ga)ga[V].offset=0,ga[V].offsetSrc=0;B=0;for(u=Ga.length;B<u;B++)if(E=Ga[B],A=Ka[E],Ia&&(y=Ia[E]),La&&(s=La[E]),E=A.vertexNormals,N=A.normal,I=A.vertexColors,R=A.color,O=A.vertexTangents,A instanceof THREE.Face3){if(va)F=Aa[A.a].position,K=Aa[A.b].position,Q=Aa[A.c].position,pa[P]=F.x,pa[P+1]=F.y,pa[P+2]=F.z,pa[P+3]=K.x,pa[P+4]=K.y,pa[P+5]=K.z,pa[P+6]=Q.x,pa[P+7]=Q.y,pa[P+8]=Q.z,P+=9;if(ga)for(V in ga)if(o=ga[V],o.__original.needsUpdate)t=o.offset,
z=o.offsetSrc,o.size===1?(o.boundTo===void 0||o.boundTo==="vertices"?(o.array[t]=o.value[A.a],o.array[t+1]=o.value[A.b],o.array[t+2]=o.value[A.c]):o.boundTo==="faces"?(z=o.value[z],o.array[t]=z,o.array[t+1]=z,o.array[t+2]=z,o.offsetSrc++):o.boundTo==="faceVertices"&&(o.array[t]=o.value[z],o.array[t+1]=o.value[z+1],o.array[t+2]=o.value[z+2],o.offsetSrc+=3),o.offset+=3):(o.boundTo===void 0||o.boundTo==="vertices"?(F=o.value[A.a],K=o.value[A.b],Q=o.value[A.c]):o.boundTo==="faces"?(Q=K=F=z=o.value[z],
o.offsetSrc++):o.boundTo==="faceVertices"&&(F=o.value[z],K=o.value[z+1],Q=o.value[z+2],o.offsetSrc+=3),o.size===2?(o.array[t]=F.x,o.array[t+1]=F.y,o.array[t+2]=K.x,o.array[t+3]=K.y,o.array[t+4]=Q.x,o.array[t+5]=Q.y,o.offset+=6):o.size===3?(o.type==="c"?(o.array[t]=F.r,o.array[t+1]=F.g,o.array[t+2]=F.b,o.array[t+3]=K.r,o.array[t+4]=K.g,o.array[t+5]=K.b,o.array[t+6]=Q.r,o.array[t+7]=Q.g,o.array[t+8]=Q.b):(o.array[t]=F.x,o.array[t+1]=F.y,o.array[t+2]=F.z,o.array[t+3]=K.x,o.array[t+4]=K.y,o.array[t+5]=
K.z,o.array[t+6]=Q.x,o.array[t+7]=Q.y,o.array[t+8]=Q.z),o.offset+=9):(o.array[t]=F.x,o.array[t+1]=F.y,o.array[t+2]=F.z,o.array[t+3]=F.w,o.array[t+4]=K.x,o.array[t+5]=K.y,o.array[t+6]=K.z,o.array[t+7]=K.w,o.array[t+8]=Q.x,o.array[t+9]=Q.y,o.array[t+10]=Q.z,o.array[t+11]=Q.w,o.offset+=12));if(Fa){t=0;for(o=Ha.length;t<o;t++)F=Ha[t].vertices[A.a].position,K=Ha[t].vertices[A.b].position,Q=Ha[t].vertices[A.c].position,z=sa[t],z[ma]=F.x,z[ma+1]=F.y,z[ma+2]=F.z,z[ma+3]=K.x,z[ma+4]=K.y,z[ma+5]=K.z,z[ma+6]=
Q.x,z[ma+7]=Q.y,z[ma+8]=Q.z;ma+=9}if(Ja.length)t=Ja[A.a],o=Ja[A.b],z=Ja[A.c],fa[x]=t.x,fa[x+1]=t.y,fa[x+2]=t.z,fa[x+3]=t.w,fa[x+4]=o.x,fa[x+5]=o.y,fa[x+6]=o.z,fa[x+7]=o.w,fa[x+8]=z.x,fa[x+9]=z.y,fa[x+10]=z.z,fa[x+11]=z.w,t=Oa[A.a],o=Oa[A.b],z=Oa[A.c],ea[x]=t.x,ea[x+1]=t.y,ea[x+2]=t.z,ea[x+3]=t.w,ea[x+4]=o.x,ea[x+5]=o.y,ea[x+6]=o.z,ea[x+7]=o.w,ea[x+8]=z.x,ea[x+9]=z.y,ea[x+10]=z.z,ea[x+11]=z.w,t=Ma[A.a],o=Ma[A.b],z=Ma[A.c],ca[x]=t.x,ca[x+1]=t.y,ca[x+2]=t.z,ca[x+3]=1,ca[x+4]=o.x,ca[x+5]=o.y,ca[x+6]=
o.z,ca[x+7]=1,ca[x+8]=z.x,ca[x+9]=z.y,ca[x+10]=z.z,ca[x+11]=1,t=Na[A.a],o=Na[A.b],z=Na[A.c],da[x]=t.x,da[x+1]=t.y,da[x+2]=t.z,da[x+3]=1,da[x+4]=o.x,da[x+5]=o.y,da[x+6]=o.z,da[x+7]=1,da[x+8]=z.x,da[x+9]=z.y,da[x+10]=z.z,da[x+11]=1,x+=12;if(Ea&&r)I.length==3&&r==THREE.VertexColors?(A=I[0],t=I[1],o=I[2]):o=t=A=R,qa[ka]=A.r,qa[ka+1]=A.g,qa[ka+2]=A.b,qa[ka+3]=t.r,qa[ka+4]=t.g,qa[ka+5]=t.b,qa[ka+6]=o.r,qa[ka+7]=o.g,qa[ka+8]=o.b,ka+=9;if(Da&&ta.hasTangents)I=O[0],R=O[1],A=O[2],aa[Y]=I.x,aa[Y+1]=I.y,aa[Y+
2]=I.z,aa[Y+3]=I.w,aa[Y+4]=R.x,aa[Y+5]=R.y,aa[Y+6]=R.z,aa[Y+7]=R.w,aa[Y+8]=A.x,aa[Y+9]=A.y,aa[Y+10]=A.z,aa[Y+11]=A.w,Y+=12;if(Ca&&v)if(E.length==3&&wa)for(O=0;O<3;O++)N=E[O],$[T]=N.x,$[T+1]=N.y,$[T+2]=N.z,T+=3;else for(O=0;O<3;O++)$[T]=N.x,$[T+1]=N.y,$[T+2]=N.z,T+=3;if(ua&&y!==void 0&&q)for(O=0;O<3;O++)E=y[O],la[X]=E.u,la[X+1]=E.v,X+=2;if(ua&&s!==void 0&&q)for(O=0;O<3;O++)E=s[O],oa[Z]=E.u,oa[Z+1]=E.v,Z+=2;za&&(ia[W]=ja,ia[W+1]=ja+1,ia[W+2]=ja+2,W+=3,Ba[U]=ja,Ba[U+1]=ja+1,Ba[U+2]=ja,Ba[U+3]=ja+2,Ba[U+
4]=ja+1,Ba[U+5]=ja+2,U+=6,ja+=3)}else if(A instanceof THREE.Face4){if(va)F=Aa[A.a].position,K=Aa[A.b].position,Q=Aa[A.c].position,M=Aa[A.d].position,pa[P]=F.x,pa[P+1]=F.y,pa[P+2]=F.z,pa[P+3]=K.x,pa[P+4]=K.y,pa[P+5]=K.z,pa[P+6]=Q.x,pa[P+7]=Q.y,pa[P+8]=Q.z,pa[P+9]=M.x,pa[P+10]=M.y,pa[P+11]=M.z,P+=12;if(ga)for(V in ga)if(o=ga[V],o.__original.needsUpdate)t=o.offset,z=o.offsetSrc,o.size===1?(o.boundTo===void 0||o.boundTo==="vertices"?(o.array[t]=o.value[A.a],o.array[t+1]=o.value[A.b],o.array[t+2]=o.value[A.c],
o.array[t+3]=o.value[A.d]):o.boundTo==="faces"?(z=o.value[z],o.array[t]=z,o.array[t+1]=z,o.array[t+2]=z,o.array[t+3]=z,o.offsetSrc++):o.boundTo==="faceVertices"&&(o.array[t]=o.value[z],o.array[t+1]=o.value[z+1],o.array[t+2]=o.value[z+2],o.array[t+3]=o.value[z+3],o.offsetSrc+=4),o.offset+=4):(o.boundTo===void 0||o.boundTo==="vertices"?(F=o.value[A.a],K=o.value[A.b],Q=o.value[A.c],M=o.value[A.d]):o.boundTo==="faces"?(M=Q=K=F=z=o.value[z],o.offsetSrc++):o.boundTo==="faceVertices"&&(F=o.value[z],K=o.value[z+
1],Q=o.value[z+2],M=o.value[z+3],o.offsetSrc+=4),o.size===2?(o.array[t]=F.x,o.array[t+1]=F.y,o.array[t+2]=K.x,o.array[t+3]=K.y,o.array[t+4]=Q.x,o.array[t+5]=Q.y,o.array[t+6]=M.x,o.array[t+7]=M.y,o.offset+=8):o.size===3?(o.type==="c"?(o.array[t]=F.r,o.array[t+1]=F.g,o.array[t+2]=F.b,o.array[t+3]=K.r,o.array[t+4]=K.g,o.array[t+5]=K.b,o.array[t+6]=Q.r,o.array[t+7]=Q.g,o.array[t+8]=Q.b,o.array[t+9]=M.r,o.array[t+10]=M.g,o.array[t+11]=M.b):(o.array[t]=F.x,o.array[t+1]=F.y,o.array[t+2]=F.z,o.array[t+3]=
K.x,o.array[t+4]=K.y,o.array[t+5]=K.z,o.array[t+6]=Q.x,o.array[t+7]=Q.y,o.array[t+8]=Q.z,o.array[t+9]=M.x,o.array[t+10]=M.y,o.array[t+11]=M.z),o.offset+=12):(o.array[t]=F.x,o.array[t+1]=F.y,o.array[t+2]=F.z,o.array[t+3]=F.w,o.array[t+4]=K.x,o.array[t+5]=K.y,o.array[t+6]=K.z,o.array[t+7]=K.w,o.array[t+8]=Q.x,o.array[t+9]=Q.y,o.array[t+10]=Q.z,o.array[t+11]=Q.w,o.array[t+12]=M.x,o.array[t+13]=M.y,o.array[t+14]=M.z,o.array[t+15]=M.w,o.offset+=16));if(Fa){t=0;for(o=Ha.length;t<o;t++)F=Ha[t].vertices[A.a].position,
K=Ha[t].vertices[A.b].position,Q=Ha[t].vertices[A.c].position,M=Ha[t].vertices[A.d].position,z=sa[t],z[ma]=F.x,z[ma+1]=F.y,z[ma+2]=F.z,z[ma+3]=K.x,z[ma+4]=K.y,z[ma+5]=K.z,z[ma+6]=Q.x,z[ma+7]=Q.y,z[ma+8]=Q.z,z[ma+9]=M.x,z[ma+10]=M.y,z[ma+11]=M.z;ma+=12}if(Ja.length)t=Ja[A.a],o=Ja[A.b],z=Ja[A.c],S=Ja[A.d],fa[x]=t.x,fa[x+1]=t.y,fa[x+2]=t.z,fa[x+3]=t.w,fa[x+4]=o.x,fa[x+5]=o.y,fa[x+6]=o.z,fa[x+7]=o.w,fa[x+8]=z.x,fa[x+9]=z.y,fa[x+10]=z.z,fa[x+11]=z.w,fa[x+12]=S.x,fa[x+13]=S.y,fa[x+14]=S.z,fa[x+15]=S.w,
t=Oa[A.a],o=Oa[A.b],z=Oa[A.c],S=Oa[A.d],ea[x]=t.x,ea[x+1]=t.y,ea[x+2]=t.z,ea[x+3]=t.w,ea[x+4]=o.x,ea[x+5]=o.y,ea[x+6]=o.z,ea[x+7]=o.w,ea[x+8]=z.x,ea[x+9]=z.y,ea[x+10]=z.z,ea[x+11]=z.w,ea[x+12]=S.x,ea[x+13]=S.y,ea[x+14]=S.z,ea[x+15]=S.w,t=Ma[A.a],o=Ma[A.b],z=Ma[A.c],S=Ma[A.d],ca[x]=t.x,ca[x+1]=t.y,ca[x+2]=t.z,ca[x+3]=1,ca[x+4]=o.x,ca[x+5]=o.y,ca[x+6]=o.z,ca[x+7]=1,ca[x+8]=z.x,ca[x+9]=z.y,ca[x+10]=z.z,ca[x+11]=1,ca[x+12]=S.x,ca[x+13]=S.y,ca[x+14]=S.z,ca[x+15]=1,t=Na[A.a],o=Na[A.b],z=Na[A.c],A=Na[A.d],
da[x]=t.x,da[x+1]=t.y,da[x+2]=t.z,da[x+3]=1,da[x+4]=o.x,da[x+5]=o.y,da[x+6]=o.z,da[x+7]=1,da[x+8]=z.x,da[x+9]=z.y,da[x+10]=z.z,da[x+11]=1,da[x+12]=A.x,da[x+13]=A.y,da[x+14]=A.z,da[x+15]=1,x+=16;if(Ea&&r)I.length==4&&r==THREE.VertexColors?(A=I[0],t=I[1],o=I[2],I=I[3]):I=o=t=A=R,qa[ka]=A.r,qa[ka+1]=A.g,qa[ka+2]=A.b,qa[ka+3]=t.r,qa[ka+4]=t.g,qa[ka+5]=t.b,qa[ka+6]=o.r,qa[ka+7]=o.g,qa[ka+8]=o.b,qa[ka+9]=I.r,qa[ka+10]=I.g,qa[ka+11]=I.b,ka+=12;if(Da&&ta.hasTangents)I=O[0],R=O[1],A=O[2],O=O[3],aa[Y]=I.x,
aa[Y+1]=I.y,aa[Y+2]=I.z,aa[Y+3]=I.w,aa[Y+4]=R.x,aa[Y+5]=R.y,aa[Y+6]=R.z,aa[Y+7]=R.w,aa[Y+8]=A.x,aa[Y+9]=A.y,aa[Y+10]=A.z,aa[Y+11]=A.w,aa[Y+12]=O.x,aa[Y+13]=O.y,aa[Y+14]=O.z,aa[Y+15]=O.w,Y+=16;if(Ca&&v)if(E.length==4&&wa)for(O=0;O<4;O++)N=E[O],$[T]=N.x,$[T+1]=N.y,$[T+2]=N.z,T+=3;else for(O=0;O<4;O++)$[T]=N.x,$[T+1]=N.y,$[T+2]=N.z,T+=3;if(ua&&y!==void 0&&q)for(O=0;O<4;O++)E=y[O],la[X]=E.u,la[X+1]=E.v,X+=2;if(ua&&s!==void 0&&q)for(O=0;O<4;O++)E=s[O],oa[Z]=E.u,oa[Z+1]=E.v,Z+=2;za&&(ia[W]=ja,ia[W+1]=ja+
1,ia[W+2]=ja+3,ia[W+3]=ja+1,ia[W+4]=ja+2,ia[W+5]=ja+3,W+=6,Ba[U]=ja,Ba[U+1]=ja+1,Ba[U+2]=ja,Ba[U+3]=ja+3,Ba[U+4]=ja+1,Ba[U+5]=ja+2,Ba[U+6]=ja+2,Ba[U+7]=ja+3,U+=8,ja+=4)}va&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,pa,C));if(ga)for(V in ga)o=ga[V],o.__original.needsUpdate&&(f.bindBuffer(f.ARRAY_BUFFER,o.buffer),f.bufferData(f.ARRAY_BUFFER,o.array,C));if(Fa){t=0;for(o=Ha.length;t<o;t++)f.bindBuffer(f.ARRAY_BUFFER,n.__webglMorphTargetsBuffers[t]),f.bufferData(f.ARRAY_BUFFER,
sa[t],C)}Ea&&ka>0&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglColorBuffer),f.bufferData(f.ARRAY_BUFFER,qa,C));Ca&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglNormalBuffer),f.bufferData(f.ARRAY_BUFFER,$,C));Da&&ta.hasTangents&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglTangentBuffer),f.bufferData(f.ARRAY_BUFFER,aa,C));ua&&X>0&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglUVBuffer),f.bufferData(f.ARRAY_BUFFER,la,C));ua&&Z>0&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglUV2Buffer),f.bufferData(f.ARRAY_BUFFER,oa,C));za&&(f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,
n.__webglFaceBuffer),f.bufferData(f.ELEMENT_ARRAY_BUFFER,ia,C),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,n.__webglLineBuffer),f.bufferData(f.ELEMENT_ARRAY_BUFFER,Ba,C));x>0&&(f.bindBuffer(f.ARRAY_BUFFER,n.__webglSkinVertexABuffer),f.bufferData(f.ARRAY_BUFFER,ca,C),f.bindBuffer(f.ARRAY_BUFFER,n.__webglSkinVertexBBuffer),f.bufferData(f.ARRAY_BUFFER,da,C),f.bindBuffer(f.ARRAY_BUFFER,n.__webglSkinIndicesBuffer),f.bufferData(f.ARRAY_BUFFER,ea,C),f.bindBuffer(f.ARRAY_BUFFER,n.__webglSkinWeightsBuffer),f.bufferData(f.ARRAY_BUFFER,
fa,C));w&&(delete n.__inittedArrays,delete n.__colorArray,delete n.__normalArray,delete n.__tangentArray,delete n.__uvArray,delete n.__uv2Array,delete n.__faceArray,delete n.__vertexArray,delete n.__lineArray,delete n.__skinVertexAArray,delete n.__skinVertexBArray,delete n.__skinIndexArray,delete n.__skinWeightArray)}j.__dirtyVertices=!1;j.__dirtyMorphTargets=!1;j.__dirtyElements=!1;j.__dirtyUvs=!1;j.__dirtyNormals=!1;j.__dirtyTangents=!1;j.__dirtyColors=!1;xa(k)}else if(h instanceof THREE.Ribbon){j=
h.geometry;if(j.__dirtyVertices||j.__dirtyColors){h=j;k=f.DYNAMIC_DRAW;m=B=w=w=void 0;u=h.vertices;p=h.colors;q=u.length;n=p.length;r=h.__vertexArray;C=h.__colorArray;v=h.__dirtyColors;if(h.__dirtyVertices){for(w=0;w<q;w++)B=u[w].position,m=w*3,r[m]=B.x,r[m+1]=B.y,r[m+2]=B.z;f.bindBuffer(f.ARRAY_BUFFER,h.__webglVertexBuffer);f.bufferData(f.ARRAY_BUFFER,r,k)}if(v){for(w=0;w<n;w++)color=p[w],m=w*3,C[m]=color.r,C[m+1]=color.g,C[m+2]=color.b;f.bindBuffer(f.ARRAY_BUFFER,h.__webglColorBuffer);f.bufferData(f.ARRAY_BUFFER,
C,k)}}j.__dirtyVertices=!1;j.__dirtyColors=!1}else if(h instanceof THREE.Line){j=h.geometry;if(j.__dirtyVertices||j.__dirtyColors){h=j;k=f.DYNAMIC_DRAW;m=B=w=w=void 0;u=h.vertices;p=h.colors;q=u.length;n=p.length;r=h.__vertexArray;C=h.__colorArray;v=h.__dirtyColors;if(h.__dirtyVertices){for(w=0;w<q;w++)B=u[w].position,m=w*3,r[m]=B.x,r[m+1]=B.y,r[m+2]=B.z;f.bindBuffer(f.ARRAY_BUFFER,h.__webglVertexBuffer);f.bufferData(f.ARRAY_BUFFER,r,k)}if(v){for(w=0;w<n;w++)color=p[w],m=w*3,C[m]=color.r,C[m+1]=color.g,
C[m+2]=color.b;f.bindBuffer(f.ARRAY_BUFFER,h.__webglColorBuffer);f.bufferData(f.ARRAY_BUFFER,C,k)}}j.__dirtyVertices=!1;j.__dirtyColors=!1}else if(h instanceof THREE.ParticleSystem)j=h.geometry,n=L(j),(j.__dirtyVertices||j.__dirtyColors||h.sortParticles||n)&&c(j,f.DYNAMIC_DRAW,h),j.__dirtyVertices=!1,j.__dirtyColors=!1,xa(j)};this.setFaceCulling=function(b,c){b?(!c||c=="ccw"?f.frontFace(f.CCW):f.frontFace(f.CW),b=="back"?f.cullFace(f.BACK):b=="front"?f.cullFace(f.FRONT):f.cullFace(f.FRONT_AND_BACK),
f.enable(f.CULL_FACE)):f.disable(f.CULL_FACE)};this.supportsVertexTextures=function(){return Xa}};
THREE.WebGLRenderTarget=function(b,c,d){this.width=b;this.height=c;d=d||{};this.wrapS=d.wrapS!==void 0?d.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=d.wrapT!==void 0?d.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=d.magFilter!==void 0?d.magFilter:THREE.LinearFilter;this.minFilter=d.minFilter!==void 0?d.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=d.format!==void 0?d.format:THREE.RGBAFormat;this.type=d.type!==void 0?d.type:
THREE.UnsignedByteType;this.depthBuffer=d.depthBuffer!==void 0?d.depthBuffer:!0;this.stencilBuffer=d.stencilBuffer!==void 0?d.stencilBuffer:!0};
THREE.WebGLRenderTarget.prototype.clone=function(){var b=new THREE.WebGLRenderTarget(this.width,this.height);b.wrapS=this.wrapS;b.wrapT=this.wrapT;b.magFilter=this.magFilter;b.minFilter=this.minFilter;b.offset.copy(this.offset);b.repeat.copy(this.repeat);b.format=this.format;b.type=this.type;b.depthBuffer=this.depthBuffer;b.stencilBuffer=this.stencilBuffer;return b};THREE.WebGLRenderTargetCube=function(b,c,d){THREE.WebGLRenderTarget.call(this,b,c,d);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;
