import { type ClassValue, clsx } from "clsx";
import { twMerge } from "tailwind-merge";

/**
 * Format a date string to a more readable format
 * @param dateString - ISO 8601 date string
 * @returns Formatted date string (e.g., October 1, 2024)
 */
export function formatDate(dateString: string): string {
	const date = new Date(dateString);
	return date.toLocaleDateString("en-US", {
		year: "numeric",
		month: "long",
		day: "numeric",
	});
}

export function cn(...inputs: ClassValue[]) {
	return twMerge(clsx(inputs));
}
