@group(0) @binding(0) var y_plane: texture_2d<u32>;
@group(0) @binding(1) var uv_plane: texture_2d<u32>;
@group(0) @binding(2) var output: texture_storage_2d<rgba8unorm, write>;

@compute @workgroup_size(8, 8)
fn main(@builtin(global_invocation_id) global_id: vec3<u32>) {
    let coords = global_id.xy;
    let dims = textureDimensions(output);

    if (coords.x >= dims.x || coords.y >= dims.y) {
        return;
    }

    // Sample Y plane
    let y = textureLoad(y_plane, coords, 0).r;

    // Sample UV plane (note: UV plane is half the size)
    let uv_coords = coords / 2;
    let uv = textureLoad(uv_plane, uv_coords, 0).rg;

    // YUV to RGB conversion
    let u = uv.r - 0.5;
    let v = uv.g - 0.5;

    let r = y + 1.402 * v;
    let g = y - 0.344 * u - 0.714 * v;
    let b = y + 1.772 * u;

    let color = vec4<f32>(
        clamp(r, 0.0, 1.0),
        clamp(g, 0.0, 1.0),
        clamp(b, 0.0, 1.0),
        1.0
    );

    textureStore(output, coords, color);
}
