"use client";

export const TermsPage = () => {
  return (
    <div className="wrapper wrapper-sm py-20">
      <div className="text-center space-y-6">
        <h1 className=" text-3xl md:text-4xl fade-in-down animate-delay-1">
          Terms of Service
        </h1>
        <p className="text-lg text-gray-8 max-w-lg mx-auto fade-in-down animate-delay-2">
          We've tried to make this terms of service policy as simple and
          digestible as possible. If you have any questions, please don't
          hesitate to reach out to us.
        </p>
        <div className="legal-body text-left fade-in-up animate-delay-2">
          <>
            <ol>
              <li>
                <h3>Introduction</h3>
                <br />
                Welcome to Cap Software, Inc. ("Cap," "we," "us," or "our").
                These Terms of Service ("Terms") govern your access to and use
                of our website, software, and services (collectively, the
                "Services"). By accessing or using our Services, you agree to be
                bound by these Terms. If you do not agree to these Terms, you
                may not access or use our Services.
              </li>
              <li>
                <h3>Services</h3>
                <br />
                Cap provides a platform that allows users to record their screen
                and webcam, edit their recordings, generate shareable links, and
                collaborate with others through "Spaces." We offer a free plan
                with usage limits and a paid "Cap Pro" plan.
              </li>
              <li>
                <h3>User Accounts</h3>
                <br />
                To access certain features of our Services, you may be required
                to create an account. You are responsible for maintaining the
                confidentiality of your account information and for all
                activities that occur under your account. You agree to provide
                accurate, current, and complete information during the
                registration process and to update such information as needed.
              </li>
              <li>
                <h3>User Content</h3>
                <br />
                You are solely responsible for the content you record, upload,
                or otherwise make available through our Services ("User
                Content"). By making any User Content available through our
                Services, you grant to Cap a non-exclusive, transferable,
                sublicensable, worldwide, royalty-free license to use, copy,
                modify, create derivative works based upon, distribute, publicly
                display, and publicly perform your User Content in connection
                with operating and providing our Services.
              </li>
              <li>
                <h3>Intellectual Property</h3>
                <br />
                Our Services and their original content, features, and
                functionality are owned by Cap and are protected by
                international copyright, trademark, patent, trade secret, and
                other intellectual property or proprietary rights laws. You may
                not copy, modify, distribute, sell, or lease any part of our
                Services, nor may you reverse engineer or attempt to extract the
                source code of our software.
              </li>
              <li>
                <h3>User Conduct</h3>
                <br />
                You agree not to use our Services to:
                <br />
                a. Upload, post, or transmit any User Content that is unlawful,
                harmful, threatening, abusive, harassing, tortious, defamatory,
                vulgar, obscene, libelous, or otherwise objectionable;
                <br />
                b. Impersonate any person or entity or falsely state or
                otherwise misrepresent your affiliation with a person or entity;
                <br />
                c. Engage in any activity that interferes with or disrupts our
                Services or the servers and networks connected to our Services;
                <br />
                d. Attempt to gain unauthorized access to any portion of our
                Services or any other accounts, computer systems, or networks
                connected to our Services.
              </li>
              <li>
                <h3>Use of Company Logos</h3>
                <br />
                By using our Services, you agree that Cap may use your company’s
                name and logo for marketing and promotional purposes, including
                but not limited to displaying your logo on our website,
                presentations, and promotional materials, to indicate you as a
                user or customer of our Services. If you do not wish for your
                company’s name or logo to be used for such purposes, you may opt
                out by contacting us at hello@cap.so.
              </li>
              <li>
                <h3>Privacy</h3>
                <br />
                Your privacy is important to us. Please review our Privacy
                Policy, which is incorporated into these Terms, to understand
                our practices regarding the collection, use, and disclosure of
                personal information.
              </li>
              <li>
                <h3>Termination</h3>
                <br />
                We may terminate or suspend your access to our Services at any
                time, with or without cause or notice, at our sole discretion.
                Upon termination, your right to use our Services will
                immediately cease.
              </li>
              <li>
                <h3>Disclaimer of Warranties</h3>
                <br />
                Our Services are provided "as is" and "as available" without
                warranties of any kind, either express or implied, including but
                not limited to warranties of merchantability, fitness for a
                particular purpose, and non-infringement.
              </li>
              <li>
                <h3>Limitation of Liability</h3>
                <br />
                To the fullest extent permitted by law, Cap shall not be liable
                for any indirect, incidental, special, consequential, or
                punitive damages, or any loss of profits or revenues, whether
                incurred directly or indirectly, or any loss of data, use,
                goodwill, or other intangible losses.
              </li>
              <li>
                <h3>Indemnification</h3>
                <br />
                You agree to defend, indemnify, and hold harmless Cap and its
                affiliates, officers, agents, and employees from and against any
                claims, damages, obligations, losses, liabilities, costs, or
                debt, and expenses (including but not limited to attorney's
                fees) arising from your use of and access to our Services or
                your violation of these Terms.
              </li>
              <li>
                <h3>Governing Law and Jurisdiction</h3>
                <br />
                These Terms shall be governed by and construed in accordance
                with the laws of the State of Delaware, without giving effect to
                any principles of conflicts of law. Any legal action or
                proceeding arising under these Terms will be brought exclusively
                in the federal or state courts located in Dover, Delaware, and
                you consent to personal jurisdiction and venue in such courts.
              </li>
              <li>
                <h3>Changes to These Terms</h3>
                <br />
                We reserve the right, at our sole discretion, to modify or
                replace these Terms at any time. If a revision is material, we
                will provide at least 30 days' notice prior to any new terms
                taking effect. By continuing to access or use our Services after
                any revisions become effective, you agree to be bound by the
                revised terms.
              </li>
              <li>
                <h3>Contact Us</h3>
                <br />
                If you have any questions about these Terms, please contact us
                at hello@cap.so.
              </li>
            </ol>
            <p>Last updated: 24th April 2024</p>
          </>
        </div>
      </div>
    </div>
  );
};
