/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/listers/wildwest/v1alpha1"
)

// CowboyClusterInformer provides access to a shared informer and lister for
// Cowboys.
type CowboyClusterInformer interface {
	Cluster(logicalcluster.Name) CowboyInformer
	ClusterWithContext(context.Context, logicalcluster.Name) CowboyInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.CowboyClusterLister
}

type cowboyClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCowboyClusterInformer constructs a new informer for Cowboy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCowboyClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCowboyClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCowboyClusterInformer constructs a new informer for Cowboy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCowboyClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Cowboys().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Cowboys().Watch(context.Background(), options)
			},
		},
		&kcpwildwestv1alpha1.Cowboy{},
		resyncPeriod,
		indexers,
	)
}

func (i *cowboyClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCowboyClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *cowboyClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpwildwestv1alpha1.Cowboy{}, i.defaultInformer)
}

func (i *cowboyClusterInformer) Lister() kcpv1alpha1.CowboyClusterLister {
	return kcpv1alpha1.NewCowboyClusterLister(i.Informer().GetIndexer())
}

func (i *cowboyClusterInformer) Cluster(clusterName logicalcluster.Name) CowboyInformer {
	return &cowboyInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *cowboyClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) CowboyInformer {
	return &cowboyInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type cowboyInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.CowboyLister
}

func (i *cowboyInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *cowboyInformer) Lister() kcpv1alpha1.CowboyLister {
	return i.lister
}

// CowboyInformer provides access to a shared informer and lister for
// Cowboys.
type CowboyInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.CowboyLister
}

type cowboyScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewCowboyInformer constructs a new informer for Cowboy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCowboyInformer(client kcpversioned.Interface, resyncPeriod time.Duration, namespace string, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredCowboyInformer(client, resyncPeriod, namespace, indexers, nil)
}

// NewFilteredCowboyInformer constructs a new informer for Cowboy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCowboyInformer(client kcpversioned.Interface, resyncPeriod time.Duration, namespace string, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Cowboys(namespace).List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Cowboys(namespace).Watch(context.Background(), options)
			},
		},
		&kcpwildwestv1alpha1.Cowboy{},
		resyncPeriod,
		indexers,
	)
}

func (i *cowboyScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpwildwestv1alpha1.Cowboy{}, i.defaultInformer)
}

func (i *cowboyScopedInformer) Lister() kcpv1alpha1.CowboyLister {
	return kcpv1alpha1.NewCowboyLister(i.Informer().GetIndexer())
}

func (i *cowboyScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredCowboyInformer(client, resyncPeriod, i.namespace, cache.Indexers{
		cache.NamespaceIndex: cache.MetaNamespaceIndexFunc,
	}, i.tweakListOptions)
}
