/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
)

// ShardClusterLister helps list Shards across all workspaces,
// or scope down to a ShardLister for one workspace.
// All objects returned here must be treated as read-only.
type ShardClusterLister interface {
	// List lists all Shards in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Shard, err error)
	// Cluster returns a lister that can list and get Shards in one workspace.
	Cluster(clusterName logicalcluster.Name) ShardLister
	ShardClusterListerExpansion
}

// shardClusterLister implements the ShardClusterLister interface.
type shardClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.Shard]
}

var _ ShardClusterLister = new(shardClusterLister)

// NewShardClusterLister returns a new ShardClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewShardClusterLister(indexer cache.Indexer) ShardClusterLister {
	return &shardClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.Shard](indexer, kcpv1alpha1.Resource("shard")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get Shards.
func (l *shardClusterLister) Cluster(clusterName logicalcluster.Name) ShardLister {
	return &shardLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// shardLister can list all Shards inside a workspace
// or scope down to a ShardNamespaceLister for one namespace.
type shardLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Shard]
}

var _ ShardLister = new(shardLister)

// ShardLister can list all Shards, or get one in particular.
// All objects returned here must be treated as read-only.
type ShardLister interface {
	// List lists all Shards in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Shard, err error)
	// Get retrieves the Shard from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.Shard, error)
	ShardListerExpansion
}

// NewShardLister returns a new ShardLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewShardLister(indexer cache.Indexer) ShardLister {
	return &shardLister{
		kcplisters.New[*kcpv1alpha1.Shard](indexer, kcpv1alpha1.Resource("shard")),
	}
}

// shardScopedLister can list all Shards inside a workspace
// or scope down to a ShardNamespaceLister.
type shardScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Shard]
}
