/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/cache/v1alpha1"
)

// CachedObjectClusterInformer provides access to a shared informer and lister for
// CachedObjects.
type CachedObjectClusterInformer interface {
	Cluster(logicalcluster.Name) CachedObjectInformer
	ClusterWithContext(context.Context, logicalcluster.Name) CachedObjectInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.CachedObjectClusterLister
}

type cachedObjectClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCachedObjectClusterInformer constructs a new informer for CachedObject type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCachedObjectClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCachedObjectClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCachedObjectClusterInformer constructs a new informer for CachedObject type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCachedObjectClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedObjects().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedObjects().Watch(context.Background(), options)
			},
		},
		&kcpcachev1alpha1.CachedObject{},
		resyncPeriod,
		indexers,
	)
}

func (i *cachedObjectClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCachedObjectClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *cachedObjectClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpcachev1alpha1.CachedObject{}, i.defaultInformer)
}

func (i *cachedObjectClusterInformer) Lister() kcpv1alpha1.CachedObjectClusterLister {
	return kcpv1alpha1.NewCachedObjectClusterLister(i.Informer().GetIndexer())
}

func (i *cachedObjectClusterInformer) Cluster(clusterName logicalcluster.Name) CachedObjectInformer {
	return &cachedObjectInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *cachedObjectClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) CachedObjectInformer {
	return &cachedObjectInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type cachedObjectInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.CachedObjectLister
}

func (i *cachedObjectInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *cachedObjectInformer) Lister() kcpv1alpha1.CachedObjectLister {
	return i.lister
}

// CachedObjectInformer provides access to a shared informer and lister for
// CachedObjects.
type CachedObjectInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.CachedObjectLister
}

type cachedObjectScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCachedObjectInformer constructs a new informer for CachedObject type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCachedObjectInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredCachedObjectInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCachedObjectInformer constructs a new informer for CachedObject type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCachedObjectInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedObjects().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedObjects().Watch(context.Background(), options)
			},
		},
		&kcpcachev1alpha1.CachedObject{},
		resyncPeriod,
		indexers,
	)
}

func (i *cachedObjectScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpcachev1alpha1.CachedObject{}, i.defaultInformer)
}

func (i *cachedObjectScopedInformer) Lister() kcpv1alpha1.CachedObjectLister {
	return kcpv1alpha1.NewCachedObjectLister(i.Informer().GetIndexer())
}

func (i *cachedObjectScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredCachedObjectInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
