/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpapisv1alpha2 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha2"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha2 "github.com/kcp-dev/kcp/sdk/client/listers/apis/v1alpha2"
)

// APIExportClusterInformer provides access to a shared informer and lister for
// APIExports.
type APIExportClusterInformer interface {
	Cluster(logicalcluster.Name) APIExportInformer
	ClusterWithContext(context.Context, logicalcluster.Name) APIExportInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha2.APIExportClusterLister
}

type aPIExportClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIExportClusterInformer constructs a new informer for APIExport type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIExportClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIExportClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIExportClusterInformer constructs a new informer for APIExport type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIExportClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha2().APIExports().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha2().APIExports().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha2.APIExport{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIExportClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIExportClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *aPIExportClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha2.APIExport{}, i.defaultInformer)
}

func (i *aPIExportClusterInformer) Lister() kcpv1alpha2.APIExportClusterLister {
	return kcpv1alpha2.NewAPIExportClusterLister(i.Informer().GetIndexer())
}

func (i *aPIExportClusterInformer) Cluster(clusterName logicalcluster.Name) APIExportInformer {
	return &aPIExportInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *aPIExportClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) APIExportInformer {
	return &aPIExportInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type aPIExportInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha2.APIExportLister
}

func (i *aPIExportInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *aPIExportInformer) Lister() kcpv1alpha2.APIExportLister {
	return i.lister
}

// APIExportInformer provides access to a shared informer and lister for
// APIExports.
type APIExportInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha2.APIExportLister
}

type aPIExportScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIExportInformer constructs a new informer for APIExport type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIExportInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAPIExportInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIExportInformer constructs a new informer for APIExport type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIExportInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha2().APIExports().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha2().APIExports().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha2.APIExport{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIExportScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha2.APIExport{}, i.defaultInformer)
}

func (i *aPIExportScopedInformer) Lister() kcpv1alpha2.APIExportLister {
	return kcpv1alpha2.NewAPIExportLister(i.Informer().GetIndexer())
}

func (i *aPIExportScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAPIExportInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
