/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	tenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/tenancy/v1alpha1"
	typedkcptenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/tenancy/v1alpha1"
	typedtenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/tenancy/v1alpha1"
)

// workspaceClusterClient implements WorkspaceClusterInterface
type workspaceClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*tenancyv1alpha1.Workspace, *tenancyv1alpha1.WorkspaceList]
	Fake *kcptesting.Fake
}

func newFakeWorkspaceClusterClient(fake *TenancyV1alpha1ClusterClient) typedkcptenancyv1alpha1.WorkspaceClusterInterface {
	return &workspaceClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*tenancyv1alpha1.Workspace, *tenancyv1alpha1.WorkspaceList](
			fake.Fake,
			tenancyv1alpha1.SchemeGroupVersion.WithResource("workspaces"),
			tenancyv1alpha1.SchemeGroupVersion.WithKind("Workspace"),
			func() *tenancyv1alpha1.Workspace { return &tenancyv1alpha1.Workspace{} },
			func() *tenancyv1alpha1.WorkspaceList { return &tenancyv1alpha1.WorkspaceList{} },
			func(dst, src *tenancyv1alpha1.WorkspaceList) { dst.ListMeta = src.ListMeta },
			func(list *tenancyv1alpha1.WorkspaceList) []*tenancyv1alpha1.Workspace {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *tenancyv1alpha1.WorkspaceList, items []*tenancyv1alpha1.Workspace) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *workspaceClusterClient) Cluster(cluster logicalcluster.Path) typedtenancyv1alpha1.WorkspaceInterface {
	return newFakeWorkspaceClient(c.Fake, cluster)
}

// workspaceScopedClient implements WorkspaceInterface
type workspaceScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*tenancyv1alpha1.Workspace, *tenancyv1alpha1.WorkspaceList, *kcpv1alpha1.WorkspaceApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeWorkspaceClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedtenancyv1alpha1.WorkspaceInterface {
	return &workspaceScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*tenancyv1alpha1.Workspace, *tenancyv1alpha1.WorkspaceList, *kcpv1alpha1.WorkspaceApplyConfiguration](
			fake,
			clusterPath,
			"",
			tenancyv1alpha1.SchemeGroupVersion.WithResource("workspaces"),
			tenancyv1alpha1.SchemeGroupVersion.WithKind("Workspace"),
			func() *tenancyv1alpha1.Workspace { return &tenancyv1alpha1.Workspace{} },
			func() *tenancyv1alpha1.WorkspaceList { return &tenancyv1alpha1.WorkspaceList{} },
			func(dst, src *tenancyv1alpha1.WorkspaceList) { dst.ListMeta = src.ListMeta },
			func(list *tenancyv1alpha1.WorkspaceList) []*tenancyv1alpha1.Workspace {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *tenancyv1alpha1.WorkspaceList, items []*tenancyv1alpha1.Workspace) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
