/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha1"
	typedkcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1"
	typedapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
)

// aPIExportEndpointSliceClusterClient implements APIExportEndpointSliceClusterInterface
type aPIExportEndpointSliceClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*apisv1alpha1.APIExportEndpointSlice, *apisv1alpha1.APIExportEndpointSliceList]
	Fake *kcptesting.Fake
}

func newFakeAPIExportEndpointSliceClusterClient(fake *ApisV1alpha1ClusterClient) typedkcpapisv1alpha1.APIExportEndpointSliceClusterInterface {
	return &aPIExportEndpointSliceClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*apisv1alpha1.APIExportEndpointSlice, *apisv1alpha1.APIExportEndpointSliceList](
			fake.Fake,
			apisv1alpha1.SchemeGroupVersion.WithResource("apiexportendpointslices"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIExportEndpointSlice"),
			func() *apisv1alpha1.APIExportEndpointSlice { return &apisv1alpha1.APIExportEndpointSlice{} },
			func() *apisv1alpha1.APIExportEndpointSliceList { return &apisv1alpha1.APIExportEndpointSliceList{} },
			func(dst, src *apisv1alpha1.APIExportEndpointSliceList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIExportEndpointSliceList) []*apisv1alpha1.APIExportEndpointSlice {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIExportEndpointSliceList, items []*apisv1alpha1.APIExportEndpointSlice) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *aPIExportEndpointSliceClusterClient) Cluster(cluster logicalcluster.Path) typedapisv1alpha1.APIExportEndpointSliceInterface {
	return newFakeAPIExportEndpointSliceClient(c.Fake, cluster)
}

// aPIExportEndpointSliceScopedClient implements APIExportEndpointSliceInterface
type aPIExportEndpointSliceScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*apisv1alpha1.APIExportEndpointSlice, *apisv1alpha1.APIExportEndpointSliceList, *kcpv1alpha1.APIExportEndpointSliceApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeAPIExportEndpointSliceClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedapisv1alpha1.APIExportEndpointSliceInterface {
	return &aPIExportEndpointSliceScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*apisv1alpha1.APIExportEndpointSlice, *apisv1alpha1.APIExportEndpointSliceList, *kcpv1alpha1.APIExportEndpointSliceApplyConfiguration](
			fake,
			clusterPath,
			"",
			apisv1alpha1.SchemeGroupVersion.WithResource("apiexportendpointslices"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIExportEndpointSlice"),
			func() *apisv1alpha1.APIExportEndpointSlice { return &apisv1alpha1.APIExportEndpointSlice{} },
			func() *apisv1alpha1.APIExportEndpointSliceList { return &apisv1alpha1.APIExportEndpointSliceList{} },
			func(dst, src *apisv1alpha1.APIExportEndpointSliceList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIExportEndpointSliceList) []*apisv1alpha1.APIExportEndpointSlice {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIExportEndpointSliceList, items []*apisv1alpha1.APIExportEndpointSlice) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
