/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/listers/wildwest/v1alpha1"
)

// SheriffClusterInformer provides access to a shared informer and lister for
// Sherifves.
type SheriffClusterInformer interface {
	Cluster(logicalcluster.Name) SheriffInformer
	ClusterWithContext(context.Context, logicalcluster.Name) SheriffInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.SheriffClusterLister
}

type sheriffClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewSheriffClusterInformer constructs a new informer for Sheriff type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewSheriffClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredSheriffClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredSheriffClusterInformer constructs a new informer for Sheriff type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredSheriffClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Sherifves().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Sherifves().Watch(context.Background(), options)
			},
		},
		&kcpwildwestv1alpha1.Sheriff{},
		resyncPeriod,
		indexers,
	)
}

func (i *sheriffClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredSheriffClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *sheriffClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpwildwestv1alpha1.Sheriff{}, i.defaultInformer)
}

func (i *sheriffClusterInformer) Lister() kcpv1alpha1.SheriffClusterLister {
	return kcpv1alpha1.NewSheriffClusterLister(i.Informer().GetIndexer())
}

func (i *sheriffClusterInformer) Cluster(clusterName logicalcluster.Name) SheriffInformer {
	return &sheriffInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *sheriffClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) SheriffInformer {
	return &sheriffInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type sheriffInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.SheriffLister
}

func (i *sheriffInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *sheriffInformer) Lister() kcpv1alpha1.SheriffLister {
	return i.lister
}

// SheriffInformer provides access to a shared informer and lister for
// Sherifves.
type SheriffInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.SheriffLister
}

type sheriffScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewSheriffInformer constructs a new informer for Sheriff type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewSheriffInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredSheriffInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredSheriffInformer constructs a new informer for Sheriff type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredSheriffInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Sherifves().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.WildwestV1alpha1().Sherifves().Watch(context.Background(), options)
			},
		},
		&kcpwildwestv1alpha1.Sheriff{},
		resyncPeriod,
		indexers,
	)
}

func (i *sheriffScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpwildwestv1alpha1.Sheriff{}, i.defaultInformer)
}

func (i *sheriffScopedInformer) Lister() kcpv1alpha1.SheriffLister {
	return kcpv1alpha1.NewSheriffLister(i.Informer().GetIndexer())
}

func (i *sheriffScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredSheriffInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
