/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	wildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/applyconfiguration/wildwest/v1alpha1"
	typedkcpwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster/typed/wildwest/v1alpha1"
	typedwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/typed/wildwest/v1alpha1"
)

// cowboyClusterClient implements CowboyClusterInterface
type cowboyClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*wildwestv1alpha1.Cowboy, *wildwestv1alpha1.CowboyList]
	Fake *kcptesting.Fake
}

func newFakeCowboyClusterClient(fake *WildwestV1alpha1ClusterClient) typedkcpwildwestv1alpha1.CowboyClusterInterface {
	return &cowboyClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*wildwestv1alpha1.Cowboy, *wildwestv1alpha1.CowboyList](
			fake.Fake,
			wildwestv1alpha1.SchemeGroupVersion.WithResource("cowboys"),
			wildwestv1alpha1.SchemeGroupVersion.WithKind("Cowboy"),
			func() *wildwestv1alpha1.Cowboy { return &wildwestv1alpha1.Cowboy{} },
			func() *wildwestv1alpha1.CowboyList { return &wildwestv1alpha1.CowboyList{} },
			func(dst, src *wildwestv1alpha1.CowboyList) { dst.ListMeta = src.ListMeta },
			func(list *wildwestv1alpha1.CowboyList) []*wildwestv1alpha1.Cowboy {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *wildwestv1alpha1.CowboyList, items []*wildwestv1alpha1.Cowboy) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *cowboyClusterClient) Cluster(cluster logicalcluster.Path) typedkcpwildwestv1alpha1.CowboysNamespacer {
	return &cowboyNamespacer{Fake: c.Fake, ClusterPath: cluster}
}

type cowboyNamespacer struct {
	*kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func (n *cowboyNamespacer) Namespace(namespace string) typedwildwestv1alpha1.CowboyInterface {
	return newFakeCowboyClient(n.Fake, namespace, n.ClusterPath)
}

// cowboyScopedClient implements CowboyInterface
type cowboyScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*wildwestv1alpha1.Cowboy, *wildwestv1alpha1.CowboyList, *kcpv1alpha1.CowboyApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeCowboyClient(fake *kcptesting.Fake, namespace string, clusterPath logicalcluster.Path) typedwildwestv1alpha1.CowboyInterface {
	return &cowboyScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*wildwestv1alpha1.Cowboy, *wildwestv1alpha1.CowboyList, *kcpv1alpha1.CowboyApplyConfiguration](
			fake,
			clusterPath,
			namespace,
			wildwestv1alpha1.SchemeGroupVersion.WithResource("cowboys"),
			wildwestv1alpha1.SchemeGroupVersion.WithKind("Cowboy"),
			func() *wildwestv1alpha1.Cowboy { return &wildwestv1alpha1.Cowboy{} },
			func() *wildwestv1alpha1.CowboyList { return &wildwestv1alpha1.CowboyList{} },
			func(dst, src *wildwestv1alpha1.CowboyList) { dst.ListMeta = src.ListMeta },
			func(list *wildwestv1alpha1.CowboyList) []*wildwestv1alpha1.Cowboy {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *wildwestv1alpha1.CowboyList, items []*wildwestv1alpha1.Cowboy) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
