/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
)

// PartitionSetClusterLister helps list PartitionSets across all workspaces,
// or scope down to a PartitionSetLister for one workspace.
// All objects returned here must be treated as read-only.
type PartitionSetClusterLister interface {
	// List lists all PartitionSets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.PartitionSet, err error)
	// Cluster returns a lister that can list and get PartitionSets in one workspace.
	Cluster(clusterName logicalcluster.Name) PartitionSetLister
	PartitionSetClusterListerExpansion
}

// partitionSetClusterLister implements the PartitionSetClusterLister interface.
type partitionSetClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.PartitionSet]
}

var _ PartitionSetClusterLister = new(partitionSetClusterLister)

// NewPartitionSetClusterLister returns a new PartitionSetClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewPartitionSetClusterLister(indexer cache.Indexer) PartitionSetClusterLister {
	return &partitionSetClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.PartitionSet](indexer, kcpv1alpha1.Resource("partitionset")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get PartitionSets.
func (l *partitionSetClusterLister) Cluster(clusterName logicalcluster.Name) PartitionSetLister {
	return &partitionSetLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// partitionSetLister can list all PartitionSets inside a workspace
// or scope down to a PartitionSetNamespaceLister for one namespace.
type partitionSetLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.PartitionSet]
}

var _ PartitionSetLister = new(partitionSetLister)

// PartitionSetLister can list all PartitionSets, or get one in particular.
// All objects returned here must be treated as read-only.
type PartitionSetLister interface {
	// List lists all PartitionSets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.PartitionSet, err error)
	// Get retrieves the PartitionSet from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.PartitionSet, error)
	PartitionSetListerExpansion
}

// NewPartitionSetLister returns a new PartitionSetLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewPartitionSetLister(indexer cache.Indexer) PartitionSetLister {
	return &partitionSetLister{
		kcplisters.New[*kcpv1alpha1.PartitionSet](indexer, kcpv1alpha1.Resource("partitionset")),
	}
}

// partitionSetScopedLister can list all PartitionSets inside a workspace
// or scope down to a PartitionSetNamespaceLister.
type partitionSetScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.PartitionSet]
}
