/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
)

// PartitionClusterLister helps list Partitions across all workspaces,
// or scope down to a PartitionLister for one workspace.
// All objects returned here must be treated as read-only.
type PartitionClusterLister interface {
	// List lists all Partitions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Partition, err error)
	// Cluster returns a lister that can list and get Partitions in one workspace.
	Cluster(clusterName logicalcluster.Name) PartitionLister
	PartitionClusterListerExpansion
}

// partitionClusterLister implements the PartitionClusterLister interface.
type partitionClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.Partition]
}

var _ PartitionClusterLister = new(partitionClusterLister)

// NewPartitionClusterLister returns a new PartitionClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewPartitionClusterLister(indexer cache.Indexer) PartitionClusterLister {
	return &partitionClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.Partition](indexer, kcpv1alpha1.Resource("partition")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get Partitions.
func (l *partitionClusterLister) Cluster(clusterName logicalcluster.Name) PartitionLister {
	return &partitionLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// partitionLister can list all Partitions inside a workspace
// or scope down to a PartitionNamespaceLister for one namespace.
type partitionLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Partition]
}

var _ PartitionLister = new(partitionLister)

// PartitionLister can list all Partitions, or get one in particular.
// All objects returned here must be treated as read-only.
type PartitionLister interface {
	// List lists all Partitions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Partition, err error)
	// Get retrieves the Partition from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.Partition, error)
	PartitionListerExpansion
}

// NewPartitionLister returns a new PartitionLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewPartitionLister(indexer cache.Indexer) PartitionLister {
	return &partitionLister{
		kcplisters.New[*kcpv1alpha1.Partition](indexer, kcpv1alpha1.Resource("partition")),
	}
}

// partitionScopedLister can list all Partitions inside a workspace
// or scope down to a PartitionNamespaceLister.
type partitionScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Partition]
}
