/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
)

// WorkspaceTypeClusterLister helps list WorkspaceTypes across all workspaces,
// or scope down to a WorkspaceTypeLister for one workspace.
// All objects returned here must be treated as read-only.
type WorkspaceTypeClusterLister interface {
	// List lists all WorkspaceTypes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.WorkspaceType, err error)
	// Cluster returns a lister that can list and get WorkspaceTypes in one workspace.
	Cluster(clusterName logicalcluster.Name) WorkspaceTypeLister
	WorkspaceTypeClusterListerExpansion
}

// workspaceTypeClusterLister implements the WorkspaceTypeClusterLister interface.
type workspaceTypeClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.WorkspaceType]
}

var _ WorkspaceTypeClusterLister = new(workspaceTypeClusterLister)

// NewWorkspaceTypeClusterLister returns a new WorkspaceTypeClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewWorkspaceTypeClusterLister(indexer cache.Indexer) WorkspaceTypeClusterLister {
	return &workspaceTypeClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.WorkspaceType](indexer, kcpv1alpha1.Resource("workspacetype")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get WorkspaceTypes.
func (l *workspaceTypeClusterLister) Cluster(clusterName logicalcluster.Name) WorkspaceTypeLister {
	return &workspaceTypeLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// workspaceTypeLister can list all WorkspaceTypes inside a workspace
// or scope down to a WorkspaceTypeNamespaceLister for one namespace.
type workspaceTypeLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.WorkspaceType]
}

var _ WorkspaceTypeLister = new(workspaceTypeLister)

// WorkspaceTypeLister can list all WorkspaceTypes, or get one in particular.
// All objects returned here must be treated as read-only.
type WorkspaceTypeLister interface {
	// List lists all WorkspaceTypes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.WorkspaceType, err error)
	// Get retrieves the WorkspaceType from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.WorkspaceType, error)
	WorkspaceTypeListerExpansion
}

// NewWorkspaceTypeLister returns a new WorkspaceTypeLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewWorkspaceTypeLister(indexer cache.Indexer) WorkspaceTypeLister {
	return &workspaceTypeLister{
		kcplisters.New[*kcpv1alpha1.WorkspaceType](indexer, kcpv1alpha1.Resource("workspacetype")),
	}
}

// workspaceTypeScopedLister can list all WorkspaceTypes inside a workspace
// or scope down to a WorkspaceTypeNamespaceLister.
type workspaceTypeScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.WorkspaceType]
}
