/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
)

// APIResourceSchemaClusterLister helps list APIResourceSchemas across all workspaces,
// or scope down to a APIResourceSchemaLister for one workspace.
// All objects returned here must be treated as read-only.
type APIResourceSchemaClusterLister interface {
	// List lists all APIResourceSchemas in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIResourceSchema, err error)
	// Cluster returns a lister that can list and get APIResourceSchemas in one workspace.
	Cluster(clusterName logicalcluster.Name) APIResourceSchemaLister
	APIResourceSchemaClusterListerExpansion
}

// aPIResourceSchemaClusterLister implements the APIResourceSchemaClusterLister interface.
type aPIResourceSchemaClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.APIResourceSchema]
}

var _ APIResourceSchemaClusterLister = new(aPIResourceSchemaClusterLister)

// NewAPIResourceSchemaClusterLister returns a new APIResourceSchemaClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIResourceSchemaClusterLister(indexer cache.Indexer) APIResourceSchemaClusterLister {
	return &aPIResourceSchemaClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.APIResourceSchema](indexer, kcpv1alpha1.Resource("apiresourceschema")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get APIResourceSchemas.
func (l *aPIResourceSchemaClusterLister) Cluster(clusterName logicalcluster.Name) APIResourceSchemaLister {
	return &aPIResourceSchemaLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// aPIResourceSchemaLister can list all APIResourceSchemas inside a workspace
// or scope down to a APIResourceSchemaNamespaceLister for one namespace.
type aPIResourceSchemaLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIResourceSchema]
}

var _ APIResourceSchemaLister = new(aPIResourceSchemaLister)

// APIResourceSchemaLister can list all APIResourceSchemas, or get one in particular.
// All objects returned here must be treated as read-only.
type APIResourceSchemaLister interface {
	// List lists all APIResourceSchemas in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIResourceSchema, err error)
	// Get retrieves the APIResourceSchema from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.APIResourceSchema, error)
	APIResourceSchemaListerExpansion
}

// NewAPIResourceSchemaLister returns a new APIResourceSchemaLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIResourceSchemaLister(indexer cache.Indexer) APIResourceSchemaLister {
	return &aPIResourceSchemaLister{
		kcplisters.New[*kcpv1alpha1.APIResourceSchema](indexer, kcpv1alpha1.Resource("apiresourceschema")),
	}
}

// aPIResourceSchemaScopedLister can list all APIResourceSchemas inside a workspace
// or scope down to a APIResourceSchemaNamespaceLister.
type aPIResourceSchemaScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIResourceSchema]
}
