/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
)

// APIExportClusterLister helps list APIExports across all workspaces,
// or scope down to a APIExportLister for one workspace.
// All objects returned here must be treated as read-only.
type APIExportClusterLister interface {
	// List lists all APIExports in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIExport, err error)
	// Cluster returns a lister that can list and get APIExports in one workspace.
	Cluster(clusterName logicalcluster.Name) APIExportLister
	APIExportClusterListerExpansion
}

// aPIExportClusterLister implements the APIExportClusterLister interface.
type aPIExportClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.APIExport]
}

var _ APIExportClusterLister = new(aPIExportClusterLister)

// NewAPIExportClusterLister returns a new APIExportClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIExportClusterLister(indexer cache.Indexer) APIExportClusterLister {
	return &aPIExportClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.APIExport](indexer, kcpv1alpha1.Resource("apiexport")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get APIExports.
func (l *aPIExportClusterLister) Cluster(clusterName logicalcluster.Name) APIExportLister {
	return &aPIExportLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// aPIExportLister can list all APIExports inside a workspace
// or scope down to a APIExportNamespaceLister for one namespace.
type aPIExportLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIExport]
}

var _ APIExportLister = new(aPIExportLister)

// APIExportLister can list all APIExports, or get one in particular.
// All objects returned here must be treated as read-only.
type APIExportLister interface {
	// List lists all APIExports in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIExport, err error)
	// Get retrieves the APIExport from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.APIExport, error)
	APIExportListerExpansion
}

// NewAPIExportLister returns a new APIExportLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIExportLister(indexer cache.Indexer) APIExportLister {
	return &aPIExportLister{
		kcplisters.New[*kcpv1alpha1.APIExport](indexer, kcpv1alpha1.Resource("apiexport")),
	}
}

// aPIExportScopedLister can list all APIExports inside a workspace
// or scope down to a APIExportNamespaceLister.
type aPIExportScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIExport]
}
