/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
)

// APIConversionClusterLister helps list APIConversions across all workspaces,
// or scope down to a APIConversionLister for one workspace.
// All objects returned here must be treated as read-only.
type APIConversionClusterLister interface {
	// List lists all APIConversions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIConversion, err error)
	// Cluster returns a lister that can list and get APIConversions in one workspace.
	Cluster(clusterName logicalcluster.Name) APIConversionLister
	APIConversionClusterListerExpansion
}

// aPIConversionClusterLister implements the APIConversionClusterLister interface.
type aPIConversionClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.APIConversion]
}

var _ APIConversionClusterLister = new(aPIConversionClusterLister)

// NewAPIConversionClusterLister returns a new APIConversionClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIConversionClusterLister(indexer cache.Indexer) APIConversionClusterLister {
	return &aPIConversionClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.APIConversion](indexer, kcpv1alpha1.Resource("apiconversion")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get APIConversions.
func (l *aPIConversionClusterLister) Cluster(clusterName logicalcluster.Name) APIConversionLister {
	return &aPIConversionLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// aPIConversionLister can list all APIConversions inside a workspace
// or scope down to a APIConversionNamespaceLister for one namespace.
type aPIConversionLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIConversion]
}

var _ APIConversionLister = new(aPIConversionLister)

// APIConversionLister can list all APIConversions, or get one in particular.
// All objects returned here must be treated as read-only.
type APIConversionLister interface {
	// List lists all APIConversions in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIConversion, err error)
	// Get retrieves the APIConversion from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.APIConversion, error)
	APIConversionListerExpansion
}

// NewAPIConversionLister returns a new APIConversionLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIConversionLister(indexer cache.Indexer) APIConversionLister {
	return &aPIConversionLister{
		kcplisters.New[*kcpv1alpha1.APIConversion](indexer, kcpv1alpha1.Resource("apiconversion")),
	}
}

// aPIConversionScopedLister can list all APIConversions inside a workspace
// or scope down to a APIConversionNamespaceLister.
type aPIConversionScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIConversion]
}
