/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcptenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/tenancy/v1alpha1"
)

// WorkspaceClusterInformer provides access to a shared informer and lister for
// Workspaces.
type WorkspaceClusterInformer interface {
	Cluster(logicalcluster.Name) WorkspaceInformer
	ClusterWithContext(context.Context, logicalcluster.Name) WorkspaceInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.WorkspaceClusterLister
}

type workspaceClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewWorkspaceClusterInformer constructs a new informer for Workspace type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewWorkspaceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredWorkspaceClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredWorkspaceClusterInformer constructs a new informer for Workspace type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredWorkspaceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().Workspaces().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().Workspaces().Watch(context.Background(), options)
			},
		},
		&kcptenancyv1alpha1.Workspace{},
		resyncPeriod,
		indexers,
	)
}

func (i *workspaceClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredWorkspaceClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *workspaceClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcptenancyv1alpha1.Workspace{}, i.defaultInformer)
}

func (i *workspaceClusterInformer) Lister() kcpv1alpha1.WorkspaceClusterLister {
	return kcpv1alpha1.NewWorkspaceClusterLister(i.Informer().GetIndexer())
}

func (i *workspaceClusterInformer) Cluster(clusterName logicalcluster.Name) WorkspaceInformer {
	return &workspaceInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *workspaceClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) WorkspaceInformer {
	return &workspaceInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type workspaceInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.WorkspaceLister
}

func (i *workspaceInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *workspaceInformer) Lister() kcpv1alpha1.WorkspaceLister {
	return i.lister
}

// WorkspaceInformer provides access to a shared informer and lister for
// Workspaces.
type WorkspaceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.WorkspaceLister
}

type workspaceScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewWorkspaceInformer constructs a new informer for Workspace type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewWorkspaceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredWorkspaceInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredWorkspaceInformer constructs a new informer for Workspace type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredWorkspaceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().Workspaces().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().Workspaces().Watch(context.Background(), options)
			},
		},
		&kcptenancyv1alpha1.Workspace{},
		resyncPeriod,
		indexers,
	)
}

func (i *workspaceScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcptenancyv1alpha1.Workspace{}, i.defaultInformer)
}

func (i *workspaceScopedInformer) Lister() kcpv1alpha1.WorkspaceLister {
	return kcpv1alpha1.NewWorkspaceLister(i.Informer().GetIndexer())
}

func (i *workspaceScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredWorkspaceInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
