/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package externalversions

import (
	context "context"
	fmt "fmt"

	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha2 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha2"
	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	kcptenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
	kcptopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
)

type GenericClusterInformer interface {
	Cluster(logicalcluster.Name) GenericInformer
	ClusterWithContext(context.Context, logicalcluster.Name) GenericInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpcache.GenericClusterLister
}

type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericClusterInformer struct {
	informer kcpcache.ScopeableSharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (i *genericClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.informer
}

// Lister returns the GenericLister.
func (i *genericClusterInformer) Lister() kcpcache.GenericClusterLister {
	return kcpcache.NewGenericClusterLister(i.Informer().GetIndexer(), i.resource)
}

// Cluster scopes to a GenericInformer.
func (i *genericClusterInformer) Cluster(clusterName logicalcluster.Name) GenericInformer {
	return &genericInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().ByCluster(clusterName),
	}
}

// ClusterWithContext scopes to a GenericInformer and unregisters all
// handles registered through it once the provided context is canceled.
func (i *genericClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) GenericInformer {
	return &genericInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().ByCluster(clusterName),
	}
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	lister   cache.GenericLister
}

// Informer returns the SharedIndexInformer.
func (i *genericInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

// Lister returns the GenericLister.
func (i *genericInformer) Lister() cache.GenericLister {
	return i.lister
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericClusterInformer, error) {
	switch resource {
	// Group=apis.kcp.io, Version=v1alpha1
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apibindings"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha1().APIBindings().Informer()}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiconversions"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha1().APIConversions().Informer()}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiexports"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha1().APIExports().Informer()}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiexportendpointslices"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha1().APIExportEndpointSlices().Informer()}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiresourceschemas"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha1().APIResourceSchemas().Informer()}, nil

		// Group=apis.kcp.io, Version=v1alpha2
	case kcpv1alpha2.SchemeGroupVersion.WithResource("apibindings"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha2().APIBindings().Informer()}, nil
	case kcpv1alpha2.SchemeGroupVersion.WithResource("apiexports"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Apis().V1alpha2().APIExports().Informer()}, nil

		// Group=cache.kcp.io, Version=v1alpha1
	case kcpcachev1alpha1.SchemeGroupVersion.WithResource("cachedobjects"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Cache().V1alpha1().CachedObjects().Informer()}, nil
	case kcpcachev1alpha1.SchemeGroupVersion.WithResource("cachedresources"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Cache().V1alpha1().CachedResources().Informer()}, nil
	case kcpcachev1alpha1.SchemeGroupVersion.WithResource("cachedresourceendpointslices"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Cache().V1alpha1().CachedResourceEndpointSlices().Informer()}, nil

		// Group=core.kcp.io, Version=v1alpha1
	case kcpcorev1alpha1.SchemeGroupVersion.WithResource("logicalclusters"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Core().V1alpha1().LogicalClusters().Informer()}, nil
	case kcpcorev1alpha1.SchemeGroupVersion.WithResource("shards"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Core().V1alpha1().Shards().Informer()}, nil

		// Group=tenancy.kcp.io, Version=v1alpha1
	case kcptenancyv1alpha1.SchemeGroupVersion.WithResource("workspaces"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Tenancy().V1alpha1().Workspaces().Informer()}, nil
	case kcptenancyv1alpha1.SchemeGroupVersion.WithResource("workspacetypes"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Tenancy().V1alpha1().WorkspaceTypes().Informer()}, nil

		// Group=topology.kcp.io, Version=v1alpha1
	case kcptopologyv1alpha1.SchemeGroupVersion.WithResource("partitions"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Topology().V1alpha1().Partitions().Informer()}, nil
	case kcptopologyv1alpha1.SchemeGroupVersion.WithResource("partitionsets"):
		return &genericClusterInformer{resource: resource.GroupResource(), informer: f.Topology().V1alpha1().PartitionSets().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedScopedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=apis.kcp.io, Version=v1alpha1
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apibindings"):
		informer := f.Apis().V1alpha1().APIBindings().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiconversions"):
		informer := f.Apis().V1alpha1().APIConversions().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiexports"):
		informer := f.Apis().V1alpha1().APIExports().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiexportendpointslices"):
		informer := f.Apis().V1alpha1().APIExportEndpointSlices().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpv1alpha1.SchemeGroupVersion.WithResource("apiresourceschemas"):
		informer := f.Apis().V1alpha1().APIResourceSchemas().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil

		// Group=apis.kcp.io, Version=v1alpha2
	case kcpv1alpha2.SchemeGroupVersion.WithResource("apibindings"):
		informer := f.Apis().V1alpha2().APIBindings().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpv1alpha2.SchemeGroupVersion.WithResource("apiexports"):
		informer := f.Apis().V1alpha2().APIExports().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil

		// Group=cache.kcp.io, Version=v1alpha1
	case kcpcachev1alpha1.SchemeGroupVersion.WithResource("cachedobjects"):
		informer := f.Cache().V1alpha1().CachedObjects().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpcachev1alpha1.SchemeGroupVersion.WithResource("cachedresources"):
		informer := f.Cache().V1alpha1().CachedResources().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpcachev1alpha1.SchemeGroupVersion.WithResource("cachedresourceendpointslices"):
		informer := f.Cache().V1alpha1().CachedResourceEndpointSlices().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil

		// Group=core.kcp.io, Version=v1alpha1
	case kcpcorev1alpha1.SchemeGroupVersion.WithResource("logicalclusters"):
		informer := f.Core().V1alpha1().LogicalClusters().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcpcorev1alpha1.SchemeGroupVersion.WithResource("shards"):
		informer := f.Core().V1alpha1().Shards().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil

		// Group=tenancy.kcp.io, Version=v1alpha1
	case kcptenancyv1alpha1.SchemeGroupVersion.WithResource("workspaces"):
		informer := f.Tenancy().V1alpha1().Workspaces().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcptenancyv1alpha1.SchemeGroupVersion.WithResource("workspacetypes"):
		informer := f.Tenancy().V1alpha1().WorkspaceTypes().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil

		// Group=topology.kcp.io, Version=v1alpha1
	case kcptopologyv1alpha1.SchemeGroupVersion.WithResource("partitions"):
		informer := f.Topology().V1alpha1().Partitions().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil
	case kcptopologyv1alpha1.SchemeGroupVersion.WithResource("partitionsets"):
		informer := f.Topology().V1alpha1().PartitionSets().Informer()
		return &genericInformer{lister: cache.NewGenericLister(informer.GetIndexer(), resource.GroupResource()), informer: informer}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
