/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/core/v1alpha1"
)

// LogicalClusterClusterInformer provides access to a shared informer and lister for
// LogicalClusters.
type LogicalClusterClusterInformer interface {
	Cluster(logicalcluster.Name) LogicalClusterInformer
	ClusterWithContext(context.Context, logicalcluster.Name) LogicalClusterInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.LogicalClusterClusterLister
}

type logicalClusterClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewLogicalClusterClusterInformer constructs a new informer for LogicalCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewLogicalClusterClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredLogicalClusterClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredLogicalClusterClusterInformer constructs a new informer for LogicalCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredLogicalClusterClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().LogicalClusters().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().LogicalClusters().Watch(context.Background(), options)
			},
		},
		&kcpcorev1alpha1.LogicalCluster{},
		resyncPeriod,
		indexers,
	)
}

func (i *logicalClusterClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredLogicalClusterClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *logicalClusterClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpcorev1alpha1.LogicalCluster{}, i.defaultInformer)
}

func (i *logicalClusterClusterInformer) Lister() kcpv1alpha1.LogicalClusterClusterLister {
	return kcpv1alpha1.NewLogicalClusterClusterLister(i.Informer().GetIndexer())
}

func (i *logicalClusterClusterInformer) Cluster(clusterName logicalcluster.Name) LogicalClusterInformer {
	return &logicalClusterInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *logicalClusterClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) LogicalClusterInformer {
	return &logicalClusterInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type logicalClusterInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.LogicalClusterLister
}

func (i *logicalClusterInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *logicalClusterInformer) Lister() kcpv1alpha1.LogicalClusterLister {
	return i.lister
}

// LogicalClusterInformer provides access to a shared informer and lister for
// LogicalClusters.
type LogicalClusterInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.LogicalClusterLister
}

type logicalClusterScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewLogicalClusterInformer constructs a new informer for LogicalCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewLogicalClusterInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredLogicalClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredLogicalClusterInformer constructs a new informer for LogicalCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredLogicalClusterInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().LogicalClusters().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().LogicalClusters().Watch(context.Background(), options)
			},
		},
		&kcpcorev1alpha1.LogicalCluster{},
		resyncPeriod,
		indexers,
	)
}

func (i *logicalClusterScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpcorev1alpha1.LogicalCluster{}, i.defaultInformer)
}

func (i *logicalClusterScopedInformer) Lister() kcpv1alpha1.LogicalClusterLister {
	return kcpv1alpha1.NewLogicalClusterLister(i.Informer().GetIndexer())
}

func (i *logicalClusterScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredLogicalClusterInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
