/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
)

type ClusterInterface interface {
	// CachedObjects returns a CachedObjectClusterInformer.
	CachedObjects() CachedObjectClusterInformer
	// CachedResources returns a CachedResourceClusterInformer.
	CachedResources() CachedResourceClusterInformer
	// CachedResourceEndpointSlices returns a CachedResourceEndpointSliceClusterInformer.
	CachedResourceEndpointSlices() CachedResourceEndpointSliceClusterInformer
}

type version struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &version{factory: f, tweakListOptions: tweakListOptions}
}

// CachedObjects returns a CachedObjectClusterInformer.
func (v *version) CachedObjects() CachedObjectClusterInformer {
	return &cachedObjectClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// CachedResources returns a CachedResourceClusterInformer.
func (v *version) CachedResources() CachedResourceClusterInformer {
	return &cachedResourceClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// CachedResourceEndpointSlices returns a CachedResourceEndpointSliceClusterInformer.
func (v *version) CachedResourceEndpointSlices() CachedResourceEndpointSliceClusterInformer {
	return &cachedResourceEndpointSliceClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

type Interface interface {
	// CachedObjects returns a CachedObjectInformer.
	CachedObjects() CachedObjectInformer
	// CachedResources returns a CachedResourceInformer.
	CachedResources() CachedResourceInformer
	// CachedResourceEndpointSlices returns a CachedResourceEndpointSliceInformer.
	CachedResourceEndpointSlices() CachedResourceEndpointSliceInformer
}

type scopedVersion struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedVersion{factory: f, tweakListOptions: tweakListOptions}
}

// CachedObjects returns a CachedObjectInformer.
func (v *scopedVersion) CachedObjects() CachedObjectInformer {
	return &cachedObjectScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// CachedResources returns a CachedResourceInformer.
func (v *scopedVersion) CachedResources() CachedResourceInformer {
	return &cachedResourceScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// CachedResourceEndpointSlices returns a CachedResourceEndpointSliceInformer.
func (v *scopedVersion) CachedResourceEndpointSlices() CachedResourceEndpointSliceInformer {
	return &cachedResourceEndpointSliceScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}
