/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/cache/v1alpha1"
)

// CachedResourceEndpointSliceClusterInformer provides access to a shared informer and lister for
// CachedResourceEndpointSlices.
type CachedResourceEndpointSliceClusterInformer interface {
	Cluster(logicalcluster.Name) CachedResourceEndpointSliceInformer
	ClusterWithContext(context.Context, logicalcluster.Name) CachedResourceEndpointSliceInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.CachedResourceEndpointSliceClusterLister
}

type cachedResourceEndpointSliceClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCachedResourceEndpointSliceClusterInformer constructs a new informer for CachedResourceEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCachedResourceEndpointSliceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCachedResourceEndpointSliceClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCachedResourceEndpointSliceClusterInformer constructs a new informer for CachedResourceEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCachedResourceEndpointSliceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResourceEndpointSlices().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResourceEndpointSlices().Watch(context.Background(), options)
			},
		},
		&kcpcachev1alpha1.CachedResourceEndpointSlice{},
		resyncPeriod,
		indexers,
	)
}

func (i *cachedResourceEndpointSliceClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCachedResourceEndpointSliceClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *cachedResourceEndpointSliceClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpcachev1alpha1.CachedResourceEndpointSlice{}, i.defaultInformer)
}

func (i *cachedResourceEndpointSliceClusterInformer) Lister() kcpv1alpha1.CachedResourceEndpointSliceClusterLister {
	return kcpv1alpha1.NewCachedResourceEndpointSliceClusterLister(i.Informer().GetIndexer())
}

func (i *cachedResourceEndpointSliceClusterInformer) Cluster(clusterName logicalcluster.Name) CachedResourceEndpointSliceInformer {
	return &cachedResourceEndpointSliceInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *cachedResourceEndpointSliceClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) CachedResourceEndpointSliceInformer {
	return &cachedResourceEndpointSliceInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type cachedResourceEndpointSliceInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.CachedResourceEndpointSliceLister
}

func (i *cachedResourceEndpointSliceInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *cachedResourceEndpointSliceInformer) Lister() kcpv1alpha1.CachedResourceEndpointSliceLister {
	return i.lister
}

// CachedResourceEndpointSliceInformer provides access to a shared informer and lister for
// CachedResourceEndpointSlices.
type CachedResourceEndpointSliceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.CachedResourceEndpointSliceLister
}

type cachedResourceEndpointSliceScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCachedResourceEndpointSliceInformer constructs a new informer for CachedResourceEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCachedResourceEndpointSliceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredCachedResourceEndpointSliceInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCachedResourceEndpointSliceInformer constructs a new informer for CachedResourceEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCachedResourceEndpointSliceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResourceEndpointSlices().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResourceEndpointSlices().Watch(context.Background(), options)
			},
		},
		&kcpcachev1alpha1.CachedResourceEndpointSlice{},
		resyncPeriod,
		indexers,
	)
}

func (i *cachedResourceEndpointSliceScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpcachev1alpha1.CachedResourceEndpointSlice{}, i.defaultInformer)
}

func (i *cachedResourceEndpointSliceScopedInformer) Lister() kcpv1alpha1.CachedResourceEndpointSliceLister {
	return kcpv1alpha1.NewCachedResourceEndpointSliceLister(i.Informer().GetIndexer())
}

func (i *cachedResourceEndpointSliceScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredCachedResourceEndpointSliceInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
