/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/apis/v1alpha1"
)

// APIResourceSchemaClusterInformer provides access to a shared informer and lister for
// APIResourceSchemas.
type APIResourceSchemaClusterInformer interface {
	Cluster(logicalcluster.Name) APIResourceSchemaInformer
	ClusterWithContext(context.Context, logicalcluster.Name) APIResourceSchemaInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.APIResourceSchemaClusterLister
}

type aPIResourceSchemaClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIResourceSchemaClusterInformer constructs a new informer for APIResourceSchema type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIResourceSchemaClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIResourceSchemaClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIResourceSchemaClusterInformer constructs a new informer for APIResourceSchema type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIResourceSchemaClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIResourceSchemas().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIResourceSchemas().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIResourceSchema{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIResourceSchemaClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIResourceSchemaClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *aPIResourceSchemaClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIResourceSchema{}, i.defaultInformer)
}

func (i *aPIResourceSchemaClusterInformer) Lister() kcpv1alpha1.APIResourceSchemaClusterLister {
	return kcpv1alpha1.NewAPIResourceSchemaClusterLister(i.Informer().GetIndexer())
}

func (i *aPIResourceSchemaClusterInformer) Cluster(clusterName logicalcluster.Name) APIResourceSchemaInformer {
	return &aPIResourceSchemaInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *aPIResourceSchemaClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) APIResourceSchemaInformer {
	return &aPIResourceSchemaInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type aPIResourceSchemaInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.APIResourceSchemaLister
}

func (i *aPIResourceSchemaInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *aPIResourceSchemaInformer) Lister() kcpv1alpha1.APIResourceSchemaLister {
	return i.lister
}

// APIResourceSchemaInformer provides access to a shared informer and lister for
// APIResourceSchemas.
type APIResourceSchemaInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.APIResourceSchemaLister
}

type aPIResourceSchemaScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIResourceSchemaInformer constructs a new informer for APIResourceSchema type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIResourceSchemaInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAPIResourceSchemaInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIResourceSchemaInformer constructs a new informer for APIResourceSchema type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIResourceSchemaInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIResourceSchemas().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIResourceSchemas().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIResourceSchema{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIResourceSchemaScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIResourceSchema{}, i.defaultInformer)
}

func (i *aPIResourceSchemaScopedInformer) Lister() kcpv1alpha1.APIResourceSchemaLister {
	return kcpv1alpha1.NewAPIResourceSchemaLister(i.Informer().GetIndexer())
}

func (i *aPIResourceSchemaScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAPIResourceSchemaInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
