/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/apis/v1alpha1"
)

// APIExportEndpointSliceClusterInformer provides access to a shared informer and lister for
// APIExportEndpointSlices.
type APIExportEndpointSliceClusterInformer interface {
	Cluster(logicalcluster.Name) APIExportEndpointSliceInformer
	ClusterWithContext(context.Context, logicalcluster.Name) APIExportEndpointSliceInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.APIExportEndpointSliceClusterLister
}

type aPIExportEndpointSliceClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIExportEndpointSliceClusterInformer constructs a new informer for APIExportEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIExportEndpointSliceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIExportEndpointSliceClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIExportEndpointSliceClusterInformer constructs a new informer for APIExportEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIExportEndpointSliceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIExportEndpointSlices().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIExportEndpointSlices().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIExportEndpointSlice{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIExportEndpointSliceClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIExportEndpointSliceClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *aPIExportEndpointSliceClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIExportEndpointSlice{}, i.defaultInformer)
}

func (i *aPIExportEndpointSliceClusterInformer) Lister() kcpv1alpha1.APIExportEndpointSliceClusterLister {
	return kcpv1alpha1.NewAPIExportEndpointSliceClusterLister(i.Informer().GetIndexer())
}

func (i *aPIExportEndpointSliceClusterInformer) Cluster(clusterName logicalcluster.Name) APIExportEndpointSliceInformer {
	return &aPIExportEndpointSliceInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *aPIExportEndpointSliceClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) APIExportEndpointSliceInformer {
	return &aPIExportEndpointSliceInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type aPIExportEndpointSliceInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.APIExportEndpointSliceLister
}

func (i *aPIExportEndpointSliceInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *aPIExportEndpointSliceInformer) Lister() kcpv1alpha1.APIExportEndpointSliceLister {
	return i.lister
}

// APIExportEndpointSliceInformer provides access to a shared informer and lister for
// APIExportEndpointSlices.
type APIExportEndpointSliceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.APIExportEndpointSliceLister
}

type aPIExportEndpointSliceScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIExportEndpointSliceInformer constructs a new informer for APIExportEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIExportEndpointSliceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAPIExportEndpointSliceInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIExportEndpointSliceInformer constructs a new informer for APIExportEndpointSlice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIExportEndpointSliceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIExportEndpointSlices().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIExportEndpointSlices().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIExportEndpointSlice{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIExportEndpointSliceScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIExportEndpointSlice{}, i.defaultInformer)
}

func (i *aPIExportEndpointSliceScopedInformer) Lister() kcpv1alpha1.APIExportEndpointSliceLister {
	return kcpv1alpha1.NewAPIExportEndpointSliceLister(i.Informer().GetIndexer())
}

func (i *aPIExportEndpointSliceScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAPIExportEndpointSliceInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
