/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/apis/v1alpha1"
)

// APIConversionClusterInformer provides access to a shared informer and lister for
// APIConversions.
type APIConversionClusterInformer interface {
	Cluster(logicalcluster.Name) APIConversionInformer
	ClusterWithContext(context.Context, logicalcluster.Name) APIConversionInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.APIConversionClusterLister
}

type aPIConversionClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIConversionClusterInformer constructs a new informer for APIConversion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIConversionClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIConversionClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIConversionClusterInformer constructs a new informer for APIConversion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIConversionClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIConversions().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIConversions().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIConversion{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIConversionClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIConversionClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *aPIConversionClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIConversion{}, i.defaultInformer)
}

func (i *aPIConversionClusterInformer) Lister() kcpv1alpha1.APIConversionClusterLister {
	return kcpv1alpha1.NewAPIConversionClusterLister(i.Informer().GetIndexer())
}

func (i *aPIConversionClusterInformer) Cluster(clusterName logicalcluster.Name) APIConversionInformer {
	return &aPIConversionInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *aPIConversionClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) APIConversionInformer {
	return &aPIConversionInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type aPIConversionInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.APIConversionLister
}

func (i *aPIConversionInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *aPIConversionInformer) Lister() kcpv1alpha1.APIConversionLister {
	return i.lister
}

// APIConversionInformer provides access to a shared informer and lister for
// APIConversions.
type APIConversionInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.APIConversionLister
}

type aPIConversionScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIConversionInformer constructs a new informer for APIConversion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIConversionInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAPIConversionInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIConversionInformer constructs a new informer for APIConversion type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIConversionInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIConversions().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIConversions().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIConversion{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIConversionScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIConversion{}, i.defaultInformer)
}

func (i *aPIConversionScopedInformer) Lister() kcpv1alpha1.APIConversionLister {
	return kcpv1alpha1.NewAPIConversionLister(i.Informer().GetIndexer())
}

func (i *aPIConversionScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAPIConversionInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
