/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	topologyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
	applyconfigurationtopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/topology/v1alpha1"
	scheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/scheme"
)

// PartitionsGetter has a method to return a PartitionInterface.
// A group's client should implement this interface.
type PartitionsGetter interface {
	Partitions() PartitionInterface
}

// PartitionInterface has methods to work with Partition resources.
type PartitionInterface interface {
	Create(ctx context.Context, partition *topologyv1alpha1.Partition, opts v1.CreateOptions) (*topologyv1alpha1.Partition, error)
	Update(ctx context.Context, partition *topologyv1alpha1.Partition, opts v1.UpdateOptions) (*topologyv1alpha1.Partition, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*topologyv1alpha1.Partition, error)
	List(ctx context.Context, opts v1.ListOptions) (*topologyv1alpha1.PartitionList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *topologyv1alpha1.Partition, err error)
	Apply(ctx context.Context, partition *applyconfigurationtopologyv1alpha1.PartitionApplyConfiguration, opts v1.ApplyOptions) (result *topologyv1alpha1.Partition, err error)
	PartitionExpansion
}

// partitions implements PartitionInterface
type partitions struct {
	*gentype.ClientWithListAndApply[*topologyv1alpha1.Partition, *topologyv1alpha1.PartitionList, *applyconfigurationtopologyv1alpha1.PartitionApplyConfiguration]
}

// newPartitions returns a Partitions
func newPartitions(c *TopologyV1alpha1Client) *partitions {
	return &partitions{
		gentype.NewClientWithListAndApply[*topologyv1alpha1.Partition, *topologyv1alpha1.PartitionList, *applyconfigurationtopologyv1alpha1.PartitionApplyConfiguration](
			"partitions",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *topologyv1alpha1.Partition { return &topologyv1alpha1.Partition{} },
			func() *topologyv1alpha1.PartitionList { return &topologyv1alpha1.PartitionList{} },
		),
	}
}
