/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	corev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	applyconfigurationcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/core/v1alpha1"
	scheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/scheme"
)

// LogicalClustersGetter has a method to return a LogicalClusterInterface.
// A group's client should implement this interface.
type LogicalClustersGetter interface {
	LogicalClusters() LogicalClusterInterface
}

// LogicalClusterInterface has methods to work with LogicalCluster resources.
type LogicalClusterInterface interface {
	Create(ctx context.Context, logicalCluster *corev1alpha1.LogicalCluster, opts v1.CreateOptions) (*corev1alpha1.LogicalCluster, error)
	Update(ctx context.Context, logicalCluster *corev1alpha1.LogicalCluster, opts v1.UpdateOptions) (*corev1alpha1.LogicalCluster, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, logicalCluster *corev1alpha1.LogicalCluster, opts v1.UpdateOptions) (*corev1alpha1.LogicalCluster, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*corev1alpha1.LogicalCluster, error)
	List(ctx context.Context, opts v1.ListOptions) (*corev1alpha1.LogicalClusterList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *corev1alpha1.LogicalCluster, err error)
	Apply(ctx context.Context, logicalCluster *applyconfigurationcorev1alpha1.LogicalClusterApplyConfiguration, opts v1.ApplyOptions) (result *corev1alpha1.LogicalCluster, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, logicalCluster *applyconfigurationcorev1alpha1.LogicalClusterApplyConfiguration, opts v1.ApplyOptions) (result *corev1alpha1.LogicalCluster, err error)
	LogicalClusterExpansion
}

// logicalClusters implements LogicalClusterInterface
type logicalClusters struct {
	*gentype.ClientWithListAndApply[*corev1alpha1.LogicalCluster, *corev1alpha1.LogicalClusterList, *applyconfigurationcorev1alpha1.LogicalClusterApplyConfiguration]
}

// newLogicalClusters returns a LogicalClusters
func newLogicalClusters(c *CoreV1alpha1Client) *logicalClusters {
	return &logicalClusters{
		gentype.NewClientWithListAndApply[*corev1alpha1.LogicalCluster, *corev1alpha1.LogicalClusterList, *applyconfigurationcorev1alpha1.LogicalClusterApplyConfiguration](
			"logicalclusters",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *corev1alpha1.LogicalCluster { return &corev1alpha1.LogicalCluster{} },
			func() *corev1alpha1.LogicalClusterList { return &corev1alpha1.LogicalClusterList{} },
		),
	}
}
