/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	applyconfigurationcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/cache/v1alpha1"
	scheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/scheme"
)

// CachedResourcesGetter has a method to return a CachedResourceInterface.
// A group's client should implement this interface.
type CachedResourcesGetter interface {
	CachedResources() CachedResourceInterface
}

// CachedResourceInterface has methods to work with CachedResource resources.
type CachedResourceInterface interface {
	Create(ctx context.Context, cachedResource *cachev1alpha1.CachedResource, opts v1.CreateOptions) (*cachev1alpha1.CachedResource, error)
	Update(ctx context.Context, cachedResource *cachev1alpha1.CachedResource, opts v1.UpdateOptions) (*cachev1alpha1.CachedResource, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, cachedResource *cachev1alpha1.CachedResource, opts v1.UpdateOptions) (*cachev1alpha1.CachedResource, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*cachev1alpha1.CachedResource, error)
	List(ctx context.Context, opts v1.ListOptions) (*cachev1alpha1.CachedResourceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *cachev1alpha1.CachedResource, err error)
	Apply(ctx context.Context, cachedResource *applyconfigurationcachev1alpha1.CachedResourceApplyConfiguration, opts v1.ApplyOptions) (result *cachev1alpha1.CachedResource, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, cachedResource *applyconfigurationcachev1alpha1.CachedResourceApplyConfiguration, opts v1.ApplyOptions) (result *cachev1alpha1.CachedResource, err error)
	CachedResourceExpansion
}

// cachedResources implements CachedResourceInterface
type cachedResources struct {
	*gentype.ClientWithListAndApply[*cachev1alpha1.CachedResource, *cachev1alpha1.CachedResourceList, *applyconfigurationcachev1alpha1.CachedResourceApplyConfiguration]
}

// newCachedResources returns a CachedResources
func newCachedResources(c *CacheV1alpha1Client) *cachedResources {
	return &cachedResources{
		gentype.NewClientWithListAndApply[*cachev1alpha1.CachedResource, *cachev1alpha1.CachedResourceList, *applyconfigurationcachev1alpha1.CachedResourceApplyConfiguration](
			"cachedresources",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *cachev1alpha1.CachedResource { return &cachev1alpha1.CachedResource{} },
			func() *cachev1alpha1.CachedResourceList { return &cachev1alpha1.CachedResourceList{} },
		),
	}
}
