/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	applyconfigurationapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha1"
	scheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/scheme"
)

// APIConversionsGetter has a method to return a APIConversionInterface.
// A group's client should implement this interface.
type APIConversionsGetter interface {
	APIConversions() APIConversionInterface
}

// APIConversionInterface has methods to work with APIConversion resources.
type APIConversionInterface interface {
	Create(ctx context.Context, aPIConversion *apisv1alpha1.APIConversion, opts v1.CreateOptions) (*apisv1alpha1.APIConversion, error)
	Update(ctx context.Context, aPIConversion *apisv1alpha1.APIConversion, opts v1.UpdateOptions) (*apisv1alpha1.APIConversion, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apisv1alpha1.APIConversion, error)
	List(ctx context.Context, opts v1.ListOptions) (*apisv1alpha1.APIConversionList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apisv1alpha1.APIConversion, err error)
	Apply(ctx context.Context, aPIConversion *applyconfigurationapisv1alpha1.APIConversionApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha1.APIConversion, err error)
	APIConversionExpansion
}

// aPIConversions implements APIConversionInterface
type aPIConversions struct {
	*gentype.ClientWithListAndApply[*apisv1alpha1.APIConversion, *apisv1alpha1.APIConversionList, *applyconfigurationapisv1alpha1.APIConversionApplyConfiguration]
}

// newAPIConversions returns a APIConversions
func newAPIConversions(c *ApisV1alpha1Client) *aPIConversions {
	return &aPIConversions{
		gentype.NewClientWithListAndApply[*apisv1alpha1.APIConversion, *apisv1alpha1.APIConversionList, *applyconfigurationapisv1alpha1.APIConversionApplyConfiguration](
			"apiconversions",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *apisv1alpha1.APIConversion { return &apisv1alpha1.APIConversion{} },
			func() *apisv1alpha1.APIConversionList { return &apisv1alpha1.APIConversionList{} },
		),
	}
}
