/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	topologyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/topology/v1alpha1"
	typedkcptopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/topology/v1alpha1"
	typedtopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/topology/v1alpha1"
)

// partitionClusterClient implements PartitionClusterInterface
type partitionClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*topologyv1alpha1.Partition, *topologyv1alpha1.PartitionList]
	Fake *kcptesting.Fake
}

func newFakePartitionClusterClient(fake *TopologyV1alpha1ClusterClient) typedkcptopologyv1alpha1.PartitionClusterInterface {
	return &partitionClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*topologyv1alpha1.Partition, *topologyv1alpha1.PartitionList](
			fake.Fake,
			topologyv1alpha1.SchemeGroupVersion.WithResource("partitions"),
			topologyv1alpha1.SchemeGroupVersion.WithKind("Partition"),
			func() *topologyv1alpha1.Partition { return &topologyv1alpha1.Partition{} },
			func() *topologyv1alpha1.PartitionList { return &topologyv1alpha1.PartitionList{} },
			func(dst, src *topologyv1alpha1.PartitionList) { dst.ListMeta = src.ListMeta },
			func(list *topologyv1alpha1.PartitionList) []*topologyv1alpha1.Partition {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *topologyv1alpha1.PartitionList, items []*topologyv1alpha1.Partition) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *partitionClusterClient) Cluster(cluster logicalcluster.Path) typedtopologyv1alpha1.PartitionInterface {
	return newFakePartitionClient(c.Fake, cluster)
}

// partitionScopedClient implements PartitionInterface
type partitionScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*topologyv1alpha1.Partition, *topologyv1alpha1.PartitionList, *kcpv1alpha1.PartitionApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakePartitionClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedtopologyv1alpha1.PartitionInterface {
	return &partitionScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*topologyv1alpha1.Partition, *topologyv1alpha1.PartitionList, *kcpv1alpha1.PartitionApplyConfiguration](
			fake,
			clusterPath,
			"",
			topologyv1alpha1.SchemeGroupVersion.WithResource("partitions"),
			topologyv1alpha1.SchemeGroupVersion.WithKind("Partition"),
			func() *topologyv1alpha1.Partition { return &topologyv1alpha1.Partition{} },
			func() *topologyv1alpha1.PartitionList { return &topologyv1alpha1.PartitionList{} },
			func(dst, src *topologyv1alpha1.PartitionList) { dst.ListMeta = src.ListMeta },
			func(list *topologyv1alpha1.PartitionList) []*topologyv1alpha1.Partition {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *topologyv1alpha1.PartitionList, items []*topologyv1alpha1.Partition) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
