/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	corev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/core/v1alpha1"
	typedkcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/core/v1alpha1"
	typedcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/core/v1alpha1"
)

// shardClusterClient implements ShardClusterInterface
type shardClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*corev1alpha1.Shard, *corev1alpha1.ShardList]
	Fake *kcptesting.Fake
}

func newFakeShardClusterClient(fake *CoreV1alpha1ClusterClient) typedkcpcorev1alpha1.ShardClusterInterface {
	return &shardClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*corev1alpha1.Shard, *corev1alpha1.ShardList](
			fake.Fake,
			corev1alpha1.SchemeGroupVersion.WithResource("shards"),
			corev1alpha1.SchemeGroupVersion.WithKind("Shard"),
			func() *corev1alpha1.Shard { return &corev1alpha1.Shard{} },
			func() *corev1alpha1.ShardList { return &corev1alpha1.ShardList{} },
			func(dst, src *corev1alpha1.ShardList) { dst.ListMeta = src.ListMeta },
			func(list *corev1alpha1.ShardList) []*corev1alpha1.Shard { return kcpgentype.ToPointerSlice(list.Items) },
			func(list *corev1alpha1.ShardList, items []*corev1alpha1.Shard) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *shardClusterClient) Cluster(cluster logicalcluster.Path) typedcorev1alpha1.ShardInterface {
	return newFakeShardClient(c.Fake, cluster)
}

// shardScopedClient implements ShardInterface
type shardScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*corev1alpha1.Shard, *corev1alpha1.ShardList, *kcpv1alpha1.ShardApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeShardClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedcorev1alpha1.ShardInterface {
	return &shardScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*corev1alpha1.Shard, *corev1alpha1.ShardList, *kcpv1alpha1.ShardApplyConfiguration](
			fake,
			clusterPath,
			"",
			corev1alpha1.SchemeGroupVersion.WithResource("shards"),
			corev1alpha1.SchemeGroupVersion.WithKind("Shard"),
			func() *corev1alpha1.Shard { return &corev1alpha1.Shard{} },
			func() *corev1alpha1.ShardList { return &corev1alpha1.ShardList{} },
			func(dst, src *corev1alpha1.ShardList) { dst.ListMeta = src.ListMeta },
			func(list *corev1alpha1.ShardList) []*corev1alpha1.Shard { return kcpgentype.ToPointerSlice(list.Items) },
			func(list *corev1alpha1.ShardList, items []*corev1alpha1.Shard) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
