/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	corev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/core/v1alpha1"
	typedkcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/core/v1alpha1"
	typedcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/core/v1alpha1"
)

// logicalClusterClusterClient implements LogicalClusterClusterInterface
type logicalClusterClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*corev1alpha1.LogicalCluster, *corev1alpha1.LogicalClusterList]
	Fake *kcptesting.Fake
}

func newFakeLogicalClusterClusterClient(fake *CoreV1alpha1ClusterClient) typedkcpcorev1alpha1.LogicalClusterClusterInterface {
	return &logicalClusterClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*corev1alpha1.LogicalCluster, *corev1alpha1.LogicalClusterList](
			fake.Fake,
			corev1alpha1.SchemeGroupVersion.WithResource("logicalclusters"),
			corev1alpha1.SchemeGroupVersion.WithKind("LogicalCluster"),
			func() *corev1alpha1.LogicalCluster { return &corev1alpha1.LogicalCluster{} },
			func() *corev1alpha1.LogicalClusterList { return &corev1alpha1.LogicalClusterList{} },
			func(dst, src *corev1alpha1.LogicalClusterList) { dst.ListMeta = src.ListMeta },
			func(list *corev1alpha1.LogicalClusterList) []*corev1alpha1.LogicalCluster {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *corev1alpha1.LogicalClusterList, items []*corev1alpha1.LogicalCluster) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *logicalClusterClusterClient) Cluster(cluster logicalcluster.Path) typedcorev1alpha1.LogicalClusterInterface {
	return newFakeLogicalClusterClient(c.Fake, cluster)
}

// logicalClusterScopedClient implements LogicalClusterInterface
type logicalClusterScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*corev1alpha1.LogicalCluster, *corev1alpha1.LogicalClusterList, *kcpv1alpha1.LogicalClusterApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeLogicalClusterClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedcorev1alpha1.LogicalClusterInterface {
	return &logicalClusterScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*corev1alpha1.LogicalCluster, *corev1alpha1.LogicalClusterList, *kcpv1alpha1.LogicalClusterApplyConfiguration](
			fake,
			clusterPath,
			"",
			corev1alpha1.SchemeGroupVersion.WithResource("logicalclusters"),
			corev1alpha1.SchemeGroupVersion.WithKind("LogicalCluster"),
			func() *corev1alpha1.LogicalCluster { return &corev1alpha1.LogicalCluster{} },
			func() *corev1alpha1.LogicalClusterList { return &corev1alpha1.LogicalClusterList{} },
			func(dst, src *corev1alpha1.LogicalClusterList) { dst.ListMeta = src.ListMeta },
			func(list *corev1alpha1.LogicalClusterList) []*corev1alpha1.LogicalCluster {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *corev1alpha1.LogicalClusterList, items []*corev1alpha1.LogicalCluster) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
