/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	rest "k8s.io/client-go/rest"

	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/core/v1alpha1"
	corev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/core/v1alpha1"
)

var _ kcpcorev1alpha1.CoreV1alpha1ClusterInterface = (*CoreV1alpha1ClusterClient)(nil)

type CoreV1alpha1ClusterClient struct {
	*kcptesting.Fake
}

func (c *CoreV1alpha1ClusterClient) Cluster(clusterPath logicalcluster.Path) corev1alpha1.CoreV1alpha1Interface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}
	return &CoreV1alpha1Client{Fake: c.Fake, ClusterPath: clusterPath}
}

func (c *CoreV1alpha1ClusterClient) LogicalClusters() kcpcorev1alpha1.LogicalClusterClusterInterface {
	return newFakeLogicalClusterClusterClient(c)
}

func (c *CoreV1alpha1ClusterClient) Shards() kcpcorev1alpha1.ShardClusterInterface {
	return newFakeShardClusterClient(c)
}

type CoreV1alpha1Client struct {
	*kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func (c *CoreV1alpha1Client) LogicalClusters() corev1alpha1.LogicalClusterInterface {
	return newFakeLogicalClusterClient(c.Fake, c.ClusterPath)
}

func (c *CoreV1alpha1Client) Shards() corev1alpha1.ShardInterface {
	return newFakeShardClient(c.Fake, c.ClusterPath)
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *CoreV1alpha1Client) RESTClient() rest.Interface {
	var ret *rest.RESTClient
	return ret
}
