/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/cache/v1alpha1"
	typedkcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/cache/v1alpha1"
	typedcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/cache/v1alpha1"
)

// cachedObjectClusterClient implements CachedObjectClusterInterface
type cachedObjectClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*cachev1alpha1.CachedObject, *cachev1alpha1.CachedObjectList]
	Fake *kcptesting.Fake
}

func newFakeCachedObjectClusterClient(fake *CacheV1alpha1ClusterClient) typedkcpcachev1alpha1.CachedObjectClusterInterface {
	return &cachedObjectClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*cachev1alpha1.CachedObject, *cachev1alpha1.CachedObjectList](
			fake.Fake,
			cachev1alpha1.SchemeGroupVersion.WithResource("cachedobjects"),
			cachev1alpha1.SchemeGroupVersion.WithKind("CachedObject"),
			func() *cachev1alpha1.CachedObject { return &cachev1alpha1.CachedObject{} },
			func() *cachev1alpha1.CachedObjectList { return &cachev1alpha1.CachedObjectList{} },
			func(dst, src *cachev1alpha1.CachedObjectList) { dst.ListMeta = src.ListMeta },
			func(list *cachev1alpha1.CachedObjectList) []*cachev1alpha1.CachedObject {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *cachev1alpha1.CachedObjectList, items []*cachev1alpha1.CachedObject) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *cachedObjectClusterClient) Cluster(cluster logicalcluster.Path) typedcachev1alpha1.CachedObjectInterface {
	return newFakeCachedObjectClient(c.Fake, cluster)
}

// cachedObjectScopedClient implements CachedObjectInterface
type cachedObjectScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*cachev1alpha1.CachedObject, *cachev1alpha1.CachedObjectList, *kcpv1alpha1.CachedObjectApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeCachedObjectClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedcachev1alpha1.CachedObjectInterface {
	return &cachedObjectScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*cachev1alpha1.CachedObject, *cachev1alpha1.CachedObjectList, *kcpv1alpha1.CachedObjectApplyConfiguration](
			fake,
			clusterPath,
			"",
			cachev1alpha1.SchemeGroupVersion.WithResource("cachedobjects"),
			cachev1alpha1.SchemeGroupVersion.WithKind("CachedObject"),
			func() *cachev1alpha1.CachedObject { return &cachev1alpha1.CachedObject{} },
			func() *cachev1alpha1.CachedObjectList { return &cachev1alpha1.CachedObjectList{} },
			func(dst, src *cachev1alpha1.CachedObjectList) { dst.ListMeta = src.ListMeta },
			func(list *cachev1alpha1.CachedObjectList) []*cachev1alpha1.CachedObject {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *cachev1alpha1.CachedObjectList, items []*cachev1alpha1.CachedObject) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
